


export class SlotplanPricetypeEditWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/sales/slotplan/')}}" class="fa fa-chevron-circle-left"></a>
				<span ez-if="isNew == false">
					<a href="javascript:void(0);" [onclick]="widget.deletePricetype" class="fa fa-trash"></a>
				</span>
				<a href="javascript:void(0);" [onclick]="widget.savePricetype" class="fa fa-save"></a>
			</div>
			<h1>{{isNew?'Nieuw Prijstype':'Bewerk Prijstype'}}</h1>
		</div>
		
		
		<form id="frmPricetype" action="{{appUrl('/service/sales/slot/pricetype.do')}}">
			<input type="hidden" name="a" value="save" />
			
			<input type="hidden" name="slotplanPricetypeId" value="{{p.slotplanPricetypeId}}" />
			
			<ez-checkbox name="active" label="Actief" [checked]="p.active"></ez-checkbox>
			
			<ez-text name="name" label="Naam" [value]="p.name"></ez-text>
			
			<ez-datetime-text label="Bewerkt op" hideempty="1" [value]="p.edited"></ez-datetime-text>
		</form>
	`;
	
	container = null;
	loading = false;
	
	ezTpl = null;
	pricetype = {
		name: '',
		active: true
	};
	
	isNew = false;
	
	init(e) {
		this.container = e;
		
		let id = getUrlParam('id');
		
		if (id) {
			this.loadPricetype( id );
		}
		else {
			this.isNew = true;
			this.render();
		}
	}
	
	render() {
//		console.log( this.tpl );
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setVar('p', this.pricetype);
		this.ezTpl.setVar('isNew', this.isNew);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.render();
		
		focusFirstField( '#frmPricetype' );
	}
	
	
	savePricetype() {
		if (this.loading) {
			return;
		}
		
		this.loading = true;
		
		postForm('#frmPricetype').then(async function(e) {
			
			let json = await e.json();
			console.log( json );
			
			if (json.error) {
				// TODO: render errors
				formShowErrors( '#frmPricetype', json );
				
			}
			else {
				// report succesfully saved
				reportUserMessage( 'Wijzigingen opgeslagen' );
				
				// reload data
				gotoRoute( '/masterdata/sales/slotplan/pricetype/edit/?id=' + json.slotplanPricetypeId );
			}
			
			this.loading = false;
		}.bind(this)).catch(showErrorWidget);
	}
	
	deletePricetype() {
		showConfirmation('Verwijderen', 'Weet je zeker dat je deze prijstype wilt verwijderen?', function() {
			
			postUrl( '/service/sales/slot/pricetype.do', {
				a: 'delete',
				slotplanPricetypeId: this.pricetype.slotplanPricetypeId
			}).then( async function(e) {
				let json = await e.json();
				if (json.error) {
					showAlert('Error', 'Error: ' + e.message);
					return;
				}
				
				gotoRoute( '/masterdata/sales/slotplan/' );
			}.bind(this));
			
		}.bind(this));
	}
	
	
	
	loadPricetype(slotplanPricetypeId) {
		postUrl( '/service/sales/slot/pricetype.do', {
			a: 'view',
			slotplanPricetypeId: slotplanPricetypeId
		}).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget(json);
			}
			
			this.pricetype = json.pricetype;
			this.render();
			
			this.loading = false;
		}.bind(this) );
	}
	
}


