
import { CustomerView } from '../../customers/CustomerView.js';


export class SalesCheckoutOverviewWidget {
	
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0)" [onclick]="widget.prevPage" class="fa fa-chevron-circle-left"></a>
			</div>
			<h1>Overzicht</h1>
		</div>
		
		<div id="customer-view"></div>
		
		
		<div class="action-box clear">
			<span>
				<a href="javascript:void(0);" [onclick]="widget.book">Inboeken</a>
			</span>
		</div>
		
	`;
	
	
	container = null;
	ezTpl = null;
	
	uid = null;
	session = null;
	
	constructor( scw ) {
		this.uid = scw.uid;
		this.session = scw.session;
	}

	
	init(e) {
		this.container = e;
	}
	
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setObject('widget', this);
		
		// customer stuff
		let newCustomer = this.session.customerMode == 'new' ? true : false;
		this.ezTpl.setVar('newCustomer', newCustomer);
		if (newCustomer) {
			this.ezTpl.setVar('customer', this.session.newCustomer);
		}
		else {
			this.ezTpl.setVar('customer', this.session.customer);
		}
		
		
		// checkout articles
		this.ezTpl.setVar('articles', this.session.articles);
		
		
		
		this.ezTpl.render();
		
		
		// render customer
		let c = newCustomer ? this.session.newCustomer : this.session.customer;
		let cv = new CustomerView( c );
		cv.render( document.querySelector('#customer-view') );
	}
	
	
	
	prevPage() {
		gotoRoute( '/sales/salesplan/checkout/customer/?uid='+this.uid );
	}
	
	
}

