

import { ArticleSearchPopup } from '.../../article/ArticleSearchPopup.js';


export class SalesCheckoutArticlesWidget {
	
	
	tpl = `
		<div class="page-header">
		
			<div class="toolbox">
				<a href="javascript:void(0);" [onclick]="widget.prevPage" class="fa fa-chevron-circle-left"></a>
				<a href="javascript:void(0);" [onclick]="widget.nextPage" class="fa fa-chevron-circle-right"></a>
			</div>
		
			<h1>Checkout</h1>
		</div>
		
		
		<table style="width: 100%;" class="sales-planbord-checkout">
			<thead>
				<tr>
					<th class="th-sort"></th>
					<th class="th-description">Artikel</th>
					<th class="th-amount">Periode / Aantal</th>
					<th class="th-price">Bedrag</th>
					<th class="th-vat">Btw</th>
					<th class="th-total">Totaal</th>
					<th class="th-del"></th>
				</tr>
			</thead>
			
			<tbody id="article-lines"> </tbody>
			<tfoot>
				<tr>
					<td class="col-sort"></td>
					<td class="col-description"></td>
					<td class="col-amount"></td>
					<td class="col-price"></td>
					<td class="col-vat"></td>
					<td class="col-total"></td>
					<td></td>
				</tr>
			</tfoot>
		</table>
		
		<hr />
		
		<div class="action-box">
			<span style="float: right;"><a href="javascript:void(0);" [onclick]="widget.createCustomer">Verder</a></span>
			
			<span><a href="javascript:void(0);" [onclick]="widget.addArticle">Artikel toevoegen</a></span>
			
			<span><a href="javascript:void(0);" [onclick]="widget.addPriceLine">Prijsregel toevoegen</a></span>
			
			<span><a href="javascript:void(0);" [onclick]="widget.addTextLine">Tekstregel toevoegen</a></span>
		</div>
	`;
	
	
	container = null;
	
	
	ezTpl = null;
	uid = null;
	session = null;
	
	callback_selectCustomer = null;
	
	vats = null;
	salesSettings = null;
	
	
	constructor( scw ) {
		this.uid = scw.uid;
		this.session = scw.session;
	}
	
	
	init(c) {
		this.container = c;
		
		
//		this.render();
		this.loadConfig();
	}
	
	loadConfig() {
		postUrl('/service/sales/plan.do', {
			a: 'config'
		}).then( async function(e) {
			let json = await e.json();
			this.vats = json.vats;
			this.salesSettings = json.salesSettings;
			
			this.render();
		}.bind(this));
	}
	
	
	setCallbackSelectCustomer(callback) { this.callback_selectCustomer = callback; }
	
	
	buildArticleVars() {
		
		let arts = this.session.articles;
		
		arts = arts.sort(function(f1, f2) {
			if ( f1.article.shortDescription != f2.article.shortDescription ) {
				if (f1.article.shortDescription < f2.article.shortDescription) {
					return -1;
				}
				else {
					return 1;
				}
			}
			if (f1.day.ymd != f2.day.ymd) {
				if (f1.day.ymd < f2.day.ymd) {
					return -1;
				}
				else {
					return 1;
				}
			}
			if (typeof f1.slotitemHour != 'undefined' && typeof f2.slotitemHour != 'undefined') {
				if (f1.slotitemHour.startTime < f2.slotitemHour.startTime) {
					return -1;
				}
				else {
					return 1;
				}
			}
			
			return 0;
		});
		

		this.ezTpl.setVar('articles', arts);
		
		return arts;
	}
	
	
	addArticle() {
		let p = new ArticleSearchPopup();
		
		
		p.setSelectArticle(function(article) {
			let price;
			if (this.salesSettings.inputPrice == 'incl_vat') {
				price = article.line_price_incl_vat;
			}
			else {
				price = article.line_price_excl_vat;
			}
			
			let pricetypeId = 0;
			if ( article.selectedSlotplan ) {
				pricetypeId = article.selectedSlotplan.slotplanPricetypeId;
			}
			
			this.createLine({
				lineType: 'article',
				articleId: article.articleId,
				pricetypeId: pricetypeId,
				shortDescription: article.line_description,
				price: price,
				amount: 1,
				vatId: article.vatId
			});
		}.bind(this));
		
		p.show();
	}
	
	
	addPriceLine() {
		this.createLine({
			lineType: 'price'
		});
	}
	
	addTextLine() {
		this.createLine({
			lineType: 'text',
			shortDescription: '',
			shortDescription2: ''
		});
	}
	
	
	
	createLine( opts ) {
		let ln = this.lineNo++;
		
		let c = $('<tr />');
		c.addClass('sales-line');
		c.addClass('line-no-' + ln);
		c.data('line-no', ln);
		c.data('line-type', opts.lineType);
		
		let tdSort = $('<td class="col-sort"><span class="fa fa-bars sort-handle"></span></td>');
		let tdDel = $('<div class="col-delete-line"><a href="javascript:void(0);" class="fa fa-remove delete-line"></a></div>');
		
		if (opts.lineType == 'rental') {
			
			let art = opts.article;
//			console.log('art', art);
			
			let tdDesc1 = $('<td class="col-description1" />');
			let tdDate  = $('<td class="col-amount" />');
			let tdPrice = $('<td class="col-price" />');
			let tdVat   = $('<td class="col-vat" />');
			let tdTotal = $('<td class="col-total" />');
			
			tdDesc1.text( art.shortDescription );
			
			let inpPrice = $('<input type="text" />');
			inpPrice.addClass( 'art-price-'+opts.pos );
			tdPrice.append( inpPrice );

			let sa = new SalesArticle(art, {
				slotitemHour: opts.slotitemHour,
				salesSettings: this.salesSettings
			});
				
			
			if (art.pricingMethod == 'slotplan') {
				let t = '';
				t += format_datetext_short( new Date(opts.day.date) );
				t += ', ';
				t += opts.slotitemHour.startTime;
				t += ' - ';
				t += minutes2human(opts.slotitemHour.duration*2);
				
				tdDate.text( t );
				
				
				let sa = new SalesArticle(art, {
					slotitemHour: opts.slotitemHour,
					salesSettings: this.salesSettings
				});
				
			}
			else {
				let inpStart = $('<input type="text" class="input-pickadate" />');
				inpStart.addClass('art-start-' + opts.pos);
				inpStart.val( format_date( new Date(opts.day.date), {dmy: true} ) );
				
				let inpEnd = $('<input type="text" class="input-pickadate" />');
				inpEnd.addClass('art-end-' + opts.pos);
				
				tdDate.append( inpStart );
				tdDate.append( ' t/m ' );
				tdDate.append( inpEnd );
			}
	
			let p = sa.getPrice();
			inpPrice.val(p);

			
			
			c.append( tdSort );
			c.append( tdDesc1 );
			c.append( tdDate );
			c.append( tdPrice );
			c.append( tdVat );
			c.append( tdTotal );
//			c.append( tdDel );
		}
		
		
		if (opts.lineType == 'text') {
			c.addClass('sales-line-text');
			
			let tdDesc1 = $('<td class="col-description12" colspan="5"></td>');
			let inpDesc1 = $('<input type="text" />');
			inpDesc1.attr('name', 'sl_description1_'+ln);
			inpDesc1.val( opts.shortDescription );
			tdDesc1.append( inpDesc1 );
			
			let inpDesc2 = $('<input type="text" />');
			inpDesc2.attr('name', 'sl_description2_'+ln);
			inpDesc2.val( opts.shortDescription2 );
			tdDesc1.append( inpDesc2 );
			
			
			c.append( tdSort );
			c.append( tdDesc1 );
			c.append( tdDel );
		}
		
		if (opts.lineType == 'price') {
			c.addClass('sales-line-price');
			
			let tdDesc = $('<td class="col-description"></td>');
			let inp_description = $('<input type="text" />');
			inp_description.attr('name', 'sl_description_'+ln);
			inp_description.val( opts.shortDescription );
			tdDesc.append( inp_description );
			
			let tdAmount = $('<td class="col-amount"></td>');
			let inp_amount = $('<input type="text" />');
			inp_amount.attr('name', 'sl_amount_'+ln);
			inp_amount.val( opts.amount ?? 1 );
			tdAmount.append( inp_amount );
			
			let tdPrice = $('<td class="col-price"></td>');
			let inp_price = $('<input type="text" class="format-price" />');
			inp_price.attr('name', 'sl_price_'+ln);
			inp_price.val( opts.price );
			tdPrice.append( inp_price );
			
			
			let tdVat = $('<td class="col-vat"></td>');
			let inp_vat = this.buildVatSelect( opts.vatPercentage );
			inp_vat.attr('name', 'sl_vat_'+ln);
			tdVat.append( inp_vat );
			
			let tdTotal = $('<td class="col-total"></td>');
			
			c.append( tdSort );
			c.append( tdDesc );
			c.append( tdAmount );
			c.append( tdPrice );
			c.append( tdVat );
			c.append( tdTotal );
			c.append( tdDel );
		}
		
		if (opts.lineType == 'article') {
			c.addClass('sales-line-article');
			
			c.data('article-id', opts.articleId);
			c.data('pricetype-id', opts.pricetypeId);
			
			let tdDesc = $('<td class="col-description"></td>');
			tdDesc.text( opts.shortDescription );
			
			let tdAmount = $('<td class="col-amount"></td>');
			let inp_amount = $('<input type="text" />');
			inp_amount.attr('name', 'sl_amount_'+ln);
			inp_amount.val(opts.amount);
			tdAmount.append( inp_amount );
			
			let tdPrice = $('<td class="col-price"></td>');
			let inp_price = $('<input type="text" class="format-price" />');
			inp_price.attr('name', 'sl_price_'+ln);
			inp_price.val( opts.price );
			tdPrice.append( inp_price );
			
			
			let tdVat = $('<td class="col-vat"></td>');
			let inp_vat = this.buildVatSelect( opts.vatPercentage );
			inp_vat.attr('name', 'sl_vat_'+ln);
			tdVat.append( inp_vat );

			
			let tdTotal = $('<td class="col-total"></td>');
			
			c.append( tdSort );
			c.append( tdDesc );
			c.append( tdAmount );
			c.append( tdPrice );
			c.append( tdVat );
			c.append( tdTotal );
			c.append( tdDel );
		}
		
		c.data('line-type', opts.type);
		
		$(c).find('.delete-line').on('click', function(evt) {
			
			let sl = $(evt.target).closest('.sales-line');
			
			if (sl.data('line-type') == 'rental')
				return;
			
			sl.remove();
			this.calculateTotals();
		}.bind(this));
		
		$(c).find('input, select').on('change', function() {
			this.calculateTotals();
		}.bind(this));
		
		$('#article-lines').append( c );
		
		this.calculateTotals();
	}
	
	
	buildVatSelect( vatPercentage ) {
		let selectedVatId = null;
		
		// lookup default vatId
		for(let i in this.vats) {
			if ( this.vats[i].defaultSelected ) {
				selectedVatId = this.vats[i].vatId;
				break;
			}
		}
		
		let addVatPercentage = false;
		if (typeof vatPercentage != 'undefined') {
			addVatPercentage = true;
			
			let p = parseInt(vatPercentage * 100);
			for(let i in this.vats) {
				if ( parseInt(this.vats[i].percentage * 100) == p  ) {
					selectedVatId = this.vats[i].vatId;
					addVatPercentage = false;
					break;
				}
			}
		}
		
		let inp_vat = $('<select class="" />');
		for(let i in this.vats) {
			let opt = $('<option />');
			opt.data('vat', this.vats[i]);
			opt.data('vatPercentage', this.vats[i].percentage);
			opt.val( this.vats[i].vatId );
			opt.text( this.vats[i].description );
			if (this.vats[i].vatId == selectedVatId)
				opt.prop('selected', true);
			inp_vat.append( opt );
		}
		
		// old percentage thats not in system anymore? => add
		if (addVatPercentage) {
			let opt = $('<option />');
			opt.data('vatPercentage', vatPercentage);
			opt.val( -1 );
			opt.text( vatPercentage + '%' );
			opt.prop('selected', true);
			inp_vat.append( opt );
		}
		
		
		return inp_vat;
	}
	
	
	
	calculateTotals() {
		
		let v = 0;
		
		let inputPrice = this.salesSettings.inputPrice;
		
		$('.sales-planbord-checkout #article-lines tr').each(function(index, node) {
			
			let lt = $(node).data('line-type');
			let amount = 1;
			
			if (lt == 'rental') {
				// day/week/month? => do something with dates ;)
				
				// slot? => just price..
				
			}
			else if (lt == 'article' || lt == 'price') {
				let amount = strtodouble( $(node).find('.col-amount input').val() );
				let price = strtodouble( $(node).find('.col-price input').val() );
				let objVat = $(node).find('.col-vat select option:selected');
				let vat = objVat.data('percentage');
				
				let totalP = 0;
				if (this.salesSettings.inputPrice == 'incl_vat') {
					totalP = amount * price;
				}
				else {
					totalP = amount * price;
					totalP = totalP + (totalP * vat / 100);
				}
				$(node).find('.col-total').text( format_price(totalP, true) );
			}
			
			let p = $(node).find('.col-price input').val();
			p = strtodouble( p );
			
			
		}.bind(this));
		
		
	}
	
	
	
	
	prevPage() {
		gotoRoute( '/sales/salesplan/?uid=' + this.uid);
	}
	
	nextPage() {
		this.createCustomer();
	}
	
	createCustomer() {
		this.callback_selectCustomer();
	}
	
	
	
	
	render() {
		if (this.salesSettings == null)
			return;
		
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		
		let articles = this.buildArticleVars();
		
		this.ezTpl.setObject('widget', this);
		this.ezTpl.render();
		
		
		$('tbody#article-lines').sortable( {
			handle: 'td.col-sort'
		});
		
		for(let i in articles) {
//			console.log('articles[i]', articles[i]);
			this.createLine({
				lineType: 'rental',
				article: articles[i].article,
				day: articles[i].day,
				pos: articles[i].pos,
				slotitemHour: articles[i].slotitemHour		// might be undefined
			});
		}
		
		
	}

}


