


export class SlotplanDayWidget {
	
	
	tpl = `
		<table class="tbl-slotplan-day">
			<thead>
				<tr ez-for="days" ez-item="d">
					<th class="{{d.dateSelected?'selected':''}}">{{d.dateText}}</th>
				</tr>
			</thead>
			<tbody>
				<tr ez-for="days" ez-item="d">
					<td>
						<div ez-if="d.active">
							<input type="checkbox"
									class="slot-day" 
									[date]="d" />
						</div>
					</td>
				</tr>
			</tbody>
		</table>
	`;
	
	
	container = null;
	
	slotplan = null;
	
	date = null;
	
	
	
	constructor( slotplan ) {
		this.slotplan = slotplan;
	}
	
	
	
	getSelectedSlots() {
		let slots = [];
		
		$(this.container).find('.slot-day:checked').each((index, node) => {
			let d = node.date;
			
			slots.push({
				start: d.date,
				end: d.date
			});
		});
		
		return slots;
	}
	
	
	init(e) {
		this.container = e;
	}
	
	setDate(d) { this.date = d; }
	
	getSlotitemDay( dayno ) {
		for(let i in this.slotplan.slotitemDays ) {
			if (this.slotplan.slotitemDays[i].dayno == dayno)
				return this.slotplan.slotitemDays[i];
		}
		return null;
	}
	
	render() {
		let days = [];
		
		let ymdDate = date2ymd(this.date);
		
		let sow = start_of_week( this.date );
		for(let i=1; i <= 7; i++) {
			let slotitemDay = this.getSlotitemDay(i);
			
			let d = str2date(sow);
			
			days.push({
				date: str2date(sow),
				dateText: d.getDate() + ' ' + _('monthshort.'+(d.getMonth()+1)) + ' ' + d.getFullYear(),
				slotitem: slotitemDay,
				active: slotitemDay && slotitemDay.active ? true : false,
				dateSelected: date2ymd(d) == ymdDate ? true : false
			});
			
			sow = next_day( sow );
		}
		
		
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('days', days);
		eztpl.render();
		
		
	}
	
}



