



export class OfferListWidget {
	
	container = null;
	vats = null;
	
	salesSettings = null;
	ezTpl = null;
	
	pageNo = 0;
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/sales/offer/edit/')}}" class="fa fa-plus"></a>
			</div>
			
			<h1>Offertes</h1>
		</div>
		
		<div ez-if="offers == null">
			Loading...
		</div>
		<div ez-if="offers != null">
			<table class="table">
				<thead>
					<tr>
						<th>Offerte Nr</th>
						<th>Klant</th>
						<th>Omschrijving</th>
						<th>Bedrag {{amountNote}}</th>
						<th>Status</th>
						<th>Datum</th>
					</tr>
				</thead>
				<tbody  ez-for="offers" ez-item="o" class="tbody-offers">
					<tr [onclick]="widget.editOffer" class="pointer" offer-id="{{o.offerId}}">
						<td>{{o.offerNumber}}</td>
						<td>{{o.customerName}}</td>
						<td>{{o.subject}}</td>
						<td>
						
							{{ priceExcl ? o.totalCalculatedPrice : o.totalCalculatedPriceInclVat }}
						</td>
						<td>{{_('offerStatus.'+o.offerStatus)}}</td>
						<td>{{ format_date(o.offerDate, {dmy:true})}}</td>
					</tr>
				</tbody>
					
				<tbody ez-if="offers.length == 0">
					<tr>
						<td colspan="6" class="no-results">
							Geen resultaten gevonden
						</td>
					</tr>
				</tbody>
			</table>
			
			<ez-pager></ez-pager>
		</div>
	`;
	
	
	editOffer(evt, tr) {
		let oid = tr.getAttribute('offer-id');
		
		gotoRoute( '/sales/offer/edit/?id='+oid );
	}


	selectPage(pageNo) {
		this.pageNo = pageNo;
		this.searchOffers();
	}

	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('offers', this.offers);
		
		if (this.salesSettings && this.salesSettings.inputPrice == 'excl_vat') {
			this.ezTpl.setVar('amountNote', '(excl)');
			this.ezTpl.setVar('priceExcl', true);
			this.ezTpl.setVar('priceIncl', false);
		}
		if (this.salesSettings && this.salesSettings.inputPrice == 'incl_vat') {
			this.ezTpl.setVar('amountNote', '(incl)');
			this.ezTpl.setVar('priceExcl', false);
			this.ezTpl.setVar('priceIncl', true);
		}
		
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
	}
	
	
	
	searchOffers() {
		postUrl( '/service/sales/offer.do', {
			a: 'search',
			pageNo: this.pageNo
		}).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget( json );
			}
			
			this.salesSettings = json.salesSettings;
			this.offers = json.offers;
			this.render();
			
		}.bind(this) );
	}
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		
		this.searchOffers();
	}

}

