



export class InvoiceListWidget {
	
	container = null;
	vats = null;
	
	salesSettings = null;
	ezTpl = null;
	
	pageNo = 0;
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/sales/invoice/edit/')}}" class="fa fa-plus"></a>
			</div>
			
			<h1>Facturen</h1>
		</div>
		
		<div ez-if="invoices == null">
			Loading...
		</div>
		<div ez-if="invoices != null">
			<table class="table">
				<thead>
					<tr>
						<th>Factuur Nr</th>
						<th>Klant</th>
						<th>Omschrijving</th>
						<th>Bedrag {{amountNote}}</th>
						<th>Status</th>
						<th>Datum</th>
					</tr>
				</thead>
				<tbody  ez-for="invoices" ez-item="o" class="tbody-invoices">
					<tr [onclick]="widget.editInvoice" class="pointer" invoice-id="{{o.invoiceId}}">
						<td>{{o.invoiceNumber}}</td>
						<td>{{o.customerName}}</td>
						<td>{{o.subject}}</td>
						<td>
						
							{{ priceExcl ? o.totalCalculatedPrice : o.totalCalculatedPriceInclVat }}
						</td>
						<td>{{_('invoiceStatus.'+o.invoiceStatus)}}</td>
						<td>{{ format_date(o.invoiceDate, {dmy:true})}}</td>
					</tr>
				</tbody>
					
				<tbody ez-if="invoices.length == 0">
					<tr>
						<td colspan="6" class="no-results">
							Geen resultaten gevonden
						</td>
					</tr>
				</tbody>
			</table>
			
			<ez-pager></ez-pager>
		</div>
	`;
	
	
	editInvoice(evt, tr) {
		let oid = tr.getAttribute('invoice-id');
		
		gotoRoute( '/sales/invoice/edit/?id='+oid );
	}


	selectPage(pageNo) {
		this.pageNo = pageNo;
		this.searchInvoices();
	}

	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('invoices', this.invoices);
		
		if (this.salesSettings && this.salesSettings.inputPrice == 'excl_vat') {
			this.ezTpl.setVar('amountNote', '(excl)');
			this.ezTpl.setVar('priceExcl', true);
			this.ezTpl.setVar('priceIncl', false);
		}
		if (this.salesSettings && this.salesSettings.inputPrice == 'incl_vat') {
			this.ezTpl.setVar('amountNote', '(incl)');
			this.ezTpl.setVar('priceExcl', false);
			this.ezTpl.setVar('priceIncl', true);
		}
		
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
	}
	
	
	
	searchInvoices() {
		postUrl( '/service/sales/invoice.do', {
			a: 'search',
			pageNo: this.pageNo
		}).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget( json );
			}
			
			this.salesSettings = json.salesSettings;
			this.invoices = json.invoices;
			this.render();
			
		}.bind(this) );
	}
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		
		this.searchInvoices();
	}

}

