
import { ArticleSearchPopup } from '../article/ArticleSearchPopup.js';



export class InvoiceEditWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/sales/invoice/')}}" class="fa fa-chevron-circle-left"></a>
				<span ez-if="isNew == false">
					<a href="javascript:void(0);" [onclick]="widget.deleteInvoice" class="fa fa-trash"></a>
					
					<a href="javascript:void(0);" [onclick]="widget.printInvoice" class="fa fa-print"></a>
				</span>
				<a href="javascript:void(0);" [onclick]="widget.saveInvoice" class="fa fa-save"></a>
			</div>
			<h1>{{isNew?'Nieuwe factuur':'Bewerk factuur'}}</h1>
		</div>
		
		
		<form id="frmInvoice" action="{{appUrl('/service/sales/invoice.do')}}">
			<input type="hidden" name="a" value="save" />
			
			<input type="hidden" name="invoiceId" value="{{i.invoiceId}}" />
			
			<ez-string hideempty="1" name="invoiceNumber" label="Factuur #" [value]="i.invoiceNumber"></ez-string>
			
			<ez-date name="invoiceDate" label="Datum" [value]="i.invoiceDate"></ez-date>
			
			<ez-table-selector name="customerId" 
						label="Klant" 
						url="{{appUrl('/service/customers.do?a=tableSearch')}}"
						[value]="i.customerId" 
						[valueText]="i.customerName"></ez-table-selector>

			
			<ez-select name="invoiceStatus" [value]="i.invoiceStatus" label="Status">
				<option value="open">Open</option>
				<option value="sent">Verstuurd</option>
				<option value="paid">Betaald</option>
				<option value="partial">Gedeeltelijk betaald</option>
			</ez-select>
			
			<ez-text name="subject" label="Betreft" [value]="i.subject"></ez-text>
			
			
			<div class="invoice-list sales-table">
				<div class="header">
					<div class="col-sort"></div>
					<div class="col-description">Omschrijving</div>
					<div class="col-amount">Aantal</div>
					<div class="col-price">{{ _('amountLabel.'+salesSettings.inputPrice) }}</div>
					<div class="col-vat">Btw</div>
					<div class="col-total">Totaal</div>
				</div>
				<div class="sales-lines"></div>
				
				<div class="sales-totals">
					<div class="col-amount"></div>
					<div class="col-total"></div>
				</div>
			</div>
			
			<div class="action-box">
				<span><a href="javascript:void(0);" [onclick]="widget.addArticle">Artikel toevoegen</a></span>
				<span><a href="javascript:void(0);" [onclick]="widget.addLine">Prijsregel toevoegen</a></span>
				<span><a href="javascript:void(0);" [onclick]="widget.addTextLine">Tekstregel toevoegen</a></span>
			</div>
			
			
			<ez-textarea name="comment" label="Opmerking op factuur" [value]="i.comment"></ez-textarea>
			
			<ez-textarea name="internalNote" label="Interne opmerking" [value]="i.internalNote"></ez-textarea>
			
			
			<ez-datetime-text label="Bewerkt op" hideempty="1" [value]="i.edited"></ez-datetime-text>
			<ez-datetime-text label="Aangemaakt op" hideempty="1" [value]="i.created"></ez-datetime-text>
		</form>
	`;
	
	container = null;
	loading = false;
	
	ezTpl = null;
	invoice = {
		invoiceId: '',
		invoiceNumber: '',
		customerId: 0,
		customerName: '',
		invoiceStatus: 'open',
		subject: '',
		comment: '',
		internalNote: '',
		invoiceDate: format_date(new Date())
	};
		
	isNew = false;
	
	vats = null;
	salesSettings = null;
	
	lineNo = 0;
	
	
	init(e) {
		this.container = e;
		
		let id = getUrlParam('id');
		
		postUrl('/service/sales/invoice.do', {
			a: 'config'
		}).then( async function(e) {
			let json = await e.json();
			this.vats = json.vats;
			this.salesSettings = json.salesSettings;
			
			if (id) {
				this.loadInvoice( id );
			}
			else {
				this.isNew = true;
				this.render();
			}
		}.bind(this) );
		
	}
	
	render() {
//		console.log( this.tpl );
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setVar('i', this.invoice);
		this.ezTpl.setVar('isNew', this.isNew);
		this.ezTpl.setVar('salesSettings', this.salesSettings);
		
		this.ezTpl.setObject('widget', this);
		this.ezTpl.render();
		
		for(let i in this.invoice.lines) {
			let l = this.invoice.lines[i];
			console.log('createLine', l);
			
			if (this.salesSettings.inputPrice == 'incl_vat') {
				l.price = l.priceInclVat;
			}
			else {
				l.price = l.priceExclVat;
			}
			
			this.createLine(l);
		}
		
		$('.invoice-list .sales-lines').sortable({
			handle: '.col-sort'
		});
		
		this.calculateTotals();
	}
	
	addLine() {
		console.log('addLine');
		
		this.createLine({
			lineType: 'price'
		});
		
	}
	
	addTextLine() {
		console.log('addLine');
		
		this.createLine({
			lineType: 'text'
		});
	}
	
	addArticle() {
		let p = new ArticleSearchPopup();
		
		
		p.setSelectArticle(function(article) {
			let price;
			if (this.salesSettings.inputPrice == 'incl_vat') {
				price = article.line_price_incl_vat;
			}
			else {
				price = article.line_price_excl_vat;
			}
			
			let pricetypeId = 0;
			if ( article.selectedSlotplan ) {
				pricetypeId = article.selectedSlotplan.slotplanPricetypeId;
			}
			
			this.createLine({
				lineType: 'article',
				articleId: article.articleId,
				pricetypeId: pricetypeId,
				shortDescription: article.line_description,
				price: price,
				amount: 1,
				vatId: article.vatId
			});
		}.bind(this));
		
		p.show();
	}
	
	createLine( opts ) {
		let ln = this.lineNo++;
		
		let c = $('<div />');
		c.addClass('sales-line');
		c.addClass('line-no-' + ln);
		c.data('line-no', ln);
		c.data('line-type', opts.lineType);
		
		let col_sort = $('<div class="col-sort"><span class="fa fa-bars sort-handle"></span></div>');
		
		if (opts.lineType == 'text') {
			c.addClass('sales-line-text');
			
			let col_desc1 = $('<div class="col-description1"></div>');
			let inp_desc1 = $('<input type="text" />');
			inp_desc1.attr('name', 'sl_description1_'+ln);
			inp_desc1.val( opts.shortDescription );
			col_desc1.append( inp_desc1 );
			
			let col_desc2 = $('<div class="col-description2"></div>');
			let inp_desc2 = $('<input type="text" />');
			inp_desc2.attr('name', 'sl_description2_'+ln);
			inp_desc2.val( opts.shortDescription2 );
			col_desc2.append( inp_desc2 );
			
			let col_del = $('<div class="col-delete-line"><a href="javascript:void(0);" class="fa fa-remove delete-line"></a></div>');
			
			c.append( col_sort );
			c.append( col_desc1 );
			c.append( col_desc2 );
			c.append( col_del );
		}
		
		if (opts.lineType == 'price') {
			c.addClass('sales-line-price');
			
			let col_desc = $('<div class="col-description"></div>');
			let inp_description = $('<input type="text" />');
			inp_description.attr('name', 'sl_description_'+ln);
			inp_description.val( opts.shortDescription );
			col_desc.append( inp_description );
			
			let col_amount = $('<div class="col-amount"></div>');
			let inp_amount = $('<input type="number" />');
			inp_amount.attr('name', 'sl_amount_'+ln);
			inp_amount.val( opts.amount );
			col_amount.append( inp_amount );
			
			let col_price = $('<div class="col-price"></div>');
			let inp_price = $('<input type="text" class="format-price" />');
			inp_price.attr('name', 'sl_price_'+ln);
			inp_price.val( opts.price );
			col_price.append( inp_price );
			
			
			let col_vat = $('<div class="col-vat"></div>');
			let inp_vat = this.buildVatSelect( opts.vatPercentage );
			inp_vat.attr('name', 'sl_vat_'+ln);
			col_vat.append( inp_vat );
			
			let col_total = $('<div class="col-total"></div>');
			
			let col_del = $('<div class="col-delete-line"><a href="javascript:void(0);" class="fa fa-remove delete-line"></a></div>');
			
			c.append( col_sort );
			c.append( col_desc );
			c.append( col_amount );
			c.append( col_price );
			c.append( col_vat );
			c.append( col_total );
			c.append( col_del );
		}
		
		if (opts.lineType == 'article') {
			c.addClass('sales-line-article');
			
			c.data('article-id', opts.articleId);
			c.data('pricetype-id', opts.pricetypeId);
			
			let col_desc = $('<div class="col-description"></div>');
			col_desc.text( opts.shortDescription );
			
			let col_amount = $('<div class="col-amount"></div>');
			let inp_amount = $('<input type="number" />');
			inp_amount.attr('name', 'sl_amount_'+ln);
			inp_amount.val(opts.amount);
			col_amount.append( inp_amount );
			
			let col_price = $('<div class="col-price"></div>');
			let inp_price = $('<input type="text" class="format-price" />');
			inp_price.attr('name', 'sl_price_'+ln);
			inp_price.val( opts.price );
			col_price.append( inp_price );
			
			
			let col_vat = $('<div class="col-vat"></div>');
			let inp_vat = this.buildVatSelect( opts.vatPercentage );
			inp_vat.attr('name', 'sl_vat_'+ln);
			col_vat.append( inp_vat );

			
			let col_total = $('<div class="col-total"></div>');
			let col_del = $('<div class="col-delete-line"><a href="javascript:void(0);" class="fa fa-remove delete-line"></a></div>');
			
			c.append( col_sort );
			c.append( col_desc );
			c.append( col_amount );
			c.append( col_price );
			c.append( col_vat );
			c.append( col_total );
			c.append( col_del );
		}
		
		c.data('line-type', opts.type);
		
		$(c).find('.delete-line').on('click', function(evt) {
			$(evt.target).closest('.sales-line').remove();
			this.calculateTotals();
		}.bind(this));
		
		$(c).find('input, select').on('change', function() {
			this.calculateTotals();
		}.bind(this));
		
		$('#frmInvoice .sales-lines').append( c );
		
		this.calculateTotals();
	}
	
	buildVatSelect( vatPercentage ) {
		let selectedVatId = null;
		
		// lookup default vatId
		for(let i in this.vats) {
			if ( this.vats[i].defaultSelected ) {
				selectedVatId = this.vats[i].vatId;
				break;
			}
		}
		
		let addVatPercentage = false;
		if (typeof vatPercentage != 'undefined') {
			addVatPercentage = true;
			
			let p = parseInt(vatPercentage * 100);
			for(let i in this.vats) {
				if ( parseInt(this.vats[i].percentage * 100) == p  ) {
					selectedVatId = this.vats[i].vatId;
					addVatPercentage = false;
					break;
				}
			}
		}
		
		let inp_vat = $('<select  />');
		for(let i in this.vats) {
			let opt = $('<option />');
			opt.data('vat', this.vats[i]);
			opt.data('vatPercentage', this.vats[i].percentage);
			opt.val( this.vats[i].vatId );
			opt.text( this.vats[i].description );
			if (this.vats[i].vatId == selectedVatId)
				opt.prop('selected', true);
			inp_vat.append( opt );
		}
		
		// old percentage thats not in system anymore? => add
		if (addVatPercentage) {
			let opt = $('<option />');
			opt.data('vatPercentage', vatPercentage);
			opt.val( -1 );
			opt.text( vatPercentage + '%' );
			opt.prop('selected', true);
			inp_vat.append( opt );
		}
		
		
		return inp_vat;
	}
	
	
	
	saveInvoice() {
		if (this.loading) {
			return;
		}
		
		this.loading = true;
		
		let frm = $('#frmInvoice');
		
		let data = {};
		data.invoiceId      = frm.find('input[name=invoiceId]').val();
		data.invoiceDate    = frm.find('input[name=invoiceDate]').val();
		data.customerId   = frm.find('input[name=customerId]').val();
		data.invoiceStatus  = frm.find('select[name=invoiceStatus]').val();
		data.subject      = frm.find('input[name=subject]').val();
		data.comment      = frm.find('textarea[name=comment]').val();
		data.internalNote = frm.find('textarea[name=internalNote]').val();
		data.lines = [];
		
		let lines = frm.find('.invoice-list .sales-lines .sales-line');
		
		for(let i=0; i < lines.length; i++) {
			let line = $(lines.get(i));
			
			let l = {};
			l.lineType = line.data('line-type');
			
			if (l.lineType == 'text') {
				l.shortDescription = line.find('.col-description1 input').val();
				l.shortDescription2 = line.find('.col-description2 input').val();
			}
			if (l.lineType == 'price') {
				l.shortDescription = line.find('.col-description input').val();
				l.amount = strtodouble( line.find('.col-amount input').val() );
				l.price = strtodouble( line.find('.col-price input').val() );
				l.vatPercentage = line.find('.col-vat select option:selected').data('vatPercentage');
			}
			if (l.lineType == 'article') {
				l.articleId = line.data('article-id');
				l.pricetypeId = line.data('pricetype-id');
				l.shortDescription = $.trim( line.find('.col-description').text() );
				l.amount = strtodouble( line.find('.col-amount input').val() );
				l.price = strtodouble( line.find('.col-price input').val() );
				l.vatPercentage = line.find('.col-vat select option:selected').data('vatPercentage');
			}
			
			data.lines.push( l );
			
		}
		
		console.log( data );
		
		data.a = 'save';
		
		showLoadingForm('#frmInvoice');
		postJson('/service/sales/invoice.do', data )
			.then( async function(e) {
				let json = await e.json();
				
				if (json.success) {
					reportUserMessage( 'Wijzigingen opgeslagen' );
					gotoRoute( '/sales/invoice/edit/?id='+json.invoiceId );
				}
				else {
					formShowErrors('#frmInvoice', json);
				}
				
				this.loading = false;
				hideLoadingForm('#frmInvoice');
			}.bind(this) );
	}
	
	deleteInvoice() {
		showConfirmation('Verwijderen', 'Weet je zeker dat je deze factuur wilt verwijderen?', function() {
			
			postUrl( '/service/sales/invoice.do', {
				a: 'delete',
				invoiceId: this.invoice.invoiceId
			}).then( async function(e) {
				let json = await e.json();
				if (json.error) {
					showAlert('Error', 'Error: ' + json.message);
					return;
				}
				
				gotoRoute( '/sales/invoice/' );
			}.bind(this) );
			
		}.bind(this));
	}
	
	printInvoice() {
		
		if (toolboxConfig.desktopMode) {
			postUrl( '/service/sales/invoice.do', {
				a: 'openInvoice',
				id: this.invoice.invoiceId
			});
		}
		else {
			window.open( appUrl('/service/sales/invoice.do?a=print&id='+this.invoice.invoiceId), '_blank' );
		}
		
		
	}
	
	
	
	loadInvoice(invoiceId) {
		postUrl( '/service/sales/invoice.do'
			, {
					a: 'view',
					invoiceId: invoiceId
			}).then( async function(e) {
				let json = await e.json();
				if (json.error) {
					return showErrorWidget(json);
				}
				
				this.invoice = json.invoice;
				this.render();
				
				this.loading = false;
			}.bind(this) );
	}
	
	
	calculateTotals() {
		
		let totalAmount = 0;
		let totalExclVat = 0;
		let totalInclVat = 0;
		let totalVat = {
		};
		
		$('.sales-table .sales-line').each(function(index, node) {
			// skip text lines
			if ($(node).data('line-type') == 'text')
				return;
			
			let amount = strtodouble( $(node).find('.col-amount input').val() );
			let price = strtodouble( $(node).find('.col-price input').val() );
			let optVat = $(node).find('.col-vat select option:selected');
			let vatPercentage = optVat.data('vatPercentage');
			
			
			if (isNaN(amount) || isNaN(price))
				return;
			
			
			let vatPercentageInt = parseInt(vatPercentage*100);
			
			let vatAmount = 0;
			let total = 0;
			
			
			totalAmount += amount;
			
			if ( this.salesSettings.inputPrice == 'excl_vat' ) {
				vatAmount = calculateVatExclPrice(price, vatPercentage);
				
				total = roundNumber( (price+vatAmount) * amount, 2 );
				
				totalExclVat += roundNumber( price * amount, 2 );
				totalInclVat += total;
			}
			else if ( this.salesSettings.inputPrice == 'incl_vat' ) {
				vatAmount = calculateVatInclPrice(price, vatPercentage);
				
				let priceExclVat = roundNumber( price - vatAmount, 2 );
				
				total = roundNumber( price * amount, 2 );
				
				totalExclVat += roundNumber( priceExclVat * amount, 2 );
				totalInclVat += total;
			}
			
			if (typeof totalVat[vatPercentageInt] == 'undefined') {
				totalVat[vatPercentageInt] = {
					amount: 0,
					percentage: vatPercentage
				};
			}
			
			totalVat[vatPercentageInt]['amount'] += ( vatAmount * amount );
			
			$(node).find('.col-total').text( format_price(total, true) );
		}.bind(this));
		
		
		$('.sales-table .sales-totals .col-amount').text(totalAmount);
		
		let t = $('.sales-table .sales-totals .col-total');
		t.empty();
		t.append('<div>Prijs excl. btw ' + format_price(totalExclVat, true) + '</div>');
		for(let p in totalVat) {
			t.append('<div>Btw ' + totalVat[p].percentage + '% ' + format_price(totalVat[p].amount, true) + '</div>');
		}
		
		t.append('<div>Prijs incl. btw ' + format_price(totalInclVat, true) + '</div>');
		
	}
	
	
}


