



export class ArticleGroupListWidget {
	
	container = null;
	vats = null;
	
	ezTpl = null;
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/')}}" class="fa fa-chevron-circle-left"></a>
				<a href="{{appUrl('/masterdata/sales/articlegroup/edit/')}}" class="fa fa-plus"></a>
			</div>
			
			<h1>Artikelgroepen</h1>
		</div>
		
		<div ez-if="groups == null">
			Loading...
		</div>
		<div ez-if="groups != null">
			<table class="table">
				<thead>
					<tr>
						<th></th>
						<th>Groep naam</th>
						<th>Actief</th>
						<th>Laatst bewerkt</th>
						<th></th>
					</tr>
				</thead>
				<tbody  ez-for="groups" ez-item="g" class="tbody-groups">
					<tr [onclick]="widget.editGroup" class="pointer" article-group-id="{{g.articleGroupId}}">
						<td style="width: 50px;"><i class="fa fa-bars sort-handle"></i></td>
						<td>{{g.groupName}}</td>
						<td>{{g.active ? 'Ja' : 'Nee'}}</td>
						<td>{{ format_datetime(g.edited, {dmy: true}) }}</td>
						<td class="actions">
							<a href="{{appUrl('/masterdata/sales/articlegroup/edit/?id='+g.articleGroupId)}}" class="fa fa-pencil"></a>
						</td>
					</tr>
				</tbody>
					
				<tbody ez-if="groups.length == 0">
					<tr>
						<td colspan="5" class="no-results">
							Geen resultaten gevonden
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	`;
	
	
	editGroup(evt, tr) {
		let agid = tr.getAttribute('article-group-id');
		
		gotoRoute( '/masterdata/sales/articlegroup/edit/?id='+agid );
	}


	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('groups', this.groups);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();

		$(this.container).find('.tbody-groups').sortable({
			handle: '.sort-handle',
			update: function() {
				this.saveSort();
			}.bind(this)
		});
		
	}
	
	saveSort() {
		let ids = [];
		$('.tbody-groups tr').each(function(index, node) {
			let id = $(node).attr('article-group-id');
			ids.push(id);
		});
		
		postUrl( '/service/sales/articlegroup.do', {
			a: 'updateSort',
			ids: ids.join(',')
		}).then(async function(e) {
			let json = await e.json();
			showToastMessage('Volgorde opgeslagen');
		}.bind(this));
		
	}
	
	
	loadGroups() {
		postUrl( '/service/sales/articlegroup.do' ).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget( json );
			}
			
			this.groups = json.groups;
			this.render();
			
		}.bind(this) );
		
	}
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		this.loadGroups();
	}

}

