


export class ArticleGroupEditWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/sales/articlegroup/')}}" class="fa fa-chevron-circle-left"></a>
				<span ez-if="isNew == false">
					<a href="javascript:void(0);" [onclick]="widget.deleteGroup" class="fa fa-trash"></a>
				</span>
				<a href="javascript:void(0);" [onclick]="widget.saveGroup" class="fa fa-save"></a>
			</div>
			<h1>{{isNew?'Nieuwe artikelgroep':'Bewerk artikelgroep'}}</h1>
		</div>
		
		
		<form id="frmGroup" action="{{appUrl('/service/sales/articlegroup.do')}}">
			<input type="hidden" name="a" value="save" />
			
			<input type="hidden" name="articleGroupId" value="{{g.articleGroupId}}" />
			
			<ez-text name="groupName" label="Naam" [value]="g.groupName"></ez-text>
			
			<ez-checkbox name="active" label="Actief" [checked]="g.active"></ez-checkbox>
			
			<ez-datetime-text label="Bewerkt op" hideempty="1" [value]="g.edited"></ez-datetime-text>
			
			<ez-datetime-text label="Aangemaakt op" hideempty="1" [value]="g.created"></ez-datetime-text>
		</form>
	`;
	
	container = null;
	loading = false;
	
	ezTpl = null;
	group = {
		description: '',
		active: true
	};
	
	isNew = false;
	
	init(e) {
		this.container = e;
		
		let id = getUrlParam('id');
		
		if (id) {
			this.loadGroup( id );
		}
		else {
			this.isNew = true;
			this.render();
		}
	}
	
	render() {
//		console.log( this.tpl );
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setVar('g', this.group);
		this.ezTpl.setVar('isNew', this.isNew);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.render();
		
		focusFirstField( '#frmGroup' );
	}
	
	
	saveGroup() {
		if (this.loading) {
			return;
		}
		
		this.loading = true;
		
		postForm('#frmGroup').then(async function(e) {
			
			let json = await e.json();
			console.log( json );
			
			if (json.error) {
				// TODO: render errors
				formShowErrors( '#frmGroup', json );
				
			}
			else {
				// report succesfully saved
				reportUserMessage( 'Wijzigingen opgeslagen' );
				
				// reload data?
				gotoRoute( '/masterdata/sales/articlegroup/edit/?id='+json.articleGroupId );
			}
			
			this.loading = false;
		}.bind(this)).catch(showErrorWidget);
	}
	
	deleteGroup() {
		showConfirmation('Verwijderen', 'Weet je zeker dat je deze artikelgroep wilt verwijderen?', function() {
			
			postUrl( '/service/sales/articlegroup.do', {
				a: 'delete',
				articleGroupId: this.group.articleGroupId
			}).then( async function(e) {
				let json = await e.json();
				if (json.error) {
					showAlert('Error', 'Error: ' + e.message);
					return;
				}
				
				gotoRoute( '/masterdata/sales/articlegroup/' );
			}.bind(this) );
			
		}.bind(this));
	}
	
	
	
	loadGroup(groupId) {
		postUrl( '/service/sales/articlegroup.do', {
			a: 'view',
			articleGroupId: groupId
		}).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget(json);
			}
			
			this.group = json.articleGroup;
			this.render();
			
			this.loading = false;
		}.bind(this)); 
	}
	
}


