

import { NoteEditPopup } from './NoteEditPopup.js';


export class NoteListWidget {

	ezTpl = null;
	
	loadCustomerAbortController = null;
	
	pageNo = 0;
	q = '';
	
	
	tpl = `
		<div class="accordion-item">
			<div id="notesContainer" class="accordion-collapse show">
				<div class="action-box">
					<span ez-if="writable">
						<a class="notelist-add-note" href="javascript:void(0)" [onclick]="widget.editNote">Notitie toevoegen</a>
					</span>
				</div>
				
				<br/>
			
				<div class="accordion-body">
					<div ez-subtemplate="tpl-notes">
					<table class="table">
						<thead>
							<tr>
								<th class="th-sort-handle"></th>
								<th>Notitie</th>
								<th style="width: 100px;">Belangrijk</th>
								<th style="width: 175px;">Laatst bewerkt</th>
							</tr>
						</thead>
						
						<tbody class="tbody-notes" ez-for="notes" ez-item="note">
							<tr class="note-record pointer" note-id="{{note.noteId}}" [onclick]="widget.editNote">
								<td class="sort-cell" style="width: 20px;"><i class="fa fa-bars sort-handle ui-sortable-handle" /></td>
								<td>{{note.shortNote}}</td>
								<td>
									{{note.important ? 'Ja' : '' }}
								</td>
								<td>
									{{ format_datetime(note.edited) }}
								</td>
							</tr>
						</tbody>
						
						<tr ez-if="notes.length == 0">
							<td colspan="100%" class="no-results">
								Geen notities
							</td>
						</tr>
					
					</table>
					</div>
				</div>
			</div>
		</div>
	`;
	
	refObject = null;
	refId = null;
	
	container = null;
	notes = null;
	writable = true;
	
	
	setRefObject(o) { this.refObject = o; }
	setRefId(i) { this.refId = i; }
	setWritable( bln ) { this.writable = bln ? true : false; }
	
	
	init(e) {
		this.container = e;
		this.loadNotes();
	}
	
	render() {
		if (this.notes == null)
			return;
		
		console.log('notescontainer', this.container);
		
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('notes', this.notes);
		this.ezTpl.setVar('writable', this.writable);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		if (this.writable) {
			$('tbody.tbody-notes').sortable({
				handle: '.sort-handle',
				update: function() {
					this.saveNotesSort();
				}.bind(this)
			});
		}
		else {
			$(this.container).find('.th-sort-handle, .sort-cell').hide();
		}	
		
	}
	
	editNote(evt) {
		
		if ($(evt.target).hasClass('sort-cell') || $(evt.target).closest('.sort-cell').length > 0)
			return;
		
		let tr = $(evt.target).closest('tr.note-record');
		
		
		let p = new NoteEditPopup();
		p.setRefObject(this.refObject);
		p.setRefId(this.refId);
		p.setWritable( this.writable );
		p.setCallbackSave(function(e) {
			this.loadNotes();
		}.bind(this));
		
		if (tr.length) {
			p.loadNote( tr.attr('note-id') );
		}
		else {
			p.showPopup();
		}
	}
	
	
	loadNotes() {
		let data = {};
		
		data.a = 'search';
		data.refObject = this.refObject;
		data.refId = this.refId;
		
		let cur_url = window.location.toString();
		
		postUrl('/service/notes.do'
			, data
		)
		.then(async function(data) {
			let resp = await data.json();
			
			if ( cur_url != window.location.toString() ) {
				console.error('NoteListWidget, not rendering, url changed');
				return;
			}
			
			if (resp.error) {
				showErrorWidget( resp );
				return;
			}
			
			this.notes = resp.notes;
			
			for(let i in this.notes) {
				if (this.notes[i].important) {
					reportUserWarning( 'Belangrijke notitie: ' + this.notes[i].shortNote );
				}
			}
			
			this.render();
		}.bind(this))
		.catch( showErrorWidget )
	}
	
	saveNotesSort() {
		let ids = [];
		$(this.container).find('tbody.tbody-notes > tr').each(function(index, node) {
			let id = node.getAttribute('note-id');
			ids.push( id );
		});
		
		postUrl( '/service/notes.do', {
			a: 'updateSort',
			noteIds: ids.join(',')
		});
		
		showToastMessage( 'Volgorde opgeslagen' );
	}
	
}

