



export class LicenseWidget {
	
	tpl = `
		<div class="page-header page-no-license-check">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/')}}" class="fa fa-chevron-circle-left"></a>
				<a href="javascript:void(0);" [onclick]="widget.save" class="fa fa-save"></a>
			</div>
			
			<h1>Registratie Instellingen</h1>
		</div>
		
		<span ez-if="loading == true">Loading...</span>
		
		<div ez-if="loading == false">
			<form id="frmLicense">
				<ez-text name="appLicenseCode" [value]="settings.appLicenseCode" label="Registratiecode"></ez-text>
				
				<div class="license-message">{{ settings.licenseMessage}}</div>
				
			</form>
		</div>
		
	`;
	
	
	previousLicenseCodeCheck = null;
	timeoutLicenseCheck = null;
	
	container = null;
	ezTpl = null;
	loading = true;
	settings = null;
	
	init(e) {
		this.container = e;
		this.render();
		
		this.loadSettings();
		
		if (getUrlParam('s') == '1') {
			reportUserMessage('Wijzigingen opgeslagen');
		}
	}
	
	loadSettings() {
		postUrl( '/service/license.do', {
			a: 'settings'
		}).then( async function(e) {
			let json = await e.json();
			this.settings = json;
			this.loading = false;
			this.render();
		}.bind(this) );
	}
	
	
	licenseChanged() {
		let inp = $('[name=appLicenseCode]');
		if (inp.length == 0)
			return;
		
		let code = $.trim( inp.val() );
		
		if (this.previousLicenseCodeCheck == code) {
			return;
		}
		
		clearTimeout( this.timeoutLicenseCheck );
		
		this.timeoutLicenseCheck = setTimeout(() => {
			this.checkCode();
		}, 500);
	}
	
	checkCode() {
		let inp = $('input[name=appLicenseCode]');
		if (inp.length == 0)
			return;
		
		let code = $.trim( inp.val() );
		
		postUrl( '/service/license.do', {
			a: 'checkLicenseCode',
			code: code
		}).then(async (e) => {
			let json = await e.json();
				if (json.licenseValidLicense) {
					document.querySelector('.license-message').innerHTML = 'Geldige code. Dank voor de support!';
				}
				else {
					document.querySelector('.license-message').innerHTML = json.licenseMessage;
				}
		});
	}
	
	
	
	save() {
		let d = {};
		d.a = 'saveSettings';
		d.appLicenseCode = $('#frmLicense input[name=appLicenseCode]').val();
		
		postUrl( '/service/license.do', d ).then( async function(e) {
			let json = await e.json();
			if (json.validLicense) {
				// valid license => reload...
				window.location = appUrl('/masterdata/license/?s=1');
			}
			else {
				reportUserMessage('Wijzigingen opgeslagen');
				replaceRoute( '/masterdata/license/' );
			}
		}.bind(this) );
	}
		
	
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('loading', this.loading);
		this.ezTpl.setVar('settings', this.settings);
		this.ezTpl.setObject('widget', this);
		
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		
		$(this.container).find('[name=appLicenseCode]').on('keyup change', () => {
			this.licenseChanged();
		});
	}
	
}

