

import { ObjectPermissionWidget } from '../user/ObjectPermissionWidget.js';



export class FileEditPopup {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0)" [onclick]="widget.close" class="fa fa-times-circle"></a>
				
				<a ez-if="accessMethod == 'write'" href="javascript:void(0);" [onclick]="widget.deleteFile" class="fa fa-trash"></a>
				
				<a href="javascript:void(0);" ez-if="accessMethod == 'write'" [onclick]="widget.saveFile" class="fa fa-save"></a>
			</div>
			<h1>Bestand gegevens</h1>
		</div>

		<div class="action-box">
			<span ez-if="embeddedRequest == true"><a href="javascript:void(0);" id="btnOpenFile" [widget]="widget" onclick="widget.open_download_FileClick();">Open bestand</a></span>
			
			<span ez-if="embeddedRequest == false"><a href="javascript:void(0);" id="btnOpenFile" [widget]="widget" onclick="widget.open_download_FileClick();">Download bestand</a></span>
		</div>
			<hr/>

		<ul class="nav nav-tabs" id="fileTabs" role="tablist">
			<li class="nav-item" role="presentation">
				<button class="nav-link active" 
						id="file-info-tab"
						data-bs-toggle="tab"
						data-bs-target="#file-info-container"
						type="button"
						role="tab"
						aria-controls="base"
						aria-selected="true">Basisgegevens</button>
		    </li>
			
		    <li class="nav-item" role="presentation" ez-if="isNew == false">
		    	<button class="nav-link"
	    				id="file-permissions-tab" 
	    				data-bs-toggle="tab" 
	    				data-bs-target="#file-permissions-container" 
	    				type="button" 
	    				role="tab" 
	    				aria-controls="permissions" 
	    				aria-selected="false">{{_('Permissions')}}</button>
		    </li>
		</ul>

		<div class="tab-content" id="fileTabsContent">
			<div class="tab-pane fade show active" id="file-info-container" role="tabpanel" aria-labelledby="file-base-tab">
				<form id="frmFile">
				
					<div ez-if="file.dbFileId == null">Loading...</div>
					
					<div ez-if="file.dbFileId != null">
						
						<ez-string name="originalFilename" label="Bestandsnaam" [value]="file.originalFilename"></ez-string>
						<ez-string name="size" label="Grootte" [value]="file.size"></ez-string>
						
						<ez-text name="refDescription" label="Reference" [value]="file.refDescription"></ez-text>
						<ez-textarea name="note" label="Notitie" [value]="file.note"></ez-textarea>
						
						<ez-datetime-text name="created" label="Aangemaakt op" [value]="file.created"></ez-datetime-text>
						
					</div>
				</form>
			</div>
			
			
			<div class="tab-pane fade show" id="file-permissions-container" role="tabpanel" aria-labelledby="file-permissions-tab">
			</div>
			
		</div>
	`;
	
	
	opWidget = null;
	
	
	isNew = true;
	accessMethod = 'read';
	userPermissionList = null;
	
	
	file = {
		dbFileId:       null,
		refDescription: '',
		note:           ''
	};
	
	isNew = true;
	
	container = null;
	
	callback_close = null;
	
	saveClicked = false;
	
	setCallbackClose( c ) { this.callback_close = c; }
	
	
	setDbFileId(id) {
		this.file.dbFileId = id;
		
		this.loadFile( id );
	}
	
	loadFile(id) {
		postUrl( '/service/files.do', {
			a: 'view',
			dbFileId: id
		}).then( async function(e) {
			let json = await e.json();
			console.log( json );
			this.file = json.file;
			
			this.accessMethod = json.accessMethod;
			this.userPermissionList	 = json.userPermissionList;
			
			this.isNew = false;
			
			this.render();
			
		}.bind(this));
	}
	
	
	saveFile() {
		let data = {};
		data.a = 'saveSettings';
		data.dbFileId       = this.file.dbFileId;
		data.refDescription = $('input[name=refDescription]').val();
		data.note           = $('textarea[name=note]').val();
		
		data.permissions = this.opWidget.getPermissions();
		
		showLoadingForm( '#frmFile' );
		this.saveClicked = true;
		postJson('/service/files.do', data).then( async function(e) {
			let json = await e.json();
			if (json.success) {
				reportUserMessage('Wijzigingen opgeslagen');
			}
			
			close_popup();
		}.bind(this) );
		
	}
	
	deleteFile() {
		showConfirmation('Verwijderen', 'Weet je zeker dat je dit bestand wilt verwijderen?', function() {
			
			postUrl( '/service/files.do', {
					a: 'delete'
					, 'dbFileId' : this.file.dbFileId
				}).then( async function(e) {
					let json = await e.json();
					close_popup();
					
					if (this.callback_close) {
						this.callback_close();
					}
					reportUserMessage( 'Bestand verwijderd' );
				}.bind(this) );
				
		}.bind(this));
	}
	
	render() {
		if (!this.container) {
			this.container = show_popup('Bestand aanpassen', '');
			this.container.get(0).close_callback = function() {
				if (this.saveClicked && this.callback_close) {
					this.callback_close();
				}
			}.bind(this);
		}
		
		let ezTpl = new EzTemplate( this.container );
		ezTpl.loadHtml( this.tpl );
		ezTpl.setObject('widget', this);
		ezTpl.setVar('desktopMode', toolboxConfig.desktopMode == 1 ? true : false);
		ezTpl.setVar('embeddedRequest', toolboxConfig.embeddedRequest);
		ezTpl.setVar('file', this.file);
		ezTpl.setVar('isNew', this.isNew);
		ezTpl.setVar('accessMethod', this.accessMethod);
		ezTpl.render();
		
		
		this.opWidget = new ObjectPermissionWidget();
		this.opWidget.init( '#file-permissions-container' );
		this.opWidget.setAccessMethod( this.accessMethod );
		this.opWidget.setUserPermissionList( this.userPermissionList );
		this.opWidget.render();
		
		
		$(this.container).find('input[name=refDescription]').on('change', function() {
			this.value = trim(this.value);
		})
		
	}
	
	
	
	open_download_FileClick( dbFileId ) {
		if (toolboxConfig.embeddedRequest) {
			postUrl( '/service/files.do', {
				a: 'openFile',
				dbFileId: this.file.dbFileId
			});
		}
		else {
			window.open( appUrl('/service/files.do') + '?a=downloadFile&dbFileId=' + this.file.dbFileId);
		}
	}
	
	
	close() {
		close_popup();
	}
	
	show() {
		this.render();
	}
	
	
}

