

export class EmailSettingsWidget {
	
	
	
	tpl = `
		<div class="email-settings-widget">
			<div class="page-header">
				<div class="toolbox">
					<a href="{{appUrl('/masterdata/')}}" class="fa fa-chevron-circle-left"></a>
					<a href="javascript:void(0);" [onclick]="widget.save" class="fa fa-save"></a>
				</div>
				
				<h1>E-mail Instellingen</h1>
			</div>
		
			<span ez-if="settings == null">
				Loading...
			</span>
		
			<form id="frmEmail" ez-if="settings != null">
				<fieldset>
					<legend>SMTP Instellingen</legend>
					
					<ez-text name="fromName" placeholder="Toolbox" label="Afzender naam" [value]="settings.fromName"></ez-text>
					
					<ez-text name="fromEmail" placeholder="info@localhost" label="Afzender e-mail" [value]="settings.fromEmail"></ez-text>
					
					<ez-select name="sendMethod" label="{{_('Send method')}}" [value]="settings.sendMethod">
						<option value="r2bmailserver">Report2base mailserver</option>
						<option value="smtp">SMTP</option>
					</ez-select>
					
					<div class="smtp-settings">
						<ez-text name="smtpHost" label="SMTP Server" [value]="settings.smtpHost"></ez-text>
						
						<ez-number name="smtpPort" label="SMTP Port" [value]="settings.smtpPort" min="1" max="65535"></ez-number>
						
						<ez-checkbox name="smtpTls" label="TLS" [checked]="settings.smtpTls"></ez-checkbox>
						
						<ez-text name="smtpUsername" label="Gebruikersnaam" [value]="settings.smtpUsername"></ez-text>
						
						<ez-password name="smtpPassword" 
									label="Wachtwoord" 
									[value]="settings.smtpPassword"
									placeholder="{{settings.smtpPasswordSet?_('Password set'):''}}"></ez-password>
						
					</div>
					
					<button id="btnTestMail" [onclick]="widget.sendTestMail_Click">Verstuur test mail</button>
				</fieldset>
			</form>
			
		</div>
	`;
	
	
	container = null;
	settings = null;
	
	ezTpl = null;
	
	init(c) {
		this.container = c;
		
		this.render();
		this.loadSettings();
	}
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('settings', this.settings);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		
		// force r2b send-method, hosted env
		if (toolboxConfig.hosted) {
			$('option[value=smtp]').remove();
		}
		
		
		$('.email-settings-widget select[name=sendMethod]').on('change', () => {
			this.updateInput();
		});
		this.updateInput();
		
		$(this.container).find('input[name=fromName], input[name=fromEmail], input[name=smtpHost], input[name=smtpUsername]').on('change', function() {
			this.value = trim(this.value);
		});
		
	}
	
	loadSettings() {
		postUrl('/service/email/settings.do' )
		.then( async (e) => {
			let json = await e.json();
			this.settings = json.emailSettings;
			
			this.render();
		});
	}
	
	save() {
		
		let data = serialize2object('#frmEmail');
		data.a = 'save';
		
		postUrl('/service/email/settings.do', data).then( async (e) => {
			let json = await e.json();
			
			reportUserMessage( 'Wijzigingen opgeslagen' );
		});
	}
	
	
	updateInput() {
		let sendMethod = $('select[name=sendMethod]').val();
		
		$('.smtp-settings').hide();
		
		if (sendMethod == 'r2bmailserver') {
		}
		if (sendMethod == 'smtp') {
			$('.smtp-settings').show();
		}
		
	}
	
	
	sendTestMail_Click() {
		showConfirmation('Test mail versturen', 'E-mailadres: <input type="email" name="popup_email" />', () => {
			let e = $('[name=popup_email]').val();
			
			if (validate_email(e) == false) {
				alert('Ongeldig mailadres');
				return;
			}
			
			this.sendTestMail( e );
		});
	}
	
	async sendTestMail( emailAddress ) {
		let o = serialize2object( '#frmEmail' );
		o.a = 'testMail';
		o.emailAddress = emailAddress;
		
		let r = await postUrl('/service/email/settings.do', o);
		
		reportUserMessage( _('E-mail sent') );
		
		save_state( 'email-settings-test', 'email', e );
		
	}
	
}




