
import { appConfig } from '../../service/AppConfig.js';

import { EmailPopup } from './EmailPopup.js';
import { PhonePopup } from './PhonePopup.js';
import { AddressPopup } from './AddressPopup.js';

import { NoteListWidget } from '../notes/NoteListWidget.js';
import { FilesTab } from '../files/FilesTab.js';
import { ActivityLogTab } from '../masterdata/activity/ActivityLogTab.js';


export class CustomerEditWidget {
	
	tpl = `
		<div class="page-header" ez-if="embedded == false">
			<div class="toolbox">
				<span ez-if="popupMode == false">
					<a href="{{appUrl('/customers/')}}" class="fa fa-chevron-circle-left"></a>
				</span>
				<span ez-if="customer.customerId > 0">
					<a href="javascript:void(0);" [onclick]="widget.deleteCustomer" class="fa fa-trash"></a>
				</span>
				
				<span ez-if="popupMode == true">
					<a href="javascript:void(0);" onclick="close_popup();" class="fa fa-times-circle"></a>
				</span>
				
				<a href="javascript:void(0);" [onclick]="widget.saveCustomer" class="fa fa-save"></a>
			</div>
			
			<h1>{{!customer.customerId?'Nieuwe relatie':'Bewerk relatie'}} <span class="title-customer-name"></span></h1>
		</div>
		
		

		<ul class="nav nav-tabs" id="customerTabs" role="tablist">
			<li class="nav-item" role="presentation">
				<button class="nav-link active" id="base-tab" data-bs-toggle="tab" data-bs-target="#customer-base" type="button" role="tab" aria-controls="base" aria-selected="true">Basisgegevens</button>
			</li>
			<li class="nav-item" role="presentation" ez-if="isNew == false">
				<button class="nav-link" id="notes-tab" data-bs-toggle="tab" data-bs-target="#customer-notes" type="button" role="tab" aria-controls="notes" aria-selected="false">Notities</button>
			</li>
		</ul>
		
		<form id="frmCustomer" action="{{appUrl('/service/customers.do')}}">
			<div class="tab-content" id="customerTabsContent">
				<div class="tab-pane fade show active" id="customer-base" role="tabpanel" aria-labelledby="base-tab">
					<input type="hidden" name="a" value="save" />
					<input type="hidden" name="customerId" value="{{customer.customerId}}" />

					<ez-radio name="customerType" label="Type" [value]="customer.customerType">
						<option value="business">Zakelijk</option>
						<option value="personal">Prive</option>
					</ez-radio>

					<ez-text name="customerName" label="Naam" [value]="customer.customerName"></ez-text>

					<ez-text id="contactPerson-container" name="contactPerson" label="Contactpersoon" [value]="customer.contactPerson"></ez-text>
					
					<ez-date id="birthDate" name="birthDate" label="Geboortedatum" [value]="customer.birthDate"></ez-date>

					<ez-text name="cocNumber" label="Kvk nummer" [value]="customer.cocNumber"></ez-text>

					<ez-text name="vatNumber" label="Btw nummer" [value]="customer.vatNumber"></ez-text>

					<ez-text name="iban" label="IBAN" [value]="customer.iban"></ez-text>

					<ez-text name="bic" label="BIC" [value]="customer.bic"></ez-text>

					<ez-textarea name="note" label="Notitie" [value]="customer.note"></ez-textarea>
					
					<ez-datetime-text label="Bewerkt op" hideempty="1" [value]="customer.edited"></ez-datetime-text>
					<ez-datetime-text label="Aangemaakt op" hideempty="1" [value]="customer.created"></ez-datetime-text>
					
					
					<fieldset class="fieldset-email">
						<legend>E-mail</legend>
						<table class="table table-emails table-edit">
							<thead>
								<tr>
									<th></th>
									<th>E-mailadres</th>
									<th>Note</th>
									<th></th>
								</tr>
							</thead>
							<tbody id="tbody-emails" ez-for="customer.emails" ez-item="e">
								<tr [onclick]="widget.editEmail" [data-email]="e" class="pointer">
									<td class="sort-cell" style="width: 20px;"><i class="fa fa-bars sort-handle ui-sortable-handle" /></td>
									<td>{{e.emailAddress}}</td>
									<td>{{e.description}}</td>
									<td class="actions"><a href="javascript:void(0);" [onclick]="widget.deleteEmail" class="fa fa-trash"></a></td>
								</tr>
							</tbody>
							<tbody class="no-results">
								<tr>
									<td colspan="4">Geen resultaten gevonden</td>
								</tr>
							</tbody>
						</table>

						<a href="javascript:void(0)" [onclick]="widget.addEmail">E-mailadres toevoegen</a>
					</fieldset>
					
					<fieldset class="fieldset-phone">
						<legend>Telefoonnummers</legend>
						
						<table class="table table-phones table-edit">
							<thead>
								<tr>
									<th></th>
									<th>Nummer</th>
									<th>Omschrijving</th>
									<th></th>
								</tr>
							</thead>
							<tbody id="tbody-phones" ez-for="customer.phones" ez-item="p">
								<tr [onclick]="widget.editPhone" [data-phone]="p" class="pointer">
									<td class="sort-cell" style="width: 20px;"><i class="fa fa-bars sort-handle ui-sortable-handle" /></td>
									<td>{{p.phonenr}}</td>
									<td>{{p.description}}</td>
									<td class="actions"><a href="javascript:void(0);" [onclick]="widget.deletePhone" class="fa fa-trash"></a></td>
								</tr>
							</tbody>
							<tbody class="no-results">
								<tr>
									<td colspan="100%">Geen resultaten gevonden</td>
								</tr>
							</tbody>
						</table>

						<a href="javascript:void(0)" [onclick]="widget.addPhone">Telefoonnummer toevoegen</a>
					</fieldset>
					
					<fieldset class="fieldset-address">
						<legend>Adressen</legend>
							<table class="table table-addresses table-edit">
								<thead>
									<tr>
										<th></th>
										<th>Straat</th>
										<th>Postcode</th>
										<th>Plaats</th>
										<th></th>
									</tr>
								</thead>
								<tbody id="tbody-addresses" ez-for="customer.addresses"
									ez-item="a">
									<tr [onclick]="widget.editAddress" [data-address]="a"
										class="pointer">
										<td class="sort-cell" style="width: 20px;"><i class="fa fa-bars sort-handle ui-sortable-handle" /></td>
										<td>{{a.street ?? ''}} {{a.streetNo ?? ''}}</td>
										<td>{{a.zipcode ?? ''}}</td>
										<td>{{a.city ?? ''}}</td>
										<td class="actions"><a href="javascript:void(0);"
											[onclick]="widget.deleteAddress" class="fa fa-trash"></a></td>
									</tr>
								</tbody>
								<tbody class="no-results">
									<tr>
										<td colspan="100%">Geen resultaten gevonden</td>
									</tr>
								</tbody>
							</table>

							<a href="javascript:void(0)" [onclick]="widget.addAddress">Adres toevoegen</a>
					</fieldset>
					
					
				</div>
				
				<div class="tab-pane fade" id="customer-notes" role="tabpanel" aria-labelledby="notes-tab">
					<div id="notes-container"></div>
				</div>
				
			</div>
		</form>
	`;
	
	container = null;
	loading = false;
	
	ezTpl = null;
	isNew = true;
	customer = {
		customerType: 'business',
		customerName: '',
		contactPerson: '',
		phones: [],
		emails: [],
		addresses: [],
	};
	
	saveCallback;
	popupMode = false;
	
	
	selectedCustomerId = null;
	
	
	saveCallback;
	embedded = false;
	
	popupMode = false;
	
	
	init(e) {
		this.container = e;
		
		let id = null;
		
		if (this.popupMode == false)
			id = getUrlParam('id');
		if (this.popupMode == true)				// might be NULL
			id = this.selectedCustomerId;
		
		// already moved away?
		if (this.popupMode == false && routeSet('/customers/edit/') == false) {
			return;
		}
		
		if (id) {
			this.loadCustomer( id );
		}
		else {
			this.render();
		}
		
	}
	
	
	setSaveCallback( callback ) {
		this.saveCallback = callback;
	}
	
	setPopupMode( bln ) {
		this.popupMode = bln;
	}
	
	setCustomerId( id ) {
		this.selectedCustomerId = id;
	}

	
	render() {
//		console.log( this.tpl );
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setVar('customer', this.customer);
		this.ezTpl.setVar('isNew', this.isNew);
		this.ezTpl.setVar('popupMode', this.popupMode);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.setVar('embedded', this.embedded);
		this.ezTpl.setVar('popupMode', this.popupMode);
		this.ezTpl.render();
		
		$(this.container).find('[name=customerType]').on('change', function() {
			this.toggleCustomerType();
		}.bind(this));
		
		this.toggleCustomerType();
		
		
		$(this.container).find('input[name=customerName]').on( 'change keyup', this.updateTitle.bind(this) );
		this.updateTitle();
		
		
		$(this.container).find('input[name=customerName]').on('change', function() {
			this.value = trim(this.value);
		});
				
		$(this.container).find('input[name=contactPerson]').on('change', function() {
			this.value = ucfirst( trim(this.value) );
		});
		
		$(this.container).find('input[name=vatNumber], input[name=iban], input[name=bic]').on('change', function() {
			this.value = trim(this.value.toUpperCase());
		});
		
		
		$(this.container).find('#tbody-emails').sortable( {
			axis: 'y',
			handle: '.sort-handle'
		});
		
		$(this.container).find('#tbody-phones').sortable( {
			axis: 'y',
			handle: '.sort-handle'
		});
		
		$(this.container).find('#tbody-addresses').sortable( {
			axis: 'y',
			handle: '.sort-handle'
		});
		
		
		focusFirstField('#frmCustomer');
		
		window.dispatchEvent( new Event('customer-edit-widget-after-render') );
		
		
		if (appConfig.isAdmin() && this.customer.customerId) {
			let alt = new ActivityLogTab( 'itx.erp.customer.model.Customer', this.customer.customerId );
			alt.show();
			
			let ftab = new FilesTab();
			ftab.showTab();
		}
		
	}
	
	toggleCustomerType() {
		
		let ct = $(this.container).find('input[name=customerType]:checked').val();
		
//		console.log(ct);
		
		let c = $(this.container);
		
		if (ct == 'business') {
			c.find('#contactPerson-container').css('display', '');
			c.find('ez-text[name=cocNumber]').css('display', '');
			c.find('ez-text[name=vatNumber]').css('display', '');
			c.find('ez-date[name=birthDate]').css('display', 'none');
		}
		else {
			c.find('#contactPerson-container').css('display', 'none');
			c.find('ez-text[name=cocNumber]').css('display', 'none');
			c.find('ez-text[name=vatNumber]').css('display', 'none');
			c.find('ez-date[name=birthDate]').css('display', '');
		}
	}
	
	updateTitle() {
		
		let customerName = $(this.container).find('input[name=customerName]').val();
		customerName = $.trim ( customerName );
		
		if (customerName == '') {
			$(this.container).find('.title-customer-name').text('');
		}
		else {
			$(this.container).find('.title-customer-name').text(' - ' + customerName);
		}
	}
	
	
	setCustomer( c ) {
		this.customer = c;
	}
	
	setCustomerName( name ) {
		this.customer.customerName = name;
		
		$(this.container).find(this.container).find('input[name=customerName]').val( name );
	}
	
	
	bindData() {
		let frm = $(this.container).find('#frmCustomer');
		
		this.customer.customerId    = frm.find('input[name=customerId]').val();
		this.customer.customerType  = frm.find('input[name=customerType]:checked').val();
		this.customer.customerName  = frm.find('input[name=customerName]').val();
		this.customer.contactPerson = frm.find('input[name=contactPerson]').val();
		this.customer.cocNumber     = frm.find('input[name=cocNumber]').val();
		this.customer.vatNumber     = frm.find('input[name=vatNumber]').val();
		this.customer.iban          = frm.find('input[name=iban]').val();
		this.customer.bic           = frm.find('input[name=bic]').val();
		this.customer.note          = frm.find('textarea[name=note]').val();
		
		this.customer.emails = new Array();
		this.customer.phones = new Array();
		this.customer.addresses = new Array();
		
		$(this.container).find('#tbody-emails > tr').each(function(index, node) {
			this.customer.emails.push( node['email'] );
		}.bind(this));
		
		$(this.container).find('#tbody-phones > tr').each(function(index, node) {
			this.customer.phones.push( node['phone'] );
		}.bind(this));
		
		$(this.container).find('#tbody-addresses  > tr').each(function(index, node) {
			this.customer.addresses.push( node['address'] );
		}.bind(this));
	}
	
	
	validate( callback_success, callback_error ) {
		showLoadingForm( '#frmCustomer' );
		
		this.bindData();
		
		postUrl( '/service/customers.do'
			, {
				a: 'validateCustomer',
				customer: this.customer
			}).then( async function(e) {
				let json = await e.json();
				hideLoadingForm( '#frmCustomer' );
				
				if (json.error) {
					// render errors
					formShowErrors( '#frmCustomer', json );
					
					if (callback_error)
						callback_error( json );
				}
				else {
					if (callback_success)
						callback_success( json );
				}
				
				this.loading = false;
				
			}.bind(this));
	}
	
	
	saveCustomer() {
		if (this.loading) {
			return;
		}
		
		this.loading = true;
		showLoadingForm( '#frmCustomer' );
		
		this.bindData();
		
		postJson( '/service/customers.do'
			, {
				a: 'save',
				customer: this.customer
			}).then(async function(e) {
				let json = await e.json();
				hideLoadingForm( '#frmCustomer' );
				
				if (json.error) {
					// render errors
					formShowErrors( '#frmCustomer', json );
				}
				else {
					// report succesfully saved
					reportUserMessage( 'Wijzigingen opgeslagen' );
					
					if (this.saveCallback) {
						this.saveCallback( json.customer );
					}
					else {
						// reload data?
						replaceRoute( '/customers/edit/?id=' + json.customer.customerId );
					}
				}
				
				this.loading = false;
				
			}.bind(this));
		
	}
	
	
	getCustomer() {
		this.bindData();
		return this.customer;
	}
	
	loadCustomer(customerId) {
		postUrl( '/service/customers.do'
			, {
				a: 'view',
				customerId: customerId
			}).then(async function(e) {
				let json = await e.json();
				
				// already moved away?
				if ( this.popupMode == false && routeSet('/customers/edit/') == false ) {
					return;
				}
				
				
				if (json.error) {
					showErrorWidget(json);
					
					if (this.popupMode)
						close_popup();
					return;
				}
				
				this.customer = json.customer;
				this.isNew = false;
				this.render();
				
				this.loading = false;
				
				dispatchEvent( new Event( 'CustomerEditWidget.customerLoaded' ) );
				
				this.loadNoteWidget();
			}.bind(this));
	}
	
	deleteCustomer() {
		let id = this.customer.customerId;
		
		
		showConfirmation('Verwijderen', 'Weet je zeker dat je deze relatie wilt verwijderen?', function() {
			postUrl( '/service/customers.do', {
				a: 'delete'
				, 'customerId' : id
			}).then(async function(e) {
				let json = await e.json();
				
				gotoRoute( '/customers/' );
				reportUserMessage( 'Relatie verwijderd' );
			});
		});
		
	}
	
	
	loadNoteWidget() {
		let notesContainer = $(this.container).find('#notes-container');
		
		let w = new NoteListWidget();
		w.setRefObject('customer');
		w.setRefId( this.customer.customerId );
		
		w.init( notesContainer );
	}

	
	addEmail() {
		let e = new EmailPopup();
		
		e.setCallbackSave((p) => {
			let ezTpl = $(this.container).find('#tbody-emails').get(0).eztemplate;
			ezTpl.createRecord( p );
		});
		
		e.showPopup();
	}

	editEmail( p, q ) {
		if ( $(p.target).hasClass('actions') || $(p.target).closest('td.actions').length > 0)
			return;
		
		if ( $(p.target).hasClass('sort-cell') || $(p.target).closest('.sort-cell').length > 0 )
			return;
		
		
		let rec = q['email'];
		
		let popup = new EmailPopup();
		popup.setEmail( rec );
		popup.setCallbackSave((emaildata) => {
			let ezfor = $(this.container).find('#tbody-emails').get(0).eztemplate;
			
			ezfor.updateRecord( q, emaildata );
		});
		popup.showPopup();
		
	}
	
	deleteEmail( evt, rec ) {
		$(rec).closest('tr').remove();
		
		console.log('test', $(this.container).find('#tbody-emails tr').length);
		if ($(this.container).find('#tbody-emails tr').length == 0) {
			$(this.container).find('.table-emails tbody.no-results').removeClass('hidden');
		}
	}
	
	
	
	
	
	addPhone() {
		let p = new PhonePopup();
		
		p.setCallbackSave((p) => {
			let ezTpl = $(this.container).find('#tbody-phones').get(0).eztemplate;
			ezTpl.createRecord( p );
		});
		
		p.showPopup();
	}

	editPhone( p, q ) {
		if ( $(p.target).hasClass('actions') || $(p.target).closest('td.actions').length > 0)
			return;
		if ( $(p.target).hasClass('sort-cell') || $(p.target).closest('.sort-cell').length > 0 )
			return;
		
		
		let rec = q['phone'];
		
		let popup = new PhonePopup();
		popup.setPhone( rec );
		popup.setCallbackSave((phonedata) => {
			let ezfor = $(this.container).find('#tbody-phones').get(0).eztemplate;
			
			ezfor.updateRecord( q, phonedata );
		});
		popup.showPopup();
		
	}
	
	deletePhone( evt, rec ) {
		$(rec).closest('tr').remove();
		
		if ($(this.container).find('#tbody-phones tr').length == 0) {
			$(this.container).find('.table-phones tbody.no-results').removeClass('hidden');
		}
	}
	
	
	
	
	
	addAddress() {
		let e = new AddressPopup();
		
		e.setCallbackSave((p) => {
			let ezTpl = $(this.container).find('#tbody-addresses').get(0).eztemplate;
			ezTpl.createRecord( p );
		});
		
		e.showPopup();
	}

	editAddress( p, q ) {
		if ( $(p.target).hasClass('actions') || $(p.target).closest('td.actions').length > 0)
			return;
		if ( $(p.target).hasClass('sort-cell') || $(p.target).closest('.sort-cell').length > 0 )
			return;
		
		
		let rec = q['address'];
		
		let popup = new AddressPopup();
		popup.setAddress( rec );
		popup.setCallbackSave((addressdata) => {
			let ezfor = $(this.container).find('#tbody-addresses').get(0).eztemplate;
			
			ezfor.updateRecord( q, addressdata );
		});
		popup.showPopup();
		
	}
	
	deleteAddress( evt, rec ) {
		$(rec).closest('tr').remove();
		
		if ($(this.container).find('#tbody-addresses tr').length == 0) {
			$(this.container).find('.table-addresses tbody.no-results').removeClass('hidden');
		}
	}
	
	
}


