
function postUrl( url, data, opts ) {
	
	opts = opts ?? {};
	
	let str = '';
	
	// data set? => build post url
	if (data !== null && data !== undefined) {
		let propNames = Object.getOwnPropertyNames(data);
		
		for(let i in propNames) {
			if (str != '')
				str += '&';
		
			let propName = propNames[i];
			str += encodeURIComponent(propName) + '=' + encodeURIComponent(data[propName]);
		}
	}
	
	let fetchOpts = {
		method: 'POST',
		headers: {
			'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
		}
	};
	if (str != '') {
		fetchOpts.body = str;
	}
	
	if (opts.signal)
		fetchOpts.signal = opts.signal;
	
	
	let r = fetch( appUrl(url)
			, fetchOpts);
			
	let p = new Promise((resolve, reject) => {
		r.then(async function(e) {
			
			if (e.status == 200) {
				resolve(e);
			}
			else {
				let json = await e.json();
				e.jsonData = json;
				
				console.log('jsondata', e.jsonData);
				
				reject(e);
				
				console.log('postUrl err', e);
				
				if (e.status == 401) {
					import('../app/widget/auth/AuthenticationWidget.js').then(function(mod) {
						let w = new mod['AuthenticationWidget']();
						w.init();
					});
					
					return;
				}
				
				
				let t = '';
				
				if (json && json.message) {
					t = json.message;
				}
				else {
					t += e.status;
					if (e.message)
						t += ', ' + e.message;
					if (e.statusText)
						t += ', ' + e.statusText;
				}
				
				showToastError( t );
			}
		});
	});
	
	
	p.catch(async function(e) {
		// not authenticated-error.. handled above
		if (e.status && e.status == 401) {
			return;
		}
		
		let msg = '';
		if (e.jsonData && e.jsonData.message) {
			msg = e.jsonData.message;
		}
		else {
			msg = e.message;
		}
		
		showAlert('Error', 'Error: ' + msg);
	});
	
	
	return p;
}


function postJson( url, data, opts ) {
	opts = opts ?? {};
	
	let fetchOpts = {
				method: 'POST',
				headers: {
					'Content-Type': 'application/json'
				},
				body: JSON.stringify( data )
	};
	
	if (opts.signal)
		fetchOpts.signal = opts.signal;
	

	let r = fetch( appUrl(url)
			, fetchOpts);
	
	let p = new Promise((resolve, reject) => {
		r.then(async function(e) {
			
			if (e.status == 200) {
				resolve(e);
			}
			else {
				reject(e);
				
				let json = await e.json();
				
				console.log('postUrl err', e);
				
				if (e.status == 401) {
					import('./widget/auth/AuthenticationWidget.js').then(function(mod) {
						let w = new mod['AuthenticationWidget']();
						w.init();
					});
					
					return;
				}
				
				
				let t = '';
				
				if (json && json.message) {
					t = json.message;
				}
				else {
					t += e.status;
					if (e.message)
						t += ', ' + e.message;
					if (e.statusText)
						t += ', ' + e.statusText;
				}
				
				showToastError( t );
			}
		});
		
		// throws error
		r.catch(function(e) {
			reject(e);
		})
	});
	
	return p;
}


function postForm( e ) {
	
	let data = {};
	
	let form = document.querySelector(e);
	
	let inps = form.querySelectorAll('input, select, textarea');
	for(let i = 0; i < inps.length; i++) {
		// TODO: ez-for as parent? => skip
		
		let node = inps.item(i);
		
		let name = inps.item(i).getAttribute('name');
		let val = null;
		
		if (node.nodeName == 'SELECT') {
			val = node.value;
		}
		else if (node.nodeName == 'INPUT') {
			if ( node.getAttribute('type') == 'checkbox' ) {
				if (node.checked)
					val = node.value;
			} else if (node.getAttribute('type') == 'radio' ) {
				if (node.checked)
					val = node.value;
				else
					continue;
			}
			else {
				val = inps.item(i).value;
			}
		}
		else if (node.nodeName == 'TEXTAREA') {
			val = node.value;
		}
		
//		console.log(name);
		if (endsWith(name, '[]')) {
			name = name.substr(0, name.length-2);
			console.log('yes', name);
			if (typeof data[name] == 'undefined')
				data[name] = new Array();
			data[name].push( val );
		}
		else {
			data[name] = val;
		}
	}
	
	// TODO: ez-for..
	console.log( data );
	
	showLoadingForm( e );
	
	let url = form.getAttribute('action');
	
	return fetch( url
		, {
			method: 'POST',
			headers: {
				'Content-Type': 'application/json'
			},
			body: JSON.stringify( data )
	});
}


function formShowErrors( frm, r ) {
	
	if (!r || !r.error)
		return;
	
	$(frm).find('.error').text('');
	$(frm).find('.error').hide();
	
	$('.error-list').remove();
	
	let errorList = $('<ul class="error-list" />');
	
	if (r.message) {
		let eli = $('<li />');
		eli.text( r.message );
		errorList.append( eli );
	}
	
	for( let i in r.errors ) {
		let err = r.errors[i];
		
		let errw = $(frm).find('[name='+err.fieldName+'] .error');
		errw.text( _(err.message) );
		errw.show();
		
		let eli = $('<li />');
		eli.text( _(err.fieldName) + ' - ' + err.message );
		errorList.append( eli );
	}
	
	$( frm ).prepend( errorList );
	
	hideLoadingForm( frm );
}


function parse_json( str, defaultVal ) {
	try {
		return JSON.parse( str );
	}
	catch (err) {
		if (typeof defaultVal != 'undefined')
			return defaultVal;
		else
			return null;
	}
}



function showLoadingForm( e ) {
	let frm = document.querySelector(e);
	
	let els = frm.querySelectorAll('input, select, textarea');
	for(let i=0; i < els.length; i++) {
		let el = els.item(i);
		
		el.prevLoadingDisabledVal = el.getAttribute('disabled');
		
		el.setAttribute('disabled', 'disabled');
	}
	
	let img = document.createElement('img');
	img.setAttribute('class', 'loading-icon');
	img.src = appUrl('/static/img/ajax-loader-big.gif');
	
	frm.appendChild( img );
}
function hideLoadingForm( e ) {
	let frm = document.querySelector(e);
	
	if (!frm)
		return;
	
	let ico = frm.querySelector('.loading-icon');
	if (ico && ico.parentNode)
		ico.parentNode.removeChild( ico );
	
	
	let els = frm.querySelectorAll('input, select, textarea');
	for(let i=0; i < els.length; i++) {
		let el = els.item(i);
		
		if (el.prevLoadingDisabledVal)
			el.setAttribute('disabled', el.prevLoadingDisabledVal);
		else
			el.removeAttribute('disabled');
	}
	
}


function uuidv4() {
	const hexDigits = '0123456789abcdef';
	const randomValues = new Uint8Array(16);
	window.crypto.getRandomValues(randomValues);
	randomValues[6] = (randomValues[6] & 0x0f) | 0x40; // Version 4
	randomValues[8] = (randomValues[8] & 0x3f) | 0x80; // Variant RFC 4122
	let uuid = '';
	for (let i = 0; i < 16; i++) {
	    uuid += hexDigits[randomValues[i] >> 4];
	    uuid += hexDigits[randomValues[i] & 0x0f];
	}
	return uuid;
}

function reportUserMessage( str ) {
	alertMessage( str, { timeout: 5000, alertType: 'success' });
}
function reportUserError( str ) {
	alertMessage( str, { timeout: 5000, alertType: 'danger' });
}
function reportUserWarning( str ) {
	alertMessage( str, { timeout: 5000, alertType: 'warning' });
}

function alertMessage( str, opts ) {
	opts = opts ? opts : {};
	
	let alertType = 'success';
	if (opts && opts.alertType) {
		alertType = opts.alertType;
	}
	
	let d = $('<div class="alert alert-'+alertType+'" role="alert" />');
	d.text( str );
	
	$('#content-header').append( d );
	
	if (opts.timeout) {
		setTimeout(function() {
			$(d).slideUp();
		}, opts.timeout);
	}
	
	return d;
}



function focusFirstField( container ) {
	if (!container)
		container = $('body');
	
	let l = $(container).find('input[type="text"], input[type="password"]');
	if (l.length > 0) {
		l.first().focus();
	}
}




function endsWith(haystack, str) {
	var i = haystack.lastIndexOf(str);
	
	return i != -1 && i == haystack.length - str.length;
}



function showConfirmation(title, body, callback_ok) {
	
	var html = '<div class="confirmation-dialog modal" tabindex="-1" role="dialog">';
	html += '<div class="modal-dialog">';
	html += '    <div class="modal-content">';
	html += '      <div class="modal-header">';
	html += '        <h4 class="modal-title"></h4>';
	html += '        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>';
	html += '      </div>';
	html += '      <div class="modal-body">';
//	html += '        <p>One fine body&hellip;</p>';
	html += '      </div>';
	html += '      <div class="modal-footer">';
	html += '        <button type="button" class="btn btn-default" data-bs-dismiss="modal">Annuleer</button>';
	html += '        <button type="button" class="btn btn-primary">Ok</button>';
	html += '      </div>';
	html += '    </div>';	// <!-- /.modal-content -->
	html += '  </div>';		// <!-- /.modal-dialog -->
	html += '</div>';		// <!-- /.modal -->

	$('.confirmation-dialog').remove();
	
	var d = $(html);
	$(document.body).prepend(d);
	
	$('.confirmation-dialog .modal-title').html(title);
	$('.confirmation-dialog .modal-body').append(body);
	$('.confirmation-dialog .btn-primary').click(function() {
		var r = callback_ok();
		
		// don't close if 'false' is returned
		if (typeof r == 'boolean' && r === false)
			return;
		
		$('.confirmation-dialog').modal('hide');
	});

	var myModal = new bootstrap.Modal( $('.confirmation-dialog').get(0), {
		show: true,
		keyboard: true
	});

	myModal.show();

	let inp = $('.confirmation-dialog').find('input[type="text"], input[type="password"], input[type=email]');
	
	if (inp.length > 0) {
		inp.first().focus();
	}
	else {
		$('.confirmation-dialog').find('.btn-primary').focus();
	}
}

function showAlert(title, body, callback_ok) {
	
	var html = '<div class="confirmation-dialog modal" tabindex="-1" role="dialog">';
	html += '<div class="modal-dialog">';
	html += '    <div class="modal-content">';
	html += '      <div class="modal-header">';
	html += '        <h4 class="modal-title"></h4>';
	html += '        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>';
	html += '      </div>';
	html += '      <div class="modal-body">';
	html += '      </div>';
	html += '      <div class="modal-footer">';
	html += '        <button type="button" class="btn btn-primary">Ok</button>';
	html += '      </div>';
	html += '    </div>';	// <!-- /.modal-content -->
	html += '  </div>';		// <!-- /.modal-dialog -->
	html += '</div>';		// <!-- /.modal -->

	// remove old dialog = backdrop
	$('.confirmation-dialog').remove();
	$('.modal-backdrop').remove();
	
	var d = $(html);
	$(document.body).prepend(d);
	
	$('.confirmation-dialog .modal-title').html(title);
	$('.confirmation-dialog .modal-body').append(body);
	$('.confirmation-dialog .btn-primary').click(function() {
		if (callback_ok)
			callback_ok();
		
		$('.confirmation-dialog').modal('hide');
	});
	
	var myModal = new bootstrap.Modal( $('.confirmation-dialog').get(0), {
		show: true,
		keyboard: true
	});

	myModal.show();
	
	$(d).find('.btn-primary').focus();
}


function showInlineWarning(message, opts) {
	opts = opts ? opts : {};
	
	$('.js-inline-warning').remove();
	
	var html = $('<div  class="js-inline-warning alert alert-warning" />');
	html.append(message);
	
	$('.main-content').prepend(html);
	
	if (opts.timeout) {
		setTimeout(function() {
			$(html).slideUp(function() { $(this).remove(); });
		}, opts.timeout);
	}
}

function showInlineSecondary(message) {
	var html = $('<div  class="js-inline-notice alert alert alert-secondary" />');
	html.append(message);
	
	$('.main-content').prepend(html);
}

function strtoint(str, default_val) {
	var s = str.replace(',', '.');
	s = s.replace(/[^\d-]/, '');
	
	s = $.trim(s);
	
	var i = parseInt(s);
	
	if (isNaN(i) && typeof(default_val) != 'undefined')
		return default_val;
	else
		return i;
}

function strtodouble(str, default_val) {
	if (str === null) return 0;
	if (typeof str == 'undefined') return 0;
	
	if (typeof str == 'number') return str;
	
	var pow_negative = -1;
	
	if (str.indexOf('e-') != -1)
		pow_negative = str.substr(str.indexOf('e-')+2);
	
	s = str.replace(/[^\d\.\-,]/g, '');
	
	s = $.trim(s);
	
	if (s.indexOf(',') != -1 && s.indexOf('.') != -1) {
		if (s.indexOf(',') < s.indexOf('.'))
			s = s.replace(',', '');
		else
			s = s.replace('.', '');
	}
	
	if (s.indexOf(',') != -1)
		s = s.replace(',', '.');
	
	var d = parseFloat(s);
	
	if (pow_negative != -1) {
		d = d / Math.pow(10, pow_negative);
	}
	
	
	if (isNaN(d) && typeof(default_val) != 'undefined')
		return default_val;
	else
		return d;
}


function is_numeric(val) {
	if (typeof val == 'undefined')
		return false;
	
	if (typeof val == 'number')
		return true;
	
	if (typeof val == 'string') {
		return val.length && val.match(/^\d+$/) != null;
	}
	
	return false;
}



function roundNumber(number, decimals) {
	if (typeof decimals == 'undefined')
		decimals = 2;
	
	// round same way as php
	var n = strtodouble(number.toString());
	var i = Math.round(n * Math.pow(10, decimals));
	i = i / Math.pow(10, decimals);
	
	return i;
	
	// round same way as php (old)
//	var n = strtodouble(number.toString());
//	var i = parseInt(n * 1000);
//	i = i / 1000;
//	return i.toFixed(2);
	
	
	// 
//	n = n * Math.pow(10, decimals);
//	n = Math.round(n);
//	n = n / Math.pow(10, decimals);
//	
//	return n;
}

function format_number(number, opts) {
	var number = roundNumber(number, 2);
	
	return format_price(number, false, opts);
}

function format_price(val, currency, opts) {
	
	opts = opts ? opts : {};
	if (!opts.thousands) opts.thousands = ' ';
	
	if (val == null) return '';
	
	var s = val.toString();
//	s = s.replace('.', ',');
	s = s.replace(',', '.');
	
	var d = strtodouble(s, 0);
	s = d.toFixed(2).toString();
	
	var pos_decimal = s.indexOf('.');
	
	var s2 = s.substr(pos_decimal);
	for(var x=1; x <= pos_decimal; x++) {
		if (s.charAt(0) == '-' && x == pos_decimal) {
			// negative number & end reached? => never add thousands-char
		}
		else if ((x-1) % 3 == 0 && x != 1) {
			s2 = opts.thousands + s2;
		}
		
		s2 = s.charAt(pos_decimal - x) + s2;
	}
	
	if (currency)
		s2 = '€ ' + s2;
	
	s2 = s2.replace('- ', '-');
	var dotPos = s2.lastIndexOf('.');
	if (dotPos != -1) {
		s2 = s2.substr(0, dotPos) + ',' + s2.substr(dotPos+1);
	}
	
	return s2;
}

function format_percentage( val ) {
	
	if (val == null) return '';
	
	var d = strtodouble(val, 0);
	var s = d.toString();
	
	s = s.replace('.', ',');
	
	s = s + '%';
	
	return s;
}

function format_time(p1, p2) {
	if (!p1)
		return null;
	
	if (isNaN(p1)) {
		p1 = str2datetime(p1);
	}
	if (isNaN(p1) == false && p1 > 100000) {
		p1 = new Date(p1);
	}
	
	// date object?
	if (typeof p1 == 'object' && 'getMinutes' in p1) {
		p2 = p1.getMinutes();
		p1 = p1.getHours();
	}
	if (typeof p1 == 'string' && p1.indexOf(':')) {
		let toks = p1.split(':');
		p2 = toks[1];
	}
	
	p1 = parseInt(p1);
	p2 = parseInt(p2);
	
	if (p1 < 10)
		p1 = '0' + p1;
	if (p2 < 10)
		p2 = '0' + p2;
	
	return p1 + ':' + p2;
}


function validate_email(mail)  {
	// credits to https://www.w3resource.com/javascript/form/email-validation.php
	if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(mail)) {
		return true;
	} else {
		return false;
	}
}



function valid_date(value) {
	if (typeof value == 'undefined' || value === null) {
		return false;
	}
	
	if (typeof value == 'number') {
		let date = new Date( value );
		if ( date.getFullYear() >= 2000)
			return true;
	}
	
	if (value == '00-00-0000' || value == '0000-00-00')
		return false;
	if (value.match(/^\d{2}-\d{2}-\d{4}$/))
		return true;
	if (value.match(/^\d{4}-\d{2}-\d{2}$/))
		return true;

	return false;
}

function valid_datetime(value) {
	if (value !== null && typeof value == 'object' && 'getMinutes' in value) {
		return true;
	}
	
	if (isNaN(value) == false && value > 315529200000)
		return true;
	
	
	if (typeof value == 'undefined' || value === null) {
		return false;
	}
	
	if (value == '00-00-0000 00:00:00' || value == '0000-00-00  00:00:00')
		return false;
	if (value.match(/^\d{2}-\d{2}-\d{4} \d{2}:\d{2}:\d{2}$/))
		return true;
	if (value.match(/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/))
		return true;
	if (value.match(/^\d{2}-\d{2}-\d{4} \d{2}:\d{2}$/))
		return true;
	if (value.match(/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}$/))
		return true;

	return false;
}

function str2datetime(str) {
	if (isNaN(str) == false && str > 315529200000)
		return new Date(str);
	
	if (valid_datetime(str) == false)
		return null;
	
	// already Date object?
	if (str !== null && str instanceof Date) {
		return str;
	}
	
	
	var dateTime = str.split(' ');
	
	var tokensYear = dateTime[0].split('-');
	var tokensTime = dateTime[1].split(':');
	
	
	var y;
	var m;
	var d;
	var hour = tokensTime[0];
	var min = tokensTime[1];
	var sec = 0;
	if (tokensTime.length == 3)
		tokensTime[2];
	
	if (tokensYear[0].length == 4) {
		y = parseInt(tokensYear[0]);
		m = parseInt(tokensYear[1]);
		d = parseInt(tokensYear[2]);
	} else {
		y = parseInt(tokensYear[2]);
		m = parseInt(tokensYear[1]);
		d = parseInt(tokensYear[0]);
	}
	
	return new Date(y, m-1, d, hour, min, sec);
}

function str2date(str) {
	
	if (isNaN(str) == false) {
		return new Date( str );
	}
	
	if (str instanceof Date)
		return str;
	
	if (valid_date(str)) {
		// perfecto
	} else if (valid_datetime(str)) {
		var yearTime = str.split(' ');
		str = yearTime[0];
	} else {
		return null;
	}
	
	var tokens = str.split('-');
	
	if (tokens[0].length == 4) {
		var y = parseInt(tokens[0]);
		var m = parseInt(tokens[1]);
		var d = parseInt(tokens[2]);
		
		return new Date(y, m-1, d);
	} else {
		var y = parseInt(tokens[2]);
		var m = parseInt(tokens[1]);
		var d = parseInt(tokens[0]);
		
		return new Date(y, m-1, d, 12, 0, 0);
	}
}

function previous_month(date, no) {
	if (typeof no == 'undefined')
		no = 1;
	
	return next_month(date, no*-1);
}

function next_month(date, no) {
	if (typeof date == 'string') {
		date = str2date( date );
	}
	if (typeof no == 'undefined')
		no = 1;

	var calcDate = new Date( date.getFullYear(), date.getMonth() + no, 15, 12 );

	var dim = days_in_month( date );
	var calcDim = days_in_month( calcDate );
	
	if (date.getDate() == dim || date.getDate() > calcDim) {
		calcDate.setDate( calcDim );
	} else {
		calcDate.setDate( date.getDate() );
	}
	
	return format_date( calcDate );
}


function start_of_week( date ) {
	let d = str2date( date );
	
	while( d.getDay() != 1 ) {	// 1 = monday
		d = str2date( previous_day(d) );
	}
	return d;
}
function end_of_week( date ) {
	let d = str2date( date );
	
	while( d.getDay() != 0 ) {	// 0 = sunday
		d = str2date( next_day(d) );
	}
	return d;
}

function start_of_month( date ) {
	if (!date) date = new Date();
	
	let d = str2date( date );
	
	let d2 = new Date();
	d2.setHours(12, 0, 0);
	
	d2.setFullYear( d.getFullYear(), d.getMonth(), 1 );
	return format_date( d2 );
}

function end_of_month( date ) {
	if (!date) date = new Date();
	
	let d = str2date( date );
	
	let d2 = new Date();
	d2.setHours(12, 0, 0);
	
	d2.setFullYear( d.getFullYear(), d.getMonth()+1, 0 );
	return format_date( d2 );
}

function start_of_year( date ) {
	if (!date) date = new Date();
	let d = str2date( date );
	return new Date( d.getFullYear(), 0, 1, 12, 0, 0 );
}
function end_of_year( date ) {
	if (!date) date = new Date();
	let d = str2date( date );
	return new Date( d.getFullYear()+1, 0, 1, 12, 0, 0 );
}


function previous_week(date, no) {
	if (!no)
		no = 1;
	return next_week( date, no*-1 );
}
function next_week(date, no) {
	if (typeof no == 'undefined')
		no = 1;
	
	if (typeof date == 'string') {
		date = str2date( date );
	}

	var calcDate = new Date( date.getFullYear(), date.getMonth(), date.getDate()+(7*no), 12 );

	return format_date( calcDate );
}

function week_no( date ) {
	date = str2date( date );
	
	let weeknumber = moment(format_date(date), "YYYY-MM-DD").week();
	
	return weeknumber;
}

function week_year( date ) {
	date = str2date( date );
	
	let y = moment(format_date(date), "YYYY-MM-DD").weekYear();
	
	return y;
}

function weeks_in_year( year ) {
	let y = parseInt(year);
	
	weeks = moment(y + '06-01', "YYYY-MM-DD").weeksInYear();
	
	return weeks;
}

function weeks_between( date1, date2 ) {
	date1 = str2date(date1);
	date2 = str2date(date2);
	
	if (!date1 || !date2)
		return null;
	
	let y1 = moment(format_date(date1), "YYYY-MM-DD").weekYear();
	let y2 = moment(format_date(date2), "YYYY-MM-DD").weekYear();
	
	if (y1 != y2) {
		if (y2 > y1) {
			let y = y1;
			
			let w = 0;
			w += (weeks_in_year(y) - moment(format_date(date1), "YYYY-MM-DD").week());
			while (++y < y2) {
				w += weeks_in_year(y);
			}
			w += moment(format_date(date2), "YYYY-MM-DD").week();
			
			return w;
		}
		if (y2 < y1) {
			let y = y1;
			
			let w = 0;
			w -= moment(format_date(date1), "YYYY-MM-DD").week();
			while (--y > y2) {
				w -= weeks_in_year(y);
			}
			w -= weeks_in_year(y) - moment(format_date(date2), "YYYY-MM-DD").week();
			return w;
		}
	}
	
	let w1 = moment(format_date(date1), "YYYY-MM-DD").week();
	let w2 = moment(format_date(date2), "YYYY-MM-DD").week();
	
	return w2 - w1;
}


function str_hoursBetween( d1, d2 ) {
	d1 = str2datetime( d1 );
	d2 = str2datetime( d2 );
	
	if (!d1 || !d2)
		return '';
	
	// diff in seconds
	let diff = Math.round( (d2.getTime() - d1.getTime()) / 1000 );
	
	let fraction_minutes = (diff % 3600) / 3600;
	
	let hours = (diff - (diff % 3600)) / 3600;
	
	
	let t = '';
	if (hours != 0) {
		t += hours + ' ' + _('hour');
	}
	if (fraction_minutes != 0) {
		t += ' ' + Math.round(fraction_minutes*60) + ' ' + _('min.');
	}
	
	return t;
}

function str_fraction2hours( f ) {
	
	let fract_mins = f%1;
	let hours = f - fract_mins;
	
	let t = '';
	
	if (hours > 0) {
		t += hours + ' ' + _('hour');
	}
	if (fract_mins > 0) {
		if (t != '')
			t += ' ';
		t += Math.round( 60 * fract_mins ) + ' ' + _('min.');
	}
	return t;
}




// credits @ https://stackoverflow.com/questions/16590500/calculate-date-from-week-number-in-javascript
function week2date( year, weekNo ) {
	var simple = new Date(year, 0, 1 + (weekNo - 1) * 7);
	var dow = simple.getDay();
	var ISOweekStart = simple;
	if (dow <= 4)
		ISOweekStart.setDate(simple.getDate() - simple.getDay() + 1);
	else
		ISOweekStart.setDate(simple.getDate() + 8 - simple.getDay());
	
	return ISOweekStart;
}

// credits @ https://weeknumber.com/how-to/javascript
function date2week( date ) {
	if (typeof date == 'string') {
		date = str2date( date );
	}
	
	date.setHours(0, 0, 0, 0);
	
	// Thursday in current week decides the year.
	date.setDate(date.getDate() + 3 - (date.getDay() + 6) % 7);
	
	// January 4 is always in week 1.
	var week1 = new Date(date.getFullYear(), 0, 4);
	
	// Adjust to Thursday in week 1 and count number of weeks from date to week1.
	return 1 + Math.round(((date.getTime() - week1.getTime()) / 86400000
			- 3 + (week1.getDay() + 6) % 7) / 7);
}

function date2weekyear( date ) {
	if (typeof date == 'string') {
		date = str2date( date );
	}
	
	week = date2week( date ) + '';
	if (week.length == 1)
		week = '0' + week;
	
	return date.getFullYear() + '-' + week;
}



function days_in_month( date ) {
	if (typeof date == 'string')
		date = str2date(date);
	 
	return new Date(date.getFullYear(), date.getMonth()+1, 0, 12).getDate(); 
}

function days_between(d1, d2) {
	if (typeof d1 == 'string') {
		d1 = str2date( d1 );
	}
	if (typeof d2 == 'string') {
		d2 = str2date( d2 );
	}

	var msinday = 1000 * 60 * 60 * 24;

	var s = Date.UTC(d1.getFullYear(), d1.getMonth(), d1.getDate());
	var e = Date.UTC(d2.getFullYear(), d2.getMonth(), d2.getDate());

	return (e - s) / msinday;
}

function months_between(d1, d2) {
	if (typeof d1 == 'string') {
		d1 = str2date( d1 );
	}
	if (typeof d2 == 'string') {
		d2 = str2date( d2 );
	}
	
	var months = (d2.getFullYear() - d1.getFullYear()) * 12;
	
	months = months + (d2.getMonth() - d1.getMonth());
	
	return months;
}


function previous_day(date, no) {
	if (typeof no == 'undefined') no = 1;
	
	return next_day( date, no*-1 );
}

function next_day(date, no) {
	if (typeof no == 'undefined') no = 1;
	
	if (typeof date == 'string') {
		date = str2date( date );
	}

	var c = new Date( date.getFullYear(), date.getMonth(), date.getDate()+no, 12);

	return format_date( c );
}

function minutes2human( min ) {
	min = parseInt(min);
	
	let t = '';
	
	if (min > 60) {
		let hour = Math.floor( min / 60 );
		
		t = hour + ' uur'
		if (min%60 != 0)
			t += ', ' + (min%60) + ' min.';
	}
	else {
		t = min + ' min.';
	}
	
	return t;
}



function date2number(date) {
	if (typeof date == 'string') {
		date = str2date( date );
	}
	
	// year
	var year = date.getFullYear();
	
	// month
	var month = '';
	if (date.getMonth() < 9) {					// month = 0-11
		month = '0' + (date.getMonth()+1);
	} else {
		month = (date.getMonth()+1);
	}
	
	// day
	var day = '';
	if (date.getDate() < 10) {
		day = '0' + date.getDate();
	} else {
		day = date.getDate();
	}

	return parseInt( year + '' + month + '' + day );
}


function format_date(date, opts) {
	
	if (typeof date == 'number') {
		date = new Date( date );
	}
	if (typeof date == 'string' && (valid_date(date) || valid_datetime(date))) {
		date = str2date(date);
	}
	
	// only Date-objects can be formatted
	if ((date instanceof Date) == false) {
		console.error('format_date(), invalid object: ' + date);
		return '';
	}
	

	var t = '';
	
	opts = opts ? opts : {};
	
	// year
	var year = t + date.getFullYear();
	
	// month
	var month = '';
	if (date.getMonth() < 9) {					// month = 0-11
		month = '0' + (date.getMonth()+1);
	} else {
		month = (date.getMonth()+1);
	}
	
	// day
	var day = '';
	if (date.getDate() < 10) {
		day = '0' + date.getDate();
	} else {
		day = date.getDate();
	}
	
	if (isNaN(day) || isNaN(month) || isNaN(year))
		return '';
	
	if (opts.dmy) {
		return day + '-' + month + '-' + year;
	} else if (opts.ymdnumeric) {
		var generatedEndDate = parseInt(year) * 10000;
		generatedEndDate = generatedEndDate + (parseInt(month)*100);
		generatedEndDate = generatedEndDate + parseInt(day);
		return generatedEndDate;
	} else {
		return year + '-' + month + '-' + day;
	}
}

function date2ymd(date, opts) {
	if (typeof date == 'number') {
		date = new Date( date );
	}
	if (typeof date == 'string' && valid_date(date)) {
		date = str2date(date);
	}
	
	// only Date-objects can be formatted
	if ((date instanceof Date) == false) {
		console.error('format_date(), invalid object: ' + date);
		return '';
	}

	
	let ymd = 0;
	ymd += date.getFullYear();
	ymd *= 100;
	ymd += (date.getMonth()+1);
	ymd *= 100;
	ymd += date.getDate();	

	return ymd;
}

function format_datetext_short(date) {
	let t = '';
	
	t += date.getDate();
	t += ' ';
	t += _('monthshort.' + (date.getMonth()+1)).toLowerCase();
	t += ' ';
	t += date.getFullYear();
	return t;
}


function format_datetime(date, opts) {
	
	if (typeof date == 'number') {
		date = new Date( date );
	}
	
	if (valid_datetime(date)) {
		date = str2datetime(date);
	}
	
	// only Date-objects can be formatted
	if ((date instanceof Date) == false) {
		console.error('format_datetime(), invalid object: ' + date);
		return '';
	}
	
	opts = opts ? opts : {};
	if (typeof opts.skipSeconds == 'undefined') opts.skipSeconds = false;
	
	var t = '';
	
	// day
	if (date.getDate() < 10) {
		t = t + '0' + date.getDate();
	} else {
		t = t + date.getDate();
	}
	
	// month
	t += '-';
	if (date.getMonth() < 9) {					// month = 0-11
		t = t + '0' + (date.getMonth()+1);
	} else {
		t = t + (date.getMonth()+1);
	}
	
	// year
	t += '-';
	t = t + date.getFullYear();
	

	
	// hour
	let hour = '';
	if (date.getHours() < 10) {
		hour = hour + '0' + date.getHours();
	} else {
		hour = hour + date.getHours();
	}
	
	// minutes
	hour += ':';
	if (date.getMinutes() < 10) {
		hour = hour + '0' + date.getMinutes();
	} else {
		hour = hour + date.getMinutes();
	}
	
	// seconds
	if (opts.skipSeconds == false) {
		hour += ':';
		if (date.getSeconds() < 10) {
			hour = hour + '0' + date.getSeconds();
		} else {
			hour = hour + date.getSeconds();
		}
	}
	
	if (typeof opts.showZero != 'undefined' && opts.showZero == false && (hour == '00:00' || hour == '00:00:00')) {
		return t;
	}
	
	return t + ' ' + hour;
}

function format_datetime_minuts(date, opts) {
	opts = opts ? opts : {};
	
	var d = format_datetime(date, opts);
	d = d.replace(/:\d\d$/, '');
	
	
	if (typeof opts.showZero != 'undefined' && opts.showZero == false && endsWith(d, '00:00')) {
		return d.substring(0, 10);
	} else {
		return d;
	}
}
// ;)
function format_datetime_minutes(date, opts) {
	return format_datetime_minuts(date, opts);
}


function file_extension(f) {
	if (!f)
		return '';
	
	let r = String(f).lastIndexOf('.');
	if (r == -1)
		return '';
	
	let ext = f.substring( r + 1 );
	
	return ext.toLowerCase();
}


function slugify(str) {
	str = str.toLowerCase();
	str = str.replace(/[^a-z0-9 \\-\\_]/g, '');
	str = str.replace(/\s+/g, '-');
	str = str.replace(/_/g, '-');
	
	str = str.replace(/-+/g, '-');
	str = str.replace(/^-+/, '');
	str = str.replace(/-+$/, '');
	
	return str;
}


function text2date(str) {
	var year = -1;
	var month = -1;
	var day = -1;
	
	var hour = 12;
	var minuts = 0;
	var seconds = 0;
	
	if (str == null)
		return null;
	
	if (str.match(/^\d{4}-\d{2}-\d{2}$/)) {
		var tokens = str.split('-');
		year  = parseInt(tokens[0]);
		month = parseInt(tokens[1])-1;
		day   = parseInt(tokens[2]);
	}
	if (str.match(/^\d{2}-\d{2}-\d{4}$/)) {
		var tokens = str.split('-');
		day   = parseInt(tokens[0]);
		month = parseInt(tokens[1])-1;
		year  = parseInt(tokens[2]);
	}
	if (str.match(/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/)) {
		var yearTime = str.split(' ');
		
		var tokens = yearTime[0].split('-');
		year  = parseInt(tokens[0]);
		month = parseInt(tokens[1])-1;
		day   = parseInt(tokens[2]);

		var tokens2 = yearTime[1].split(':');
		hour    = parseInt(tokens2[0]);
		minuts  = parseInt(tokens2[1]);
		seconds = parseInt(tokens2[2]);
	}

	if (year != -1) {
		return new Date(year, month, day, hour, minuts, seconds, 0);
	} else {
		return new Date(str);
	}
}



function trim(o) {
	return o.replace(/^\s+/,'').replace(/\s+$/,'');
}

function ucfirst( str ) {
	if (typeof str != 'string' || str.length == 0) {
		return str;
	}
	
	let p1 = str.substring(0, 1);
	let p2 = str.substring(1);
	
	return p1.toUpperCase() + p2;
}


function is_true(v) {
	if (typeof v == 'undefined')
		return false;
	
	if (typeof v == 'string') {
		if (v == '1' || v == 'true' || v == 't' || v == 'on')
			return true;
		else
			return false;
	}
	
	if (typeof v == 'number' && v != 0)
		return true;
	
	return false;
}


function getAjxParams() {
	var l = window.location.toString();
	
	if (l.indexOf('#') == -1)
		return '';
	
	l = l.substr(l.indexOf('#')+1);
	
	// set params in array
	var p = [];
	var tokens = l.split('\&');
	for(var x=0; x < tokens.length; x++) {
		var key = tokens[x].substr(0, tokens[x].indexOf('='));
		var data = unescape(tokens[x].substr(tokens[x].indexOf('=')+1));
		
		p[key] = data;
	}
	
	return p;
}
function getAjxParam(name) {
	var params = getAjxParams();
	
	return params[name];
}

function getUrlParams() {
	// get param string
	var l = window.location.toString();
	if (l.indexOf('?') == -1)
		return '';
	l = l.substr(l.indexOf('?')+1);
	if (l.indexOf('#') > -1)
		l = l.substr(0, l.indexOf('#'));
	
	// set params in array
	var p = [];
	var tokens = l.split('\&');
	for(var x=0; x < tokens.length; x++) {
		var key = tokens[x].substr(0, tokens[x].indexOf('='));
		var data = unescape(tokens[x].substr(tokens[x].indexOf('=')+1));
		
		p[key] = data;
	}
	
	return p;
}

function getUrlParam(name) {
	var params = getUrlParams();
	
	if (params[name])
		return params[name];
	else
		return null;
}


function serialize2object( container ) {
	var obj = {};
	
	$(container).find('input, select, textarea').each(function(index, node) {
		
		if (node.type == 'radio' && $(node).prop('checked') == false)
			return;
		
		if (node.type == 'checkbox' && $(node).prop('checked') == false) {
			obj[node.name] = '';
			return;
		}
		
		if (endsWith(node.name, '_submit'))
			return;
		
		if (node.name && node.name != '') {
			obj[node.name] = node.value;
		}
	});
	
	return obj;
}

function getCookie(name) {
	const parts = document.cookie.split(';');
	
	for(let i in parts) {
		let toks = parts[i].split('=', 2);
		if (toks[0] == name) {
			if (toks.length > 1)
				return toks[1];
			else
				return null;
		}
	}
	
	return null;
}




function serialize2get( frm, opts ) {
	opts = opts ? opts : {};
	var params = new Array();
	
	$( frm ).find('input, select, textarea').each(function(index, node) {
		var n = $(node).attr('name');
		var v = $(node).val();
		
		if ($(node).attr('type') == 'checkbox' && $(node).prop('checked') == false)
			return;
		if ($(node).attr('type') == 'radio' && $(node).prop('checked') == false)
			return;

		if (n == 'form-name') return;
		if (n == 'object-locked') return;
		if (n == 'object_version') return;
		if (v == '') return;

		params.push( encodeURIComponent(n) + '=' + encodeURIComponent(v) );
	});
	
	return params.join('&');
}


/**
 * 
 * @return - popup, set r.get(0).close_callback = () -> { ... }
 */
function show_popup(headerText, data, opts) {
	
	opts = opts || {};
//	console.log(opts);

		
	if ($('.popup-background').length == 0) {
		var bg = $('<div class="popup-element popup-background" />');
		bg.click(function() {
			close_popup();
		});
		$(document.body).append(bg);
	}
	
	$(document.body).addClass('popup-container-visible');
	
	var popupNo = 1;
	$('.popup-container').each(function(index, node) {
		if (parseInt($(node).data('popup-no')) >= popupNo) {
			popupNo = parseInt($(node).data('popup-no'))+1;
		}
	});
	
	var popup = $('<div class="popup-element popup-container" />');
	popup.addClass('popup-container-'+popupNo);
	popup.data('popup-no', popupNo);
	popup.html( data );
	
	$(document.body).append(popup);
	
	$(popup).find('.popup-close-link').click(function() { close_popup(); });
	
	
	// popup indicator
	if ($('.popup-element.popup-tab').length == 0) {
		var popupTabs = $('<div class="popup-element popup-tab" />');
		$(document.body).append( popupTabs );
	}
	var pti = $('<div class="popup-tab-item" />');
	pti.text( headerText );
	pti.data('popup', popup.get(0));
	$('.popup-element.popup-tab').append( pti );
	
	
	$(window).trigger('popup-container-created', popup);
	
//	focusFirstField( popup );
	focusFirstField( popup );
	
	if (opts.renderCallback)
		opts.renderCallback(popup, data, xhr, textStatus);
	
	return popup;
}

$(document).keydown(function(evt) {
	
	// event originated from confirmation-dialog? skip..
	if (evt && evt.target && $(evt.target).closest('.confirmation-dialog').length > 0)
		return;
	
	if (evt.keyCode == 27) {
		close_popup();
	}
});

function close_popup() {
	// no popup? => skip
	if ($('.popup-element').length == 0) {
		return;
	}
	
	// remove only last opened
	var popupContainers = $('.popup-container');
	var lastPopupContainer = popupContainers.get( popupContainers.length - 1 );
	
	$('.popup-element.popup-tab .popup-tab-item').each(function(index, node) {
		if ($(node).data('popup') == lastPopupContainer) {
			$(node).remove();
		}
	});
	
	if ( lastPopupContainer.close_callback ) {
		lastPopupContainer.close_callback();
	}
	
	$(lastPopupContainer).remove();
	
	
	if ($('.popup-container').length == 0) {
		$('.popup-element').remove();
		$(document.body).removeClass('popup-container-visible');
		
		$(window).trigger('close-popup');
	}
}

function destroy_popup() {
	$('.popup-background').remove();
	$('.popup-container').remove();
	$('.popup-element').remove();
}


window.addEventListener('EzTemplate.updated', function() {
	if ($(document).datetimepicker) {
		$(document.body).find('.input-pickadate').each(function(index, node) {
			if ($(node).data('pickadate-set'))
				return;
			$(node).data('pickadate-set', true);
			
			$(node).attr("autocomplete", "off");
			$( $(node).parent() ).css('position', 'relative');
			$( $(node).parent() ).css('overflow', 'visible');
			
			var pickerSettings = {
				locale: 'nl',
				format: 'DD-MM-YYYY',
				useCurrent: false,
				calendarWeeks: true
			};

			if ($(node).data('show-weeks') ) pickerSettings.calendarWeeks = true;

			$(node).datetimepicker( pickerSettings );
			
			$(node).on('dp.show', function() {
				$(this).data('date-value', this.value);
			});
			$(node).on('dp.hide', function() {
				var v = $(this).data('date-value');
				
				if (v != this.value)
					$(this).trigger('change');
			});
		});
		
		$(document.body).find('.input-pickatime').each(function(index, node) {
			if ($(node).data('pickadate-set'))
				return;
			$(node).data('pickadate-set', true);
			
			$(node).attr("autocomplete", "off");
			$( $(node).parent() ).css('position', 'relative');
			$( $(node).parent() ).css('overflow', 'visible');
			$(node).datetimepicker({
				locale: 'nl',
				format: 'HH:mm',
				useCurrent: false
			});
		});
		

		$(document.body).find('.input-pickadatetime').each(function(index, node) {
			if ($(node).data('pickadate-set'))
				return;
			$(node).data('pickadate-set', true);
			
			$(node).attr("autocomplete", "off");
			$( $(node).parent() ).css('position', 'relative');
			$( $(node).parent() ).css('overflow', 'visible');
			$(node).datetimepicker({
				locale: 'nl',
				format: 'DD-MM-YYYY HH:mm',
				sideBySide: true,
				useCurrent: false
			});
			
			// ez-datetime? & showZero=false?
			let ezparent = $(node).closest('ez-datetime');
			if (ezparent.length == 1) {
				let showzero = typeof ezparent.attr('showzero') != 'undefined' && isTrue( ezparent.attr('showzero') ) ? true : false;
				if (showzero == false && node.value.indexOf(' 00:00') != -1) {
					node.value = format_date( node.value, {dmy: true});
				}
			}
		});
	}
});



function bytes2human( n ) {
	if (typeof n != 'number')
		n = parseInt(n);
	
	if (isNaN(n))
		return '';
	
	if (n > 1024 * 1024) {
		n = n / (1024*1024);
		return roundNumber(n, 0) + ' mb';
	}
	else if (n > 1024) {
		n = n / (1024);
		return roundNumber(n, 0) + ' kb';
	}
	else {
		n += ' b';
	}
	
	return n;
}

function activityFieldName( f ) {
	let langcode = 'activity.' + f.replace(/\.\d+\./g, '.');
	
	let recno = f.replace(/^.*?\.(\d+)\..*$/, '$1');
	recno = parseInt( recno );
	
	let text = _( langcode );
	
	if (text == langcode)
		return f;
	
	if (isNaN(recno))
		return text;
	else
		return recno + ' - ' + text;
}


function calculateVatExclPrice( price, vatPercentage ) {
	return roundNumber(price * vatPercentage / 100, 2);
}
function calculateVatInclPrice( price, vatPercentage ) {
	let p = price * vatPercentage / (vatPercentage+100);
	return roundNumber( p, 2 );
}



var itxToastTimeout = null;
function showToastMessage( msg, opts ) {
	opts = opts ? opts : {};
	
	// remove old
	if ($('.itx-toast').length == 0) {
		$(document.body).append('<div class="itx-toast"></div>');
	}
	
	
	let tm = $('<div class="toast-message-container"><div class="toast-message"></div></div>');
	
	if (opts.error) {
		tm.addClass('error');
	}
	
	
	tm.find('.toast-message').text( msg );
	$('.itx-toast').prepend( tm );
	
	itxToastTimeout = setTimeout(function() {
		tm.animate({
			height: 0
		}, 500, 'swing', function() {
			$(tm).remove();
			if ($('.itx-toast > .toast-message').length == 0) {
				$('.itx-toast').remove();
			}
		});
	}, 2000);
}


function showToastError( msg, opts ) {
	opts = opts ? opts : {};
	opts.error = true;
	showToastMessage(msg, opts);
}


function ifempty(val, fallback) {
	if (typeof val != 'undefined' 
			&& val !== null
			&& val !== ''
			&& val != '0000-00-00'
			&& val != '0000-00-00 00:00'
			&& val != '0000-00-00 00:00:00') {
		return val;
	}
	
	return fallback;
}

function ifnull(val, fallback) {
	if (typeof val != 'undefined' && val !== null) {
		return val;
	}
	
	if (typeof fallback != 'undefined')
		return fallback;
	
	return '';
}


function elval( nameOrSelector, defaultVal ) {
	let c;
	
	// search by input/select/textarea.. EzTemplate also uses the name tag, which causes duplicates like <ez-text name="x"><input type="text" name="x" .../></ez-text>]
	
	c = document.querySelector('input[name="' + nameOrSelector + '"]' );
	if (!c) {
		c = document.querySelector('select[name="' + nameOrSelector + '"]' );
	}
	if (!c) {
		c = document.querySelector('textarea[name="' + nameOrSelector + '"]' );
	}
	if (!c) {
		c = document.querySelector( nameOrSelector );
	}
	
	if (c) {
		if (c.nodeName == 'INPUT' && c.getAttribute('type').toLowerCase() == 'checkbox') {
			if (c.checked == false)
				return false;
		}
		
		return c.value;
	}
	
	if (typeof defaultVal != 'undefined') {
		return defaultVal;
	}
	else {
		return null;
	}
}

function setval( nameOrSelector, val ) {
	c = document.querySelector('input[name="' + nameOrSelector + '"]' );
	if (!c) {
		c = document.querySelector('select[name="' + nameOrSelector + '"]' );
	}
	if (!c) {
		c = document.querySelector('textarea[name="' + nameOrSelector + '"]' );
	}
	if (!c) {
		c = document.querySelector( nameOrSelector );
	}

	if (c) {
		if (c.nodeName == 'INPUT' && c.getAttribute('type').toLowerCase() == 'checkbox') {
			if (val) {
				c.checked = true;
			}
			else {
				c.checked = false;
			}
			return;
		}
		
		c.value = val;
	}
	else {
		console.error('Error: setval(), nameOrSelector not found', nameOrSelector);
	}

}

function appendHtml( obj, html ) {
	obj.innerHTML += html;
}
function prependHtml( obj, html ) {
	obj.innerHTML = html + obj.innerHTML;
}


function isTrue( v ) {
	if (typeof v == 'undefined')
		return false;
	
	if (v === true || v === 1 || v === '1' || v == 'true' || v == 't' || v == 'on' || v == 'y')
		return true;
	else
		return false;
}

function truncate(str, maxLen) {
	if (str.length < maxLen)
		return str;
	
	
	let r = str.substr(0, maxLen);
	r = r + '...';
	return r;
}




function save_state( name, key, value ) {
	postUrl( '/service/state.do', {
		a: 'save',
		name: name,
		key: key,
		data: JSON.stringify( value )
	});
}

function save_state( name, key, value ) {
	postUrl( '/service/state.do', {
		a: 'save',
		name: name,
		key: key,
		data: JSON.stringify( value )
	});
}

function load_state( name, key, callback ) {
	postUrl( '/service/state.do', {
		a: 'load',
		name: name,
		key: key
	}).then(async function(e) {
		let json = await e.json();
		let d = JSON.parse( json.data );
		
		callback( d, json );
	});
}


function setSession( key, val ) {
	sessionStorage.setItem( key, JSON.stringify(val) );
}
function getSession( key, defaultVal ) {
	let r = sessionStorage.getItem( key );
	
	if (r === null && typeof defaultVal != 'undefined')
		return defaultVal;
	
	if (r !== null) {
		try {
			return JSON.parse(r);
		}
		catch (ex) {
			if ( typeof defaultVal != 'undefined')
				return defaultVal;
			else
				return null;
		}
	}
	return null;
}
function removeSession( key ) {
	sessionStorage.removeItem( key );
}
function clearSession() {
	sessionStorage.clear(); 
}


function getPathPart( pos ) {
	let appPath = appUrl('/');
	let p = window.location.pathname;
	
	// replace multiple slashes by 1
	p = p.replace(/\/+/g, '/');
	
	// remove app path
	if (p.indexOf(appPath) === 0)
		p = p.substring(appPath.length);
	
	// remove trailing /
	if (p.length > 0 && p.lastIndexOf('/') === p.length-1) {
		p = p.substring(0, p.length-1);
	}
	
	// empty? => return null
	if (p == '')
		return null;
	
	// return pos
	let tokens = p.split('/');
	if (pos >= 0 && pos < tokens.length) {
		return tokens[pos];
	}
	else {
		return null;
	}
}




function selectOptionExists(slct, val) {
	
	let opts = slct.options;
	for(let i=0; i < opts.length; i++) {
		if ( opts[i].value == val )
			return true;
	}
	
	return false;
}


async function add_customer_popup( inp ) {
	let mod = await import( itxapp.config.contextPath + '/static/app/widget/customers/CustomerEditWidget.js' );
	
	let w = Reflect.construct( mod['CustomerEditWidget'], [] );
	w.setSaveCallback((customer) => {
		let container = $(inp).closest('div.input');
		container.find('.widget-default-text').text( customer.customerName );
		container.find('.widget-value').val( customer.customerId );
		
		close_popup();
	})
	w.setPopupMode( true );
	
	let div = document.createElement('div');
	
	show_popup( _('Create customer'), div);
	
	w.init(div);
	
	
}



async function view_customer_popup( inp ) {
    let mod = await import( itxapp.config.contextPath + '/static/app/widget/customers/CustomerEditWidget.js' );

    let w = Reflect.construct( mod['CustomerEditWidget'], [] );
    w.setSaveCallback((customer) => {
            let container = $(inp).closest('div.input');
            container.find('.widget-default-text').text( customer.customerName );
            container.find('.widget-value').val( customer.customerId );

            close_popup();
    });

	let customerId = $(inp).closest('div.input').find('input.widget-value').val();
	if (!customerId) {
		showAlert( _('Error'), _('No customer selected') );
		return;
	}

    w.setPopupMode( true );
    w.setCustomerId( customerId );

    let div = document.createElement('div');

    show_popup( _('View customer'), div);

    w.init(div);
}


var itx_filters = {};
function add_filter( ...args ) {
	let filtername = args[0];
	
	if (typeof itx_filters[filtername] == 'undefined') {
		itx_filters[filtername] = [];
	}
	itx_filters[filtername].push( args );
}

function apply_filter( ...args ) {
	let filtername = args[0];
	
	let r = args[1];
	if (itx_filters[filtername] == 'undefined') {
		return r;
	}
	
	for(let i in itx_filters[filtername]) {
		let filter = itx_filters[filtername][i];
		let func = filter[1];
		let filter_args = args.slice(1);
		
		r = Reflect.apply( func, self, filter_args );
	}
	
	return r;
}



function insertNodeAtPos( selector, pos, newNode ) {
	let els = document.querySelectorAll( selector );
	
	if (els.length == 0) {
		console.error('insertNodeAtPos, error, no nodes for selector', selector);
		return;
	}
	
	let el = null;
	if ( pos >= 0 && pos < els.length ) {
		el = els[pos];
	}
	else {
		// fallback
		el = els[0];
	}
	
	el.parentNode.insertBefore( newNode, el );
}




function routeSet( route, params ) {
	params = params ? params : {};
	
	let u = window.location.pathname.toString();
	if ( toolboxConfig.contextPath != '' && u.indexOf( toolboxConfig.contextPath ) === 0 ) {
		u = u.substring( toolboxConfig.contextPath.length );
	}
	
	// shouldn't happen with .pathname...
	if (u.indexOf('?') != -1) {
//		let strparams = u.substring( u.indexOf('?')+1 );
		u = u.substring(0, u.indexOf('?'));
	}
	
	// no params set & route equals current route? => return true
	if (typeof params == 'undefined' && u == route) {
		return true;
	}
	
	// check with params
	if (u == route) {
		let urlParams = getUrlParams();
		for(let i in params) {
			if ( params[i] == null || typeof params[i] == 'undefined' )
				continue;
			
			// param differs?
			if ( params[i] != urlParams[i] ) {
				return false;
			}
		}
		
		return true;
	}
	
	return false;
}


