


add_filter('AppRouter.lookupRoute', (r, url) => {

	let routes = [];	
	routes.push({ url: '/contracts/', 							widget: 'contracts/ContractListWidget' });
	routes.push({ url: '/contracts/edit/', 						widget: 'contracts/ContractEditWidget' });
	routes.push({ url: '/contracts/tasks/', 					widget: 'contracts/tasks/ContractTaskListWidget' });
	routes.push({ url: '/masterdata/contracts/types/', 			widget: 'contracts/masterdata/ContractTypeListWidget' });
	routes.push({ url: '/masterdata/contracts/types/edit/', 	widget: 'contracts/masterdata/ContractTypeEditWidget' });
	
	routes.push({ url: '/masterdata/contracts/settings/', 		widget: 'contracts/masterdata/ContractSettingsWidget' });

	
	for(let i=0; i < routes.length; i++) {
		if (routes[i].url == url)
			return routes[i];
	}
	
	return r;
});





add_filter('MenuWidget.menuItems', (menuItems) => {
	
	menuItems.push( { sort:  400, url: '/contracts/', 					label: 'Contracten' } );
	menuItems.push( { sort:  450, url: '/contracts/tasks/', 			label: 'Contract taken' } );

	
	return menuItems;
});

add_filter('MasterData.menuItems', (menuItems) => {
	menuItems.push({
		'label': 'Contracten',
		'code': 'contracts',
		'items': [
			{ url: '/masterdata/contracts/settings/', 	'label': 'Contract instellingen' }
			, { url: '/masterdata/contracts/types/', 	'label': 'Contract typen' }
		]
	});
	
	return menuItems;
});


add_filter('EmailTemplateEditWidget.getTemplateTags', (tags, template) => {
	if (template.templateCode != 'CONTRACT_DAILY_ALERTS' && template.templateCode != 'CONTRACT_WEEKLY_UPDATE')
		return tags;
	
	tags.push({
		code: '[[alert_summary]]',
		description: 'Samenvatting openstaande alerts (voor in onderwerp)'
	});
	tags.push({
		code: '[[contract_alerts]]',
		description: 'Tabel met openstaande contracten (voor in mail)'
	});
	
	
	return tags;
});


window.addEventListener('CustomerEditWidget.customerLoaded', async (e) => {
	// Work Order tab
	let mod1 = await import('./app/widget/contracts/ContractTabWidget.js');

	let ctw = new mod1['ContractTabWidget']();
	ctw.render();

});

window.addEventListener('UserEditWidget.userLoaded', async () => {
	let mod1 = await import('./app/widget/contracts/events/UserActionEvents.js');

	new mod1['UserActionEvents']();

});


window.addEventListener('UserEditWidget.render', async () => {
	
	let mod1 = await import('./app/widget/contracts/events/UserEditEvents.js');

	new mod1['UserEditEvents']();
	
	
});


window.addEventListener('UserEditWidget.saveUser', async (evt) => {
	
	let o = document.querySelector('.user-edit-contract-settings');
	if (!o || !o.userEditEvents)
		return;
	
	
	o.userEditEvents.handleSaveUser( evt );
});

