


export class UserEditEvents {
	
	tpl = `
		<div class="user-edit-contract-settings">
			<ez-checkbox name="contractDailyAlerts"
							[checked]="settings.dailyAlerts"
							[onchange]="widget.dailyAlerts_Change"
							label="Dagelijkse alerts"></ez-checkbox>
							
			<ez-checkbox name="contractWeeklyUpdate"
									[checked]="settings.weeklyUpdate"
									[onchange]="widget.weeklyUpdate_Change"
									label="Wekelijkse update"></ez-checkbox>
		</div>
	`;
	
	
	settings = {
		dailyAlerts: true,
		weeklyUpdate: true
	};
	
	
	constructor() {
		
		this.init();
		
	}
	
	
	init() {
		
		let user_id = $('#frmUser input[name=user_id]').val();
		
		if ( user_id != '' ) {
			this.loadUserSettings();
		}
		else {
			this.render();
		}
	}
	
	
	
	async loadUserSettings() {
		let userId = $('#frmUser input[name=user_id]').val();
		
		let r = await postJson('/service/contracts/settings.do', {
			a: 'userSettings',
			userId: userId 
		});
		
		
		let json = await r.json();
		
		this.settings = json.settings;
		
		this.render();
	}
	
	async handleSaveUser( evt ) {
		
		if (!evt || !evt.response || !evt.response.user)
			return;
		
		let userId = evt.response.user.userId;
		
		postJson('/service/contracts/settings.do', {
			a: 'saveUserSettings',
			userId: userId,
			dailyAlerts: this.settings.dailyAlerts,
			weeklyUpdate: this.settings.weeklyUpdate
		});
		
	}
	
	
	
	render() {
		
		if ( $('.user-contract-settings').length > 0 )
			return;
		
		let frm = $('#frmUser');
		if (frm.length == null) return;
		
		let d = $('<div class="user-contract-settings" />');
		d.insertAfter( frm.find('ez-text[name=lastname]') );
		
		
		let eztpl = new EzTemplate( d );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('settings', this.settings);
		eztpl.render();
		
		
		$('.user-edit-contract-settings').get(0).userEditEvents = this;
	}
	
	
	dailyAlerts_Change(evt, obj) {
		this.settings.dailyAlerts = obj.querySelector('input[type=checkbox]').checked;
	}
	weeklyUpdate_Change(evt, obj) {
		this.settings.weeklyUpdate = obj.querySelector('input[type=checkbox]').checked;
	}
	
	
}

