


export class ContractTabWidget {
	
	
	
	tpl = `
	
	<div class="action-box">
		<span><a [onclick]="widget.addContract_Click">{{_('Add Contract')}}</a></span>
	</div>

	<table class="table table-contracts">
		<thead>
			<tr>
				<th>Contract</th>
				<th>Waarde</th>
				<th>Contract type</th>
				<th>Startdatum</th>
				<th>Einddatum</th>
				<th>Verlengdatum</th>
				<th>Status</th>
			</tr>
		</thead>
		<tbody ez-for="contracts" ez-item="c" id="tbody-contracts-tab">
			<tr [onclick]="widget.contract_Click" [c]="c" class="pointer"
				contract-id="{{c.contractId}}">
				<td>{{c.name}}</td>
				<td>{{c.amountDescription}}</td>
				<td>{{c.contractTypeName}}</td>
				<td>{{ c.startDate ? format_date(c.startDate, {dmy: true}) : '' }}</td>
				<td>{{ c.endDate ? format_date(c.endDate, {dmy: true}) : ''}}</td>
				<td>{{ c.renewalDate ? format_date(c.renewalDate, {dmy:true}) : ''}}</td>
				<td>{{_('contract_status.'+c.status)}}</td>
			</tr>
		</tbody>
		<tr ez-if="contracts.length == 0" id="rec-contracts">
			<td colspan="8" class="no-results">Geen resultaten gevonden</td>
		</tr>

	</table>
	`;
	
	container = null;
	customerId = null;
	
	loading = false;
	
	start = 0;
	lastResponse = null;
	
	contracts = [];
	
	constructor() {
		this.customerId = $('#frmCustomer input[name=customerId]').val();
		
	}
	
	
	render() {
		if (!this.customerId) {
			console.error('ContractTabWidget.render, customerId not set');
			return;
		}
		
		this.addTab();
		
		this.renderContent();
	}
	
	
	async loadData() {
		
		if (this.loading) return;
		
		this.loading = true;
		
		
		let r = await postJson('/service/contracts/list.do', {
			cid: this.customerId,
			start: this.start
		});
		
		let json = await r.json();
		
		
		// set next start pos
		this.start = json.start + json.pageSize;
		
		
		document.querySelector('button.nav-link#contracts-tab').innerText = _('Contracts') + ' (' + json.rowCount + ')';
		
		
		let tr_f = document.getElementById('rec-contracts');
		if (json.rowCount == 0) {
			tr_f.className = 'no-results-found';
			tr_f.querySelector('td').innerText = _('No results found');
			return;
		}
		else if (json.rowCount > this.start) {
			tr_f.querySelector('td').innerHTML = '';
			
			// Load more-text
			let anch = document.createElement('a');
			anch.className = 'load-more';
			anch.innerText = _('Load more...');
			anch.addEventListener('click', () => {
				this.loadData();
			});
			tr_f.querySelector('td').appendChild( anch );
		}
		else {
			tr_f.parentNode.removeChild( tr_f );
		}
		
		
		
		// add records
		let eztpl = document.querySelector('#tbody-contracts-tab').eztemplate;
		for(let i=0; i < json.contracts.length; i++) {
			let c = json.contracts[i];
			
			eztpl.createRecord( c );
		}
		
		
		// load-more
		
		
		
//		console.log(eztpl);
		
		this.loading = false;
		
	}
	
	
	
	
	addTab() {
		let li = document.createElement('li');
		li.className = 'nav-item';
		li.setAttribute('role', 'presentation');
		
		let btn = document.createElement('button');
		btn.className = 'nav-link';
		btn.setAttribute('id', 'contracts-tab');
		btn.setAttribute('data-bs-toggle', 'tab');
		btn.setAttribute('data-bs-target', '#customer-contracts');
		btn.setAttribute('type', 'button');
		btn.setAttribute('role', 'tab');
		btn.setAttribute('aria-controls', 'contracts-tab');
		btn.setAttribute('aria-selected', 'false');
		btn.innerText = _('Contracts');
		
		li.appendChild( btn );
		
		
		insertNodeAtPos( '#customerTabs > li', 1, li );
	}
	
	
	renderContent() {
		if (this.container == null) {
			let pane = document.createElement('div');
			pane.className = 'tab-pane fade';
			pane.setAttribute('id', 'customer-contracts');
			pane.setAttribute('role', 'tabpanel');
			pane.setAttribute('aria-labelledby', 'contracts-tab');
			document.getElementById('customerTabsContent').appendChild( pane );
			
			this.container = pane;
		}
		
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		
		eztpl.setVar('loading', this.loading);
		eztpl.setVar('contracts', this.contracts);
		
		eztpl.render();
		
		this.loadData();
	}
	
	
	contract_Click( evt, obj ) {
		let contract = obj.c;
		
		gotoRoute('/contracts/edit/?id='+contract.contractId);
	}
	
	
	
	addContract_Click() {
		gotoRoute('/contracts/edit/?ref_customerId='+this.customerId);
	}
	
	
	
}


