/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;

public class ProcUtil {
    protected static Boolean hasConsole = null;

    public static String execReturn(String ... cmds) throws IOException {
        Runtime r = Runtime.getRuntime();
        Process proc = r.exec(cmds);
        BufferedInputStream bis = new BufferedInputStream(proc.getInputStream());
        String s = new String(bis.readAllBytes());
        proc.destroy();
        return s.trim();
    }

    public static int execReturnInt(String ... cmds) throws IOException {
        Runtime r = Runtime.getRuntime();
        Process proc = r.exec(cmds);
        BufferedInputStream bis = new BufferedInputStream(proc.getInputStream());
        String s = new String(bis.readAllBytes());
        proc.destroy();
        return proc.exitValue();
    }

    public static void openUrlInBrowser(String url) throws IOException {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            String[] cmds = new String[]{"rundll32", "url.dll,FileProtocolHandler", url};
            Runtime rt = Runtime.getRuntime();
            rt.exec(cmds);
        } else if (os.contains("linux")) {
            String[] cmds = new String[]{"xdg-open", url};
            Runtime rt = Runtime.getRuntime();
            rt.exec(cmds);
        } else if (os.contains("mac")) {
            String[] cmds = new String[]{"open", url};
            Runtime rt = Runtime.getRuntime();
            rt.exec(cmds);
        } else {
            System.err.println("Error: ProcUtil.openUrlInBrowser(): failed to detect OS");
        }
    }

    public static boolean isMac() {
        String n = System.getProperty("os.name");
        return n != null && n.toLowerCase().contains("mac");
    }

    public static boolean isLinux() {
        String n = System.getProperty("os.name");
        return n != null && n.toLowerCase().contains("linux");
    }

    public static boolean isWindows() {
        String n = System.getProperty("os.name");
        return n != null && n.toLowerCase().contains("windows");
    }

    public static String getAppPath() {
        File f;
        String p = System.getProperty("jpackage.app-path");
        if (p != null) {
            if (ProcUtil.isMac() && (f = new File(p = p.replaceFirst("[^\\/]*?\\.app\\/Contents\\/MacOS\\/.*$", ""))).exists() && f.isDirectory()) {
                return f.getAbsolutePath();
            }
            f = new File(p);
            if (f.getParentFile().isDirectory()) {
                return f.getParent();
            }
        }
        if ((p = System.getProperty("sun.java.command")) != null && (f = new File(p)).getParentFile().isDirectory()) {
            return f.getParent();
        }
        p = System.getProperty("user.dir");
        if (p != null) {
            return p;
        }
        return null;
    }

    public static boolean hasConsole() {
        if (hasConsole == null) {
            hasConsole = System.console() != null;
        }
        return hasConsole;
    }

    public static void main(String[] args) {
        try {
            String s = "/Users/tratz/projects/jtoolbox/dist/Exact Data Exporter.app/Contents/MacOS/Exact Data Exporter";
            s = s.replaceFirst("[^\\/]*?\\.app\\/Contents\\/MacOS\\/.*$", "");
            System.out.println("app path: " + s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

