/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jtbcore.exception.InvalidStateException;

public class ChunkTransferUtil {
    public static void copyChunk(File f, OutputStream os) throws InvalidStateException, NumberFormatException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
            ChunkTransferUtil.copyChunk(bis, os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void copyChunk(InputStream is, OutputStream os) throws InvalidStateException, NumberFormatException, IOException {
        int chunklen = -1;
        Object chunklenOctets = "";
        int r = 0;
        byte b = 0;
        byte prevb = 0;
        while ((r = is.read()) > 0) {
            b = (byte)r;
            if (chunklen > 0) {
                --chunklen;
            }
            if (chunklen == -1) {
                if (b != 13 && b != 10) {
                    chunklenOctets = (String)chunklenOctets + b;
                }
                if (((String)chunklenOctets).length() > 10) {
                    throw new InvalidStateException("Invalid chunk size");
                }
                if (prevb == 13 && b == 10) {
                    chunklen = Integer.parseInt(((String)chunklenOctets).trim(), 8);
                    chunklenOctets = "";
                    if (chunklen == 0) {
                        os.write(r);
                        break;
                    }
                }
            }
            os.write(r);
            prevb = b;
            if (chunklen != 0) continue;
            chunklen = -1;
        }
        os.flush();
        os.close();
    }
}

