/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.model.mapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import jtbcore.exception.InvalidArgument;
import jtbcore.model.KeyValueList;
import jtbcore.model.validator.BaseValidator;
import jtbcore.util.ObjectUtil;
import jtbcore.util.StringUtil;

public class KeyValueListMapper {
    protected KeyValueList kvl;
    protected BaseValidator validator;
    protected Object obj;

    public KeyValueListMapper(KeyValueList kvl, BaseValidator validator, Object obj) {
        this.kvl = kvl;
        this.validator = validator;
        this.obj = obj;
    }

    public void map() throws IllegalAccessException, InvocationTargetException {
        List<String> fields = this.validator.getFields();
        for (String f : fields) {
            if (f.indexOf(46) != -1) continue;
            this.setValue(f, this.kvl.getValue(f));
        }
    }

    public void setValue(String fieldName, Object val) throws IllegalAccessException, InvocationTargetException {
        Method[] meths;
        String setter = "set" + StringUtil.camelify(fieldName);
        Method[] methodArray = meths = this.obj.getClass().getMethods();
        int n = meths.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(setter) && m.getParameterCount() == 1) {
                Parameter param = m.getParameters()[0];
                if (param.getType().equals(String.class)) {
                    m.invoke(this.obj, val.toString());
                } else if (param.getType().equals(Boolean.class)) {
                    try {
                        Boolean b = (Boolean)ObjectUtil.castStringToType(val.toString(), Boolean.class);
                        m.invoke(this.obj, b);
                    }
                    catch (InvalidArgument e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
    }
}

