/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.model.appconfig;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtbcore.model.BaseStringMap;
import jtbcore.util.NumberUtil;

public class GroupSetting {
    protected Integer id;
    protected String code;
    protected String description;
    protected Integer sort;
    protected Map<String, BaseStringMap> values = new HashMap<String, BaseStringMap>();

    public void setValues(List<BaseStringMap> values) {
        for (BaseStringMap bsm : values) {
            this.values.put(bsm.getProperty("key"), bsm);
        }
    }

    public void setValue(String key, String value) {
        BaseStringMap m;
        if (this.values.containsKey(key)) {
            m = this.values.get(key);
        } else {
            m = new BaseStringMap();
            m.setProperty("key", key);
        }
        m.setProperty("value", value);
        this.values.put(key, m);
    }

    public void setValue(String key, Integer value) {
        this.setValue(key, value == null ? null : value.toString());
    }

    public String getValue(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key).getProperty("value");
        }
        return null;
    }

    public Integer getValueInt(String key) {
        return NumberUtil.tryParseInt(this.getValue(key));
    }

    public Map<String, BaseStringMap> getValues() {
        return this.values;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }
}

