/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.jobs.handler;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import jtbcore.jobs.TaskBase;
import jtbcore.jobs.TaskUpdate;

public class QueuedTask {
    protected Queue<TaskBase> queue = new ConcurrentLinkedQueue<TaskBase>();
    protected Thread cur = null;
    protected TaskBase currentTask = null;
    protected Long startTime = null;
    protected String queueName;

    public QueuedTask(String queueName) {
        this.queueName = queueName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(TaskBase task) {
        this.queue.removeIf(t2 -> t2 == task);
        if (this.currentTask != null) {
            TaskBase taskBase = this.currentTask;
            synchronized (taskBase) {
                if (this.currentTask != null && this.currentTask == task && this.cur != null) {
                    this.cur.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Integer taskId) {
        this.queue.removeIf(t2 -> t2.getId() == taskId);
        TaskBase taskBase = this.currentTask;
        synchronized (taskBase) {
            if (this.currentTask != null && this.currentTask.getId() == taskId && this.cur != null) {
                this.cur.interrupt();
            }
        }
    }

    public boolean isRunning() {
        return this.cur != null && this.cur.isAlive();
    }

    public void interrupt() {
        if (this.cur != null && this.cur.isAlive()) {
            this.cur.interrupt();
        }
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getDuration() {
        if (this.startTime == null) {
            return -1L;
        }
        if (this.cur != null && this.cur.isAlive()) {
            return System.currentTimeMillis() - this.startTime;
        }
        return -1L;
    }

    public void halt() {
        this.queue.clear();
        this.interrupt();
    }

    protected synchronized void checkQueue() {
        boolean startThread = false;
        if (this.cur == null) {
            startThread = true;
        } else if (!this.cur.isAlive()) {
            startThread = true;
        } else if (this.cur.isAlive() && this.cur.equals(Thread.currentThread())) {
            startThread = true;
        }
        if (startThread) {
            TaskBase task;
            this.currentTask = task = this.queue.poll();
            if (task != null) {
                this.cur = new Thread(() -> {
                    block16: {
                        try {
                            try {
                                task.update("start", TaskUpdate.MessageType.STARTED, 0, 0.0);
                                task.execute();
                                if (!this.cur.isInterrupted()) {
                                    task.update("finished", TaskUpdate.MessageType.FINISHED, 0, 100.0);
                                }
                            }
                            catch (Exception ex) {
                                if (!task.handleException(ex)) {
                                    ex.printStackTrace();
                                }
                                TaskBase taskBase2 = this.currentTask;
                                synchronized (taskBase2) {
                                    this.currentTask = null;
                                }
                                this.checkQueue();
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            TaskBase taskBase3 = this.currentTask;
                            synchronized (taskBase3) {
                                this.currentTask = null;
                            }
                            this.checkQueue();
                            throw throwable;
                        }
                        TaskBase taskBase4 = this.currentTask;
                        synchronized (taskBase4) {
                            this.currentTask = null;
                        }
                        this.checkQueue();
                    }
                });
                this.startTime = System.currentTimeMillis();
                this.cur.start();
            }
        }
    }

    public void queue(TaskBase task) {
        this.queue.add(task);
        this.checkQueue();
    }
}

