/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.export;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelExporter {
    public String path;
    protected String message;
    protected Integer rowsExported = null;
    protected Integer columnsExported = null;
    protected Integer maxRows = 1000000;
    protected Integer maxColumns = 200;
    protected Workbook workbook = null;
    protected Sheet sheet = null;
    protected int rowNo = 0;
    protected CellStyle cellStyleYmd = null;

    public ExcelExporter(String path) {
        this.setPath(path);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        String lp = ((String)path).toLowerCase();
        if (!lp.endsWith(".xls") && !lp.endsWith(".xlsx")) {
            path = (String)path + ".xlsx";
        }
        this.path = path;
    }

    public Integer getRowsExported() {
        return this.rowsExported;
    }

    public Integer getColumnsExported() {
        return this.columnsExported;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public Integer getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxColumns(Integer maxColumns) {
        this.maxColumns = maxColumns;
    }

    public void init() {
        if (this.workbook != null) {
            return;
        }
        this.workbook = new XSSFWorkbook();
        this.sheet = this.workbook.createSheet();
    }

    public CellStyle getCellStyleYmd() {
        if (this.cellStyleYmd == null) {
            short fi = this.workbook.getCreationHelper().createDataFormat().getFormat("dd-MM-yyyy");
            this.cellStyleYmd = this.workbook.createCellStyle();
            this.cellStyleYmd.setDataFormat(fi);
        }
        return this.cellStyleYmd;
    }

    public void writeHeader(List<String> cols) {
        this.writeRow(cols.toArray());
    }

    public void writeHeader(String[] cols) {
        this.writeRow(cols);
    }

    public void writeRow(List<Object> cols) {
        this.writeRow(cols.toArray());
    }

    public void writeRow(Object[] cols) {
        if (this.workbook == null) {
            this.init();
        }
        Row row = this.sheet.createRow(this.rowNo++);
        int colCount = cols.length;
        if (this.maxColumns != -1 && colCount > this.maxColumns) {
            colCount = this.maxColumns;
        }
        this.columnsExported = colCount;
        int x = 0;
        while (x < colCount) {
            Object col = cols[x];
            if (col != null) {
                Cell cell = row.createCell(x);
                if (col instanceof Double) {
                    cell.setCellValue(((Double)col).doubleValue());
                } else if (col instanceof Boolean) {
                    cell.setCellValue(((Boolean)col).booleanValue());
                } else if (col instanceof Date) {
                    cell.setCellValue((Date)col);
                    CellStyle s = this.getCellStyleYmd();
                    cell.setCellStyle(s);
                } else if (col instanceof Calendar) {
                    cell.setCellValue((Calendar)col);
                } else {
                    cell.setCellValue(col.toString());
                }
            }
            ++x;
        }
    }

    public void closeFile() throws IOException {
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.getPath()));
        this.workbook.write((OutputStream)fos);
        ((OutputStream)fos).close();
        this.workbook.close();
    }

    public void export(ResultSet rs) throws Exception {
        Cell cell;
        XSSFWorkbook wb = new XSSFWorkbook();
        Sheet sheet = wb.createSheet();
        int rowNo = 0;
        Row row = sheet.createRow(rowNo++);
        int colCount = rs.getMetaData().getColumnCount();
        if (this.maxColumns != -1 && colCount > this.maxColumns) {
            colCount = this.maxColumns;
        }
        this.columnsExported = colCount;
        int x = 1;
        while (x <= colCount) {
            String colName = rs.getMetaData().getColumnName(x);
            cell = row.createCell(x - 1);
            cell.setCellValue(colName);
            ++x;
        }
        while (rs.next()) {
            row = sheet.createRow(rowNo++);
            x = 1;
            while (x <= colCount) {
                String colVal = rs.getString(x);
                if (colVal == null) {
                    colVal = "null";
                }
                cell = row.createCell(x - 1);
                cell.setCellValue(colVal);
                ++x;
            }
            if (this.maxRows == -1 || rowNo <= this.maxRows) continue;
            this.message = "Max rows reached";
            break;
        }
        this.rowsExported = rowNo - 1;
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.getPath()));
        wb.write((OutputStream)fos);
        ((OutputStream)fos).close();
        wb.close();
    }

    public static void main(String[] args) {
    }
}

