/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.export;

import java.io.File;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CsvExporter {
    public String path;
    protected String message;
    protected Integer rowsExported = null;
    protected Integer columnsExported = null;
    protected Integer maxRows = -1;
    protected Integer maxColumns = -1;
    protected char delimiter = (char)44;

    public CsvExporter(String path) {
        this.setPath(path);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        String lp = ((String)path).toLowerCase();
        if (!lp.endsWith(".csv")) {
            path = (String)path + ".csv";
        }
        this.path = path;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiter(String del) {
        if (del.length() > 0) {
            this.delimiter = del.charAt(0);
        }
    }

    public Integer getRowsExported() {
        return this.rowsExported;
    }

    public Integer getColumnsExported() {
        return this.columnsExported;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public Integer getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxColumns(Integer maxColumns) {
        this.maxColumns = maxColumns;
    }

    public void export(ResultSet rs) throws Exception {
        CSVFormat.Builder csvBuilder = CSVFormat.DEFAULT.builder();
        csvBuilder.setDelimiter(this.delimiter);
        CSVFormat f = csvBuilder.build();
        PrintWriter pw = new PrintWriter(new File(this.path));
        CSVPrinter printer = new CSVPrinter((Appendable)pw, f);
        ArrayList<String> rec = new ArrayList<String>();
        int rowNo = 0;
        int colCount = rs.getMetaData().getColumnCount();
        if (this.maxColumns != -1 && colCount > this.maxColumns) {
            colCount = this.maxColumns;
        }
        this.columnsExported = colCount;
        int x = 1;
        while (x <= colCount) {
            String colName = rs.getMetaData().getColumnName(x);
            rec.add(colName);
            ++x;
        }
        ++rowNo;
        printer.printRecord(rec.toArray());
        while (rs.next()) {
            rec.clear();
            x = 1;
            while (x <= colCount) {
                String colVal = rs.getString(x);
                if (colVal == null) {
                    colVal = "null";
                }
                rec.add(colVal);
                ++x;
            }
            printer.printRecord(rec.toArray());
            if (this.maxRows == -1 || ++rowNo <= this.maxRows) continue;
            this.message = "Max rows reached";
            break;
        }
        this.rowsExported = rowNo - 1;
        printer.close();
        pw.close();
    }

    public static void main(String[] args) {
    }
}

