/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.webmail.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import itx.erp.ErpObjectContainer;
import itx.erp.base.service.ErpServiceBase;
import itx.erp.customer.model.Customer;
import itx.erp.customer.service.CustomerService;
import itx.erp.exception.ObjectNotFoundException;
import itx.erp.webmail.conf.EmailSettings;
import itx.erp.webmail.model.EmailFile;
import itx.erp.webmail.model.EmailMessage;
import itx.erp.webmail.model.EmailSearchResult;
import itx.erp.webmail.model.EmailTo;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.ContainerException;
import jtbcore.exception.FileException;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.exception.RemoteApiException;
import jtbcore.model.KeyValueList;
import jtbcore.util.MapUtil;
import jtbcore.util.RequestUrl;
import org.apache.commons.validator.EmailValidator;

public class EmailService
extends ErpServiceBase {
    protected EmailSettings emailSettings;
    protected CustomerService customerService;

    public EmailSettings getEmailSettings() {
        return this.emailSettings;
    }

    public void setEmailSettings(EmailSettings emailSettings) {
        this.emailSettings = emailSettings;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public ErpObjectContainer getObjectContainer() {
        return ErpObjectContainer.getInstance();
    }

    public void sendMail(EmailMessage e) throws IOException, SQLException, JTBException, MessagingException, RemoteApiException {
        if (!e.hasValidTo()) {
            throw new InvalidStateException("No destination email address");
        }
        this.sendMail(e, this.emailSettings);
    }

    public void sendMail(EmailMessage e, EmailSettings settings) throws IOException, SQLException, JTBException, MessagingException, RemoteApiException {
        e.setIncoming(false);
        Integer emId = this.saveEmail(e);
        if (settings.getSendMethod().equals("smtp")) {
            this.sendSmtp(e, settings);
        } else if (settings.getSendMethod().equals("r2bmailserver")) {
            this.sendR2bMailserver(e, settings);
        } else {
            throw new InvalidStateException("Invalid sendMethod: " + settings.getSendMethod());
        }
    }

    public void sendSmtp(EmailMessage e, EmailSettings settings) throws IOException, SQLException, JTBException, MessagingException {
        Properties props = new Properties();
        props.put("mail.smtp.host", settings.getSmtpHost());
        props.put("mail.smtp.timeout", (Object)5000);
        props.put("mail.smtp.connectiontimeout", (Object)5000);
        Authenticator mailAuth = null;
        if (settings.hasAuthentication()) {
            final String smtpUsername = settings.getSmtpUsername();
            final String smtpPassword = settings.getSmtpPassword();
            props.put("mail.smtp.auth", "true");
            mailAuth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(smtpUsername, smtpPassword);
                }
            };
        }
        if (settings.getSmtpTls().booleanValue()) {
            props.put("mail.smtp.starttls.enable", "true");
        }
        if (settings.getSmtpPort() != null && settings.getSmtpPort() > 0) {
            props.put("mail.smtp.port", settings.getSmtpPort());
        } else {
            props.put("mail.smtp.port", "25");
        }
        Session ses = null;
        ses = mailAuth != null ? Session.getInstance((Properties)props, (Authenticator)mailAuth) : Session.getInstance((Properties)props);
        MimeMultipart multipart = new MimeMultipart();
        MimeMessage msg = new MimeMessage(ses);
        msg.setFrom((Address)new InternetAddress(e.getFromEmail(), e.getFromName()));
        msg.setSubject(e.getSubject());
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)e.getTextContent(), "text/html");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        msg.setSentDate(new Date());
        msg.setRecipients(Message.RecipientType.TO, e.getToAddresses());
        int x = 0;
        while (x < e.getFiles().size()) {
            EmailFile f = e.getFiles().get(x);
            MimeBodyPart p = new MimeBodyPart();
            String filepath = this.getObjectContainer().getDataDir() + "/" + f.getPath();
            p.attachFile(filepath);
            p.setFileName(f.getFilename());
            multipart.addBodyPart((BodyPart)p);
            ++x;
        }
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
        this.updateStatusEmailMessage(e.getEmailMessageId(), "sent");
    }

    public void sendR2bMailserver(EmailMessage e, EmailSettings settings) throws FileException, InvalidStateException, SQLException, RemoteApiException, ContainerException, IOException {
        HashMap<String, Object> map_mail = new HashMap<String, Object>();
        map_mail.put("fromName", e.getFromName());
        map_mail.put("fromEmail", e.getFromEmail());
        map_mail.put("subject", e.getSubject());
        map_mail.put("html", e.getTextContent());
        map_mail.put("tos", e.getTos());
        ObjectMapper m = new ObjectMapper();
        String json_mail = m.writeValueAsString(map_mail);
        RequestUrl u = new RequestUrl("https://www.report2base.nl/api/r2bmail");
        u.setRequestParam("json_mail", json_mail);
        u.setRequestParam("licenseCode", this.getObjectContainer().getAppConfig().getLicenseCode());
        u.setRequestParam("appUid", this.getObjectContainer().getAppConfig().getAppUid());
        Long appInitTime = this.getObjectContainer().getAppConfig().getAppInitTime();
        u.setRequestParam("appInitTime", appInitTime != null ? appInitTime.toString() : "0");
        for (EmailFile f : e.getFiles()) {
            File path = new File(this.getObjectContainer().getDataDir() + "/" + f.getPath());
            if (!path.exists()) continue;
            u.setRequestFile("file-" + String.valueOf(f.getEmailFileId()), path);
        }
        u.postMultipart();
        KeyValueList kvl = KeyValueList.fromJson(u.getResponseData());
        if (!kvl.getValueBool("success")) {
            throw new RemoteApiException("Error sending email: " + kvl.getValue("message"));
        }
        this.updateStatusEmailMessage(e.getEmailMessageId(), "sent");
    }

    public EmailMessage readEmail(Integer emailMessageId) throws SQLException, JTBException {
        EmailMessage m = (EmailMessage)this.queryToObject(EmailMessage.class, "select * from webmail__email_message where email_message_id = ?", emailMessageId);
        if (m == null) {
            throw new ObjectNotFoundException("Email not found");
        }
        List tos = this.queryToList(EmailTo.class, "select * from webmail__email_to where email_message_id = ?", emailMessageId);
        List files = this.queryToList(EmailFile.class, "select * from webmail__email_file where email_message_id = ?", emailMessageId);
        m.setTos(tos);
        m.setFiles(files);
        if (m.getCustomerId() != null) {
            Customer c = this.customerService.readCustomer(m.getCustomerId());
            m.setCustomerName(c.getCustomerName());
        }
        return m;
    }

    public Integer saveEmail(EmailMessage e) throws IOException, SQLException, JTBException {
        if (e.getFromEmail() == null || !EmailValidator.getInstance().isValid(e.getFromEmail())) {
            e.setFromEmail("info@test.report2base.nl");
        }
        if (e.getFromName() == null || e.getFromName().trim().length() == 0) {
            e.setFromName("Toolbox");
        }
        EmailMessage oldEm = null;
        if (e.getEmailMessageId() != null) {
            oldEm = this.readEmail(e.getEmailMessageId());
        }
        Integer id = this.connection.save("webmail__email_message", "email_message_id", e.getBaseStringMap());
        e.setEmailMessageId(id);
        ArrayList oldTos = oldEm != null ? oldEm.getTos() : new ArrayList();
        List<EmailTo> tos = e.getTos();
        int x = 0;
        while (x < tos.size()) {
            EmailTo et = tos.get(x);
            et.setEmailMessageId(id);
            if (x < oldTos.size()) {
                et.setEmailToId(((EmailTo)oldTos.get(x)).getEmailToId());
            }
            Integer toid = this.connection.save("webmail__email_to", "email_to_id", et.getBaseStringMap());
            et.setEmailToId(toid);
            ++x;
        }
        while (x < oldTos.size()) {
            this.connection.query("delete from webmail__email_to where email_to_id = ?", ((EmailTo)oldTos.get(x)).getEmailToId());
            ++x;
        }
        ArrayList oldFiles = oldEm != null ? oldEm.getFiles() : new ArrayList();
        List<EmailFile> files = e.getFiles();
        x = 0;
        while (x < files.size()) {
            EmailFile ef = files.get(x);
            ef.setEmailMessageId(id);
            if (x < oldFiles.size()) {
                ef.setEmailFileId(((EmailFile)oldFiles.get(x)).getEmailFileId());
            }
            Integer fid = this.connection.save("webmail__email_file", "email_file_id", ef.getBaseStringMap());
            ef.setEmailFileId(fid);
            ++x;
        }
        while (x < oldFiles.size()) {
            this.connection.query("delete from webmail__email_file where email_file_id = ?", ((EmailFile)oldFiles.get(x)).getEmailFileId());
            ++x;
        }
        return e.getEmailMessageId();
    }

    public void deleteFile(Integer fileId) throws SQLException, JTBException {
        EmailFile ef = this.readFile(fileId);
        String p = this.getObjectContainer().getDataDir() + "/" + ef.getPath();
        File f = new File(p);
        f.delete();
        this.connection.query("delete from webmail__email_file where email_file_id = ?", ef.getEmailFileId());
    }

    public EmailFile readFile(Integer fileId) throws SQLException, JTBException {
        EmailFile f = (EmailFile)this.queryToObject(EmailFile.class, "select * from webmail__email_file where email_file_id = ?", fileId);
        return f;
    }

    public Integer saveFile(EmailFile f) throws IOException, SQLException, JTBException {
        Integer id = this.connection.save("webmail__email_file", "email_file_id", f.getBaseStringMap());
        f.setEmailFileId(id);
        return id;
    }

    public void updateStatusEmailMessage(Integer emailMessageId, String status) throws InvalidStateException, SQLException {
        if (!"draft".equals(status) && !"sent".equals(status)) {
            throw new InvalidStateException("Invalid status");
        }
        this.connection.query("update webmail__email_message set status = ? where email_message_id = ?", status, emailMessageId);
    }

    public void deleteEmail(Integer emailId) throws SQLException, JTBException {
        EmailMessage m = this.readEmail(emailId);
        for (EmailFile ef : m.getFiles()) {
            File path = new File(this.getObjectContainer().getDataDir() + "/" + ef.getPath());
            if (!path.exists() || !path.isFile()) continue;
            path.delete();
        }
        this.connection.query("delete from webmail__email_message where email_message_id = ?", emailId);
        this.connection.query("delete from webmail__email_to where email_message_id = ?", emailId);
        this.connection.query("delete from webmail__email_file where email_message_id = ?", emailId);
    }

    public QueryResult<EmailSearchResult> searchEmail(Map<String, Object> opts) throws SQLException, JTBException {
        Integer pageSize;
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("webmail__email_message");
        b.addSelectField("webmail__email_message", "email_message_id");
        b.addSelectField("webmail__email_message", "customer_id");
        b.addSelectField("webmail__email_message", "subject");
        b.addSelectField("webmail__email_message", "status");
        b.addSelectField("webmail__email_message", "created");
        b.addSelectField("customer__customer", "customer_name");
        b.addLeftJoin("customer__customer", "customer__customer.customer_id = webmail__email_message.customer_id");
        b.setWhereJoin("OR");
        if (MapUtil.hasProperty(opts, "q")) {
            String q = opts.get("q").toString().trim();
            b.addWhere("customer__customer.customer_name like ? ", "%" + q + "%");
            b.addWhere("webmail__email_message.subject like ? ", "%" + q + "%");
            b.addWhere("email_message_id in ( select email_message_id from webmail__email_to t where concat_ws(' ', t.to_name, t.to_email) like ?)", "%" + q + "%");
        }
        b.setRawOrderBy("webmail__email_message.email_message_id desc");
        ResultSet rs = b.queryResultSet();
        Integer start = (Integer)opts.get("start");
        if (start == null) {
            start = 0;
        }
        if ((pageSize = (Integer)opts.get("pageSize")) == null) {
            pageSize = 15;
        }
        EmailService.moveTo(rs, start);
        ArrayList<EmailSearchResult> resultList = new ArrayList<EmailSearchResult>();
        int x = 0;
        while (x < pageSize && rs.next()) {
            EmailSearchResult r = new EmailSearchResult();
            r.emailMessageId = rs.getInt("email_message_id");
            r.customerId = rs.getInt("customer_id");
            r.customerName = rs.getString("customer_name");
            r.subject = rs.getString("subject");
            r.status = rs.getString("status");
            r.created = rs.getDate("created");
            EmailTo et = (EmailTo)this.queryToObject(EmailTo.class, "select * from webmail__email_to where email_message_id = ? order by email_to_id limit 1", r.emailMessageId);
            if (et != null) {
                r.toName = et.getToName();
                r.toEmail = et.getToEmail();
            }
            resultList.add(r);
            ++x;
        }
        Integer rowCount = EmailService.rowCount(rs);
        rs.close();
        QueryResult<EmailSearchResult> qr = new QueryResult<EmailSearchResult>();
        qr.setPageSize(pageSize);
        qr.setStart(start);
        qr.setRowCount(rowCount);
        qr.setObjects(resultList);
        return qr;
    }
}

