/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.rental.model;

import itx.erp.sales.model.Vat;
import java.util.Date;
import jtbcore.exception.InvalidStateException;
import jtbcore.model.BaseStringMap;
import jtbcore.model.BaseStringMapObject;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;

public class RentalContractLine
implements BaseStringMapObject {
    protected BaseStringMap bsm = new BaseStringMap();

    public RentalContractLine() throws InvalidStateException {
        this.setAmount(1.0);
        this.setRentalType("day");
    }

    public Integer getRentalContractLineId() {
        return this.bsm.getPropertyInt("rental_contract_line_id");
    }

    public void setRentalContractLineId(Integer p) {
        this.bsm.setProperty("rental_contract_line_id", p);
    }

    public Integer getRentalContractId() {
        return this.bsm.getPropertyInt("rental_contract_id");
    }

    public void setRentalContractId(Integer p) {
        this.bsm.setProperty("rental_contract_id", p);
    }

    public Integer getArticleId() {
        return this.bsm.getPropertyInt("article_id");
    }

    public void setArticleId(Integer p) {
        this.bsm.setProperty("article_id", p);
    }

    public String getLineType() {
        return this.bsm.getProperty("line_type");
    }

    public void setLineType(String p) {
        this.bsm.setProperty("line_type", p);
    }

    public String getRentalType() {
        String rt = this.bsm.getProperty("rental_type");
        if (rt == null) {
            rt = "day";
        }
        return rt;
    }

    public void setRentalType(String p) throws InvalidStateException {
        if (!"day".equals(p) && !"hour".equals(p)) {
            throw new InvalidStateException("Invalid rentalType, " + p);
        }
        this.bsm.setProperty("rental_type", p);
    }

    public String getDescription() {
        return this.bsm.getProperty("description");
    }

    public void setDescription(String p) {
        this.bsm.setProperty("description", p);
    }

    public Date getStartTime() {
        return this.bsm.getPropertyDateTime("start_time");
    }

    public void setStartTime(Date p) {
        this.bsm.setProperty("start_time", p);
    }

    public void setStartTime(String t) {
        Date d = null;
        d = "hour".equals(this.getRentalType()) ? DateUtil.string2datetime(t) : DateUtil.string2date(t);
        this.setStartTime(d);
    }

    public Date getEndTime() {
        return this.bsm.getPropertyDateTime("end_time");
    }

    public void setEndTime(Date p) {
        this.bsm.setProperty("end_time", p);
    }

    public void setEndTime(String t) {
        Date d = null;
        d = "hour".equals(this.getRentalType()) ? DateUtil.string2datetime(t) : DateUtil.string2date(t);
        this.setEndTime(d);
    }

    public Integer getTimeNotice() {
        Integer n = this.bsm.getPropertyInt("time_notice");
        if (n == null) {
            n = 0;
        }
        return n;
    }

    public void setTimeNotice(Integer p) {
        this.bsm.setProperty("time_notice", p);
    }

    public String getTimeNoticeUnit() {
        return this.bsm.getProperty("time_notice_unit");
    }

    public void setTimeNoticeUnit(String p) {
        this.bsm.setProperty("time_notice_unit", p);
    }

    public Integer getRenewalPeriod() {
        return this.bsm.getPropertyInt("renewal_period");
    }

    public void setRenewalPeriod(Integer p) {
        this.bsm.setProperty("renewal_period", p);
    }

    public String getRenewalType() {
        return this.bsm.getProperty("renewal_type");
    }

    public void setRenewalType(String p) {
        this.bsm.setProperty("renewal_type", p);
    }

    public Integer getVatId() {
        return this.bsm.getPropertyInt("vat_id");
    }

    public void setVatId(Integer p) {
        this.bsm.setProperty("vat_id", p);
    }

    public Double getAmount() {
        return this.bsm.getPropertyDouble("amount");
    }

    public void setAmount(Double d) {
        if (d != null) {
            NumberUtil.roundPrice(d);
        }
        this.bsm.setProperty("amount", d);
    }

    public Double getPriceExclVat() {
        return this.bsm.getPropertyDouble("price_excl_vat");
    }

    public void setPriceExclVat(Double p) {
        this.bsm.setProperty("price_excl_vat", p);
    }

    public Double getPriceInclVat() {
        return this.bsm.getPropertyDouble("price_incl_vat");
    }

    public void setPriceInclVat(Double p) {
        this.bsm.setProperty("price_incl_vat", p);
    }

    public void calcAmountExcl(Vat vat) {
        Double vatp = vat != null ? vat.getPercentage() : 0.0;
        Double v = NumberUtil.roundPrice(this.getPriceInclVat() * 100.0 / (100.0 + vatp));
        this.setPriceExclVat(v);
    }

    public void calcAmountIncl(Vat vat) {
        Double vatp = vat != null ? vat.getPercentage() : 0.0;
        Double v = NumberUtil.roundPrice(this.getPriceExclVat() * vatp / 100.0);
        this.setPriceInclVat(this.getPriceExclVat() + v);
    }

    public Integer getSort() {
        return this.bsm.getPropertyInt("sort");
    }

    public void setSort(Integer p) {
        this.bsm.setProperty("sort", p);
    }

    public Date getRenewalDate() {
        Date renewalDate = this.getEndTime();
        if (renewalDate == null) {
            return null;
        }
        Integer timeNotice = this.getTimeNotice();
        String noticeUnit = this.getTimeNoticeUnit();
        if (timeNotice > 0) {
            if ("week".equals(noticeUnit)) {
                renewalDate = DateUtil.previousWeek(renewalDate, timeNotice);
            } else if ("month".equals(noticeUnit)) {
                renewalDate = DateUtil.previousMonth(renewalDate, timeNotice);
            }
        }
        return renewalDate;
    }

    public String getCustomerName() {
        return this.bsm.getProperty("customer_name");
    }

    @Override
    public BaseStringMap getBaseStringMap() {
        return this.bsm;
    }

    @Override
    public void setBaseStringMap(BaseStringMap bsm) {
        this.bsm = bsm;
    }
}

