/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.rental.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.helper.ErpConfig;
import itx.erp.sales.conf.SalesSettings;
import itx.erp.sales.model.Article;
import itx.erp.sales.model.Slotplan;
import itx.erp.sales.rental.service.RentalService;
import itx.erp.sales.service.SlotService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;

public class RentalArticleSearchController
extends BaseController {
    protected ErpConfig appConfig;
    protected SalesSettings salesSettings;
    protected RentalService rentalService;
    protected SlotService slotService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public SalesSettings getSalesSettings() {
        return this.salesSettings;
    }

    public void setSalesSettings(SalesSettings salesSettings) {
        this.salesSettings = salesSettings;
    }

    public RentalService getRentalService() {
        return this.rentalService;
    }

    public void setRentalService(RentalService rentalService) {
        this.rentalService = rentalService;
    }

    public SlotService getSlotService() {
        return this.slotService;
    }

    public void setSlotService(SlotService slotService) {
        this.slotService = slotService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, JTBException {
        Integer pageNo = req.getParamInt("pageNo", 0);
        Integer pageSize = req.getParamInt("pageSize", null);
        if (pageSize == null) {
            pageSize = this.appConfig.getLimit();
        }
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * this.appConfig.getLimit());
        opts.put("pageSize", pageSize);
        opts.put("q", req.getParameter("q"));
        opts.put("customerId", req.getParameter("customerId"));
        opts.put("occupation", req.getParamBool("occupation"));
        opts.put("startOccupation", req.getParameter("startOccupation"));
        opts.put("endOccupation", req.getParameter("endOccupation"));
        QueryResult<Article> qrs = this.rentalService.searchArticle(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("articles", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        result.put("salesSettings", this.getSalesSettings());
        req.renderJson(result);
    }

    public void slotplanViewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer slotplanId = req.getParamInt("slotplanId");
        Slotplan sp = this.slotService.readSlotplan(slotplanId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("slotplan", sp);
        req.renderJson(result);
    }
}

