/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.helper.ErpConfig;
import itx.erp.sales.model.ArticleGroup;
import itx.erp.sales.service.ArticleService;
import itx.erp.sales.validator.ArticleGroupValidator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;
import jtbcore.util.NumberUtil;

public class ArticleGroupController
extends BaseController {
    protected ErpConfig appConfig;
    protected ArticleService articleService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public ArticleService getArticleService() {
        return this.articleService;
    }

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        this.searchAction(req);
    }

    public void searchAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        List<ArticleGroup> groups = this.articleService.readArticleGroups();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("groups", groups);
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer articleGroupId = req.getParamInt("articleGroupId");
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        this.articleService.deleteArticleGroup(articleGroupId);
        result.put("success", true);
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer articleGroupId = req.getParamInt("articleGroupId");
        ArticleGroup g = this.articleService.readArticleGroup(articleGroupId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("articleGroup", g);
        result.put("success", true);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer articleGroupId = req.getParamInt("articleGroupId");
        ArticleGroup articleGroup = articleGroupId != null ? this.articleService.readArticleGroup(articleGroupId) : new ArticleGroup();
        articleGroup.setGroupName(req.getParameter("groupName"));
        articleGroup.setActive(req.getParamBool("active"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArticleGroupValidator v = new ArticleGroupValidator();
        if (v.validate(articleGroup)) {
            articleGroupId = this.articleService.saveArticleGroup(articleGroup);
            result.put("articleGroupId", articleGroupId);
            result.put("success", true);
        } else {
            result.put("error", true);
            result.put("errors", v.getErrors());
        }
        req.renderJson(result);
    }

    public void updateSortAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        String strids = req.getParameter("ids");
        List<Integer> ids = NumberUtil.csl2int(strids);
        this.articleService.updateArticleGroupSort(ids);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

