/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.customer.model;

import itx.erp.customer.model.Address;
import itx.erp.customer.model.Email;
import itx.erp.customer.model.Phone;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtbcore.model.BaseStringMap;
import jtbcore.model.BaseStringMapObject;
import jtbcore.util.DateUtil;
import org.apache.http.annotation.Contract;

public class Customer
implements BaseStringMapObject {
    protected BaseStringMap bsm;
    protected List<Address> addresses;
    protected List<Phone> phones;
    protected List<Email> emails;
    protected List<Contract> contracts;
    protected Map<String, Object> mymap = new HashMap<String, Object>();

    public Map<String, Object> getMymap() {
        return this.mymap;
    }

    public void setMymap(Map<String, Object> mymap) {
        this.mymap = mymap;
    }

    public Customer() {
        this.bsm = new BaseStringMap();
    }

    public Integer getCustomerId() {
        return this.bsm.getPropertyInt("customer_id");
    }

    public void setCustomerId(Integer i) {
        this.bsm.setProperty("customer_id", i);
    }

    public String getCustomerType() {
        return this.bsm.getProperty("customer_type");
    }

    public void setCustomerType(String p) {
        this.bsm.setProperty("customer_type", p);
    }

    public String getCustomerTypeText() {
        String ct = this.getCustomerType();
        if ("personal".equals(ct)) {
            return "Particulier";
        }
        if ("business".equals(ct)) {
            return "Zakelijk";
        }
        return ct;
    }

    public String getCustomerName() {
        return this.bsm.getProperty("customer_name");
    }

    public void setCustomerName(String p) {
        this.bsm.setProperty("customer_name", p);
    }

    public String getContactPerson() {
        return this.bsm.getProperty("contact_person");
    }

    public void setContactPerson(String p) {
        this.bsm.setProperty("contact_person", p);
    }

    public Date getBirthDate() {
        return this.bsm.getPropertyDate("birth_date");
    }

    public void setBirthDate(Date d) {
        this.bsm.setProperty("birth_date", d);
    }

    public String getCocNumber() {
        return this.bsm.getProperty("coc_number");
    }

    public void setCocNumber(String p) {
        this.bsm.setProperty("coc_number", p);
    }

    public String getVatNumber() {
        return this.bsm.getProperty("vat_number");
    }

    public void setVatNumber(String p) {
        this.bsm.setProperty("vat_number", p);
    }

    public String getIban() {
        return this.bsm.getProperty("iban");
    }

    public void setIban(String p) {
        this.bsm.setProperty("iban", p);
    }

    public String getBic() {
        return this.bsm.getProperty("bic");
    }

    public void setBic(String p) {
        this.bsm.setProperty("bic", p);
    }

    public String getNote() {
        return this.bsm.getProperty("note");
    }

    public void setNote(String p) {
        this.bsm.setProperty("note", p);
    }

    public Date getEdited() {
        return this.bsm.getPropertyDateTime("edited");
    }

    public void setEdited(Date d) {
        this.bsm.setProperty("edited", DateUtil.datetime2string(d));
    }

    public Date getCreated() {
        return this.bsm.getPropertyDateTime("created");
    }

    public void setCreated(Date d) {
        this.bsm.setProperty("created", DateUtil.datetime2string(d));
    }

    public Integer getId() {
        return this.getCustomerId();
    }

    public String getDefaultText() {
        return this.getCustomerName();
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public List<Phone> getPhones() {
        return this.phones;
    }

    public void setPhones(List<Phone> phones) {
        this.phones = phones;
    }

    public List<Email> getEmails() {
        return this.emails;
    }

    public void setEmails(List<Email> emails) {
        this.emails = emails;
    }

    @Override
    public BaseStringMap getBaseStringMap() {
        return this.bsm;
    }

    @Override
    public void setBaseStringMap(BaseStringMap bsm) {
        this.bsm = bsm;
    }
}

