/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.contracts.task;

import itx.contracts.ContractsObjectContainer;
import itx.erp.contracts.model.Contract;
import itx.erp.contracts.service.ContractService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;

public class ContractRenewalTask
implements Runnable {
    protected ContractService contractService;

    public ContractService getContractService() {
        return this.contractService;
    }

    public void setContractService(ContractService contractService) {
        this.contractService = contractService;
    }

    @Override
    public void run() {
        int start = 0;
        int pageSize = 25;
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("status", "active");
        opts.put("start", 0);
        opts.put("pageSize", pageSize);
        try {
            boolean hasNext = false;
            do {
                QueryResult<Contract> qr = this.contractService.searchContract(opts);
                for (Contract c : qr.getObjects()) {
                    if (c.getEndDate() == null || !c.isAutoRenew()) continue;
                    System.out.println("Checking out contract #" + String.valueOf(c.getContractId()) + ", " + c.getName());
                    this.contractService.renewContract(c);
                }
                if (qr.getObjects().size() > 0 || qr.getRowCount() > start + pageSize) {
                    hasNext = true;
                    opts.put("start", start += pageSize);
                    continue;
                }
                hasNext = false;
            } while (hasNext);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (JTBException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            ContractsObjectContainer oc = ContractsObjectContainer.getInstance();
            ContractRenewalTask t = oc.getContractTaskExecuter().getContractRenewalTask();
            t.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

