/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.service;

import itx.erp.ErpObjectContainer;
import itx.erp.base.model.User;
import itx.erp.base.model.UserPermission;
import itx.erp.base.model.UserPermissionCheck;
import itx.erp.base.model.UserPermissionList;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jtbcore.event.MessageBus;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.service.ServiceBase;
import jtbcore.util.NumberUtil;

public class UserPermissionService
extends ServiceBase {
    public UserPermissionList getPermissions(User user, String refObject, Integer refId) throws SQLException, JTBException {
        UserPermissionList upl = new UserPermissionList(refObject, refId);
        String sql = "select up.*, u.username, ug.group_name from base__user_permission up left join base__user u on (up.user_id = u.user_id )left join base__user_group ug on (ug.user_group_id = up.group_id) where up.ref_object = ? and up.ref_id = ?";
        List up = this.queryToList(UserPermission.class, sql, refObject, refId);
        upl.setPermissions(up);
        if (ErpObjectContainer.CONTRACTS_ENABLED && "file".equals(refObject)) {
            String sql2 = "select up.*, u.username, ug.group_name, c.name contract_name, up.access_method from contract__contract_file cf  join contract__contract c on (c.contract_id = cf.contract_id)  join base__user_permission up on (cf.contract_id = up.ref_id and up.ref_object='contract')  left join base__user u on (up.user_id = u.user_id) left join base__user_group ug on (up.group_id = ug.user_group_id) where db_file_id = ?";
            List recs = this.queryToList(UserPermission.class, sql2, refId);
            ArrayList<UserPermission> contractsInherited = new ArrayList<UserPermission>();
            HashMap<CallSite, UserPermission> map = new HashMap<CallSite, UserPermission>();
            int x = 0;
            while (x < recs.size()) {
                UserPermission up2 = (UserPermission)recs.get(x);
                String contractName = up2.getBaseStringMap().getProperty("contract_name");
                String refKey = String.valueOf(up2.getUserId()) + "-" + String.valueOf(up2.getGroupId());
                if (map.containsKey(refKey)) {
                    Object pn = up2.getBaseStringMap().getProperty("permission_note");
                    pn = (String)pn + " & " + contractName;
                    up2.getBaseStringMap().setProperty("permission_note", (String)pn);
                } else {
                    up2.getBaseStringMap().setProperty("permission_note", contractName);
                    map.put((CallSite)((Object)refKey), up2);
                    contractsInherited.add(up2);
                }
                ++x;
            }
            x = 0;
            while (x < contractsInherited.size()) {
                String n = ((UserPermission)contractsInherited.get(x)).getPermissionNote();
                if (n.length() > 0) {
                    ((UserPermission)contractsInherited.get(x)).setPermissionNote("Contract(en): " + n);
                }
                ++x;
            }
            upl.getInheritedPermissions().addAll(contractsInherited);
        }
        MessageBus.getInstance().sendMessage("UserPermissionService.getPermissions", upl);
        String accessMode = this.getAccessMode(user, upl);
        upl.setAccessMethod(accessMode);
        return upl;
    }

    public String getAccessMode(User user, String refObject, Integer refId) throws SQLException, JTBException {
        if (user.isAdmin()) {
            return "write";
        }
        UserPermissionList upl = this.getPermissions(user, refObject, refId);
        return this.getAccessMode(user, upl);
    }

    public String getAccessMode(User user, UserPermissionList upl) throws SQLException, JTBException {
        boolean groupOrUserMatch;
        if (user.isAdmin()) {
            return "write";
        }
        boolean readable = false;
        boolean writable = false;
        for (UserPermission up : upl.getPermissions()) {
            groupOrUserMatch = false;
            if (up.getUserId() != null && up.getUserId().intValue() == user.getUserId().intValue()) {
                groupOrUserMatch = true;
            }
            if (up.getGroupId() != null && user.inGroup(up.getGroupId())) {
                groupOrUserMatch = true;
            }
            if (!groupOrUserMatch) continue;
            if ("read".equals(up.getAccessMethod())) {
                readable = true;
            }
            if ("write".equals(up.getAccessMethod())) {
                readable = true;
                writable = true;
            }
            if (writable) break;
        }
        if (!writable) {
            for (UserPermission up : upl.getInheritedPermissions()) {
                groupOrUserMatch = false;
                if (up.getUserId() != null && up.getUserId().intValue() == user.getUserId().intValue()) {
                    groupOrUserMatch = true;
                }
                if (up.getGroupId() != null && user.inGroup(up.getGroupId())) {
                    groupOrUserMatch = true;
                }
                if (!groupOrUserMatch) continue;
                if ("read".equals(up.getAccessMethod())) {
                    readable = true;
                }
                if ("write".equals(up.getAccessMethod())) {
                    readable = true;
                    writable = true;
                }
                if (writable) break;
            }
        }
        if (writable) {
            return "write";
        }
        if (readable) {
            return "read";
        }
        return "none";
    }

    public void saveKvlPermissions(String refObject, Integer refId, List<KeyValueList> kvlPermissions) throws SQLException, JTBException, IOException {
        List oldUps = this.queryToList(UserPermission.class, "select * from base__user_permission where ref_object = ? and ref_id = ?", refObject, refId);
        int counter = 0;
        int x = 0;
        while (x < kvlPermissions.size()) {
            block7: {
                UserPermission up;
                String accessMethod;
                block9: {
                    Integer groupId;
                    String userGroupId;
                    block8: {
                        KeyValueList kvlp = kvlPermissions.get(x);
                        userGroupId = kvlp.getValue("userGroupId");
                        if (userGroupId == null) break block7;
                        accessMethod = kvlp.getValue("accessMethod");
                        if (!"read".equals(accessMethod) && !"write".equals(accessMethod)) {
                            accessMethod = "read";
                        }
                        up = new UserPermission();
                        if (!userGroupId.startsWith("user-")) break block8;
                        Integer userId = NumberUtil.tryParseInt(userGroupId.substring(5));
                        if (userId == null) break block7;
                        up.setUserId(userId);
                        break block9;
                    }
                    if (!userGroupId.startsWith("group-") || (groupId = NumberUtil.tryParseInt(userGroupId.substring(6))) == null) break block7;
                    up.setGroupId(groupId);
                }
                up.setAccessMethod(accessMethod);
                up.setRefObject(refObject);
                up.setRefId(refId);
                if (counter < oldUps.size()) {
                    up.setUserPermissionId(((UserPermission)oldUps.get(counter)).getUserPermissionId());
                }
                this.getConnection().save("base__user_permission", "user_permission_id", up);
                ++counter;
            }
            ++x;
        }
        while (counter < oldUps.size()) {
            this.getConnection().query("delete from base__user_permission where user_permission_id = ?", ((UserPermission)oldUps.get(counter)).getUserPermissionId());
            ++counter;
        }
    }

    public void savePermissions(String refObject, Integer refId, List<UserPermission> permissions) throws SQLException, JTBException, IOException {
        List oldUps = this.queryToList(UserPermission.class, "select * from base__user_permission where ref_object = ? and ref_id = ? order by user_permission_id", refObject, refId);
        int counter = 0;
        int x = 0;
        while (x < permissions.size()) {
            UserPermission up = permissions.get(x);
            if (up.getUserId() != null || up.getGroupId() != null) {
                up.setRefObject(refObject);
                up.setRefId(refId);
                if (counter < oldUps.size()) {
                    up.setUserPermissionId(((UserPermission)oldUps.get(counter)).getUserPermissionId());
                }
                this.getConnection().save("base__user_permission", "user_permission_id", up);
                ++counter;
            }
            ++x;
        }
        while (counter < oldUps.size()) {
            this.getConnection().query("delete from base__user_permission where user_permission_id = ?", ((UserPermission)oldUps.get(counter)).getUserPermissionId());
            ++counter;
        }
    }

    public Integer addUserPermission(Integer userId, String refObject, Integer refId, String accessMethod) throws SQLException, JTBException, IOException {
        List ups = this.queryToList(UserPermission.class, "select * from base__user_permission where ref_object = ? and ref_id = ?", refObject, refId);
        int x = 0;
        while (x < ups.size()) {
            if (((UserPermission)ups.get(x)).getUserId() != null) {
                int up_uid = ((UserPermission)ups.get(x)).getUserId();
                if (userId == up_uid) {
                    if (!accessMethod.equals(((UserPermission)ups.get(x)).getAccessMethod())) {
                        this.getConnection().query("update base__user_permission set access_mode = ? where user_permission_id = ?", accessMethod, ((UserPermission)ups.get(x)).getUserPermissionId());
                    }
                    return ((UserPermission)ups.get(x)).getUserPermissionId();
                }
            }
            ++x;
        }
        UserPermission up = new UserPermission();
        up.setRefObject(refObject);
        up.setRefId(refId);
        up.setAccessMethod(accessMethod);
        up.setUserId(userId);
        return this.getConnection().save("base__user_permission", "user_permission_id", up);
    }

    public Integer addGroupPermission(Integer groupId, String refObject, Integer refId, String accessMethod) throws SQLException, JTBException, IOException {
        List ups = this.queryToList(UserPermission.class, "select * from base__user_permission where ref_object = ? and ref_id = ?", refObject, refId);
        int x = 0;
        while (x < ups.size()) {
            if (((UserPermission)ups.get(x)).getGroupId() != null) {
                int up_gid = ((UserPermission)ups.get(x)).getGroupId();
                if (groupId == up_gid) {
                    if (!accessMethod.equals(((UserPermission)ups.get(x)).getAccessMethod())) {
                        this.getConnection().query("update base__user_permission set access_mode = ? where user_permission_id = ?", accessMethod, ((UserPermission)ups.get(x)).getUserPermissionId());
                    }
                    return ((UserPermission)ups.get(x)).getUserPermissionId();
                }
            }
            ++x;
        }
        UserPermission up = new UserPermission();
        up.setRefObject(refObject);
        up.setRefId(refId);
        up.setAccessMethod(accessMethod);
        up.setGroupId(groupId);
        return this.getConnection().save("base__user_permission", "user_permission_id", up);
    }

    public List<UserPermission> readByRef(String refObject, Integer refId) throws SQLException, JTBException {
        String sql = "select up.*, u.username, ug.group_name from base__user_permission up left join base__user u on (u.user_id = up.user_id) left join base__user_group ug on (ug.user_group_id = up.group_id) where up.ref_object = ? \t\tand up.ref_id = ? order by up.user_permission_id";
        List ups = this.queryToList(UserPermission.class, sql, refObject, refId);
        return ups;
    }

    public void checkAccess(User user, String refObject, Integer refId) throws SQLException, JTBException {
        String m = this.getAccessMode(user, refObject, refId);
        if ("read".equals(m) || "write".equals(m)) {
            return;
        }
        UserPermissionCheck upc = new UserPermissionCheck(user, refObject, refId);
        MessageBus.getInstance().sendMessage("UserPermissionsService.checkAccess", upc);
        if ("read".equals(upc.accessMethod) || "write".equals(upc.accessMethod)) {
            return;
        }
        throw new AuthorizationException("No access to " + refObject + ", " + String.valueOf(refId));
    }

    public void deletePermissions(String refObject, Integer refId) throws SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(refObject);
        Object sql = "delete from base__user_permission where ref_object = ? ";
        if (refId == null) {
            sql = (String)sql + " and ref_id is null ";
        } else {
            sql = (String)sql + " and ref_id = ?";
            params.add(refId);
        }
        this.connection.query((String)sql, params.toArray());
    }
}

