/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.service;

import itx.erp.ErpObjectContainer;
import itx.erp.base.model.Activity;
import itx.erp.base.model.DbFile;
import itx.erp.base.model.User;
import itx.erp.base.model.UserGroup;
import itx.erp.base.service.ErpServiceBase;
import itx.erp.base.service.UserPermissionService;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.event.EventMessage;
import jtbcore.event.MessageBus;
import jtbcore.exception.JTBException;
import jtbcore.util.MapUtil;
import jtbcore.util.StringUtil;

public class FileService
extends ErpServiceBase {
    protected UserPermissionService userPermissionService;

    public UserPermissionService getUserPermissionService() {
        return this.userPermissionService;
    }

    public void setUserPermissionService(UserPermissionService userPermissionService) {
        this.userPermissionService = userPermissionService;
    }

    public DbFile readFile(Integer dbFileId) throws SQLException, JTBException {
        DbFile f = (DbFile)this.queryToObject(DbFile.class, "select * from base__db_file where db_file_id = ?", dbFileId);
        return f;
    }

    public QueryResult<DbFile> searchFiles(User user, Map<String, Object> opts) throws SQLException {
        String sqlCustomerFilter;
        Integer customerId;
        List selectedFileIds;
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("base__db_file");
        b.addSelectField("base__db_file", "db_file_id");
        b.addSelectField("base__db_file", "path");
        b.addSelectField("base__db_file", "ref_description");
        b.addSelectField("base__db_file", "original_filename");
        b.addSelectField("base__db_file", "rev");
        b.addSelectField("base__db_file", "size");
        b.addSelectField("base__db_file", "edited");
        b.addSelectField("base__db_file", "created");
        if (MapUtil.hasProperty(opts, "q")) {
            String q = opts.get("q").toString();
            b.addWhere(" base__db_file.ref_description like ? or base__db_file.original_filename like ? ", "%" + q + "%", "%" + q + "%");
        }
        if (opts.get("selectedFileIds") instanceof List && (selectedFileIds = (List)opts.get("selectedFileIds")).size() > 0 && selectedFileIds.size() < 200) {
            b.addLeftJoin("base__db_file", "base__db_file.db_file_id = dbf_selected.db_file_id and dbf_selected.db_file_id IN (" + StringUtil.join(", ", selectedFileIds) + ")", "dbf_selected");
            b.setRawOrderBy("ifnull(dbf_selected.db_file_id, 0) > 0 desc, dbf_selected.db_file_id desc");
        }
        if (!user.isAdmin()) {
            String userGroupIds = StringUtil.join(",", user.getUserGroupIds());
            if (userGroupIds.length() == 0) {
                userGroupIds = " 0 ";
            }
            String sqlUserPermissions = "select ref_id from base__user_permission where ref_object = 'file' and (user_id = " + String.valueOf(user.getUserId()) + " or group_id in ( " + userGroupIds + " ) )";
            Object sqlPermissions = "";
            sqlPermissions = (String)sqlPermissions + "base__db_file.db_file_id IN (" + sqlUserPermissions + ") ";
            if (ErpObjectContainer.CONTRACTS_ENABLED) {
                String sqlContractsPermissions = "select f.db_file_id from contract__contract_file f where f.contract_id IN ( \t\tselect ref_id \t\tfrom base__user_permission \t\twhere ref_object = 'contract' and (user_id = " + String.valueOf(user.getUserId()) + " or group_id in (" + userGroupIds + ")) )";
                sqlPermissions = (String)sqlPermissions + " OR ";
                sqlPermissions = (String)sqlPermissions + "base__db_file.db_file_id IN (" + sqlContractsPermissions + ") ";
            }
            if (ErpObjectContainer.RTOB_ENABLED) {
                String sqlWorkOrderPermissions = "select f.db_file_id from rtob__work_order_file f join base__user_permission up on (up.ref_object = 'work_order' and up.ref_id = f.work_order_id) where up.user_id = " + String.valueOf(user.getUserId()) + " or group_id in (" + userGroupIds + ")";
                sqlPermissions = (String)sqlPermissions + " OR ";
                sqlPermissions = (String)sqlPermissions + "base__db_file.db_file_id IN (" + sqlWorkOrderPermissions + ") ";
            }
            b.addWhere((String)sqlPermissions, new Object[0]);
        }
        if (ErpObjectContainer.RTOB_ENABLED && opts.containsKey("customerId") && opts.get("customerId") instanceof Integer) {
            customerId = (Integer)opts.get("customerId");
            sqlCustomerFilter = "select wof.db_file_id from rtob__work_order_file wof join rtob__work_order wo on (wof.work_order_id = wo.work_order_id) where wo.customer_id =  " + String.valueOf(customerId);
            b.addWhere(" base__db_file.db_file_id IN (" + sqlCustomerFilter + ") ", new Object[0]);
        }
        if (ErpObjectContainer.CONTRACTS_ENABLED && opts.containsKey("customerId") && opts.get("customerId") instanceof Integer) {
            customerId = (Integer)opts.get("customerId");
            sqlCustomerFilter = "select cf.db_file_id from contract__contract c join contract__contract_file cf on (c.contract_id = cf.contract_id) where c.customer_id = " + String.valueOf(customerId);
            b.addWhere(" base__db_file.db_file_id IN (" + sqlCustomerFilter + ") ", new Object[0]);
        }
        if (b.getRawOrderBy() == null) {
            b.setRawOrderBy("base__db_file.db_file_id desc");
        }
        ResultSet rs = b.queryResultSet();
        QueryResult<DbFile> qr = new QueryResult<DbFile>();
        if (opts.containsKey("start")) {
            qr.setStart((Integer)opts.get("start"));
        }
        if (opts.containsKey("pageSize")) {
            qr.setPageSize((Integer)opts.get("pageSize"));
        }
        qr.fill(DbFile.class, rs);
        rs.close();
        return qr;
    }

    public Integer saveFile(User user, DbFile f, boolean log) throws IOException, SQLException, JTBException {
        DbFile old = null;
        if (f.getDbFileId() != null) {
            old = this.readFile(f.getDbFileId());
        }
        Integer dbFileId = this.connection.save("base__db_file", "db_file_id", f);
        Activity a = new Activity();
        a.setRefObject(DbFile.class.getName());
        a.setRefId(dbFileId);
        if (old == null) {
            a.setShortDescription("New file: " + f.getOriginalFilename());
            a.setCode("file-new");
            a.addValue("refDescription", f.getRefDescription(), (String)null);
        } else {
            a.setShortDescription("Update file: " + f.getOriginalFilename());
            a.setCode("file-update");
            a.addValue("refDescription", old.getRefDescription(), f.getRefDescription());
        }
        if (user != null && old == null) {
            this.userPermissionService.addUserPermission(user.getUserId(), "file", dbFileId, "write");
            for (UserGroup ug : user.getGroup()) {
                this.userPermissionService.addGroupPermission(ug.getUserGroupId(), "file", dbFileId, "write");
            }
        }
        this.saveActivity(a);
        return dbFileId;
    }

    public void deleteFile(DbFile dbf, Integer reqUserId) throws IOException, SQLException, JTBException {
        dbf = this.readFile(dbf.getDbFileId());
        this.connection.query("delete from base__db_file where db_file_id = ?", dbf.getDbFileId());
        File f = new File(ErpObjectContainer.getInstance().getFilesDir() + "/" + dbf.getPath());
        if (f.exists() && f.isFile()) {
            f.delete();
        }
        Activity a = new Activity();
        a.setRefObject(DbFile.class.getName());
        a.setRefId(dbf.getDbFileId());
        a.setShortDescription("Deleting file: " + dbf.getOriginalFilename());
        a.setCode("file-delete");
        a.addValue("refDescription", dbf.getRefDescription(), (String)null);
        this.saveActivity(a);
        EventMessage m = new EventMessage("FileService.deleteFile");
        m.setProp("value", dbf);
        m.setProp("userId", reqUserId);
        MessageBus.getInstance().sendMessage(m);
    }
}

