/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.model.validator;

import itx.erp.ErpObjectContainer;
import itx.erp.base.model.UserGroup;
import itx.erp.base.service.GroupService;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.ContainerException;
import jtbcore.model.validator.BaseValidator;
import jtbcore.model.validator.ValidatorResult;
import jtbcore.util.MapUtil;

public class UserGroupValidator
extends BaseValidator<UserGroup> {
    protected GroupService groupService = ErpObjectContainer.getInstance().getGroupService();

    public UserGroupValidator() throws ContainerException {
        super.addValidator("userGroupId", null);
        super.addValidator("default_selected", null);
        super.addValidator("group_name", ug -> {
            String n = ug.getGroupName();
            if (n == null) {
                return new ValidatorResult(false, "verplicht");
            }
            if ((n = n.trim()).length() == 0) {
                return new ValidatorResult(false, "verplicht");
            }
            try {
                QueryResult<UserGroup> qr = this.groupService.searchGroups(MapUtil.createStringObjectMap("group_name", ug.getGroupName()));
                for (UserGroup ug2 : qr.getObjects()) {
                    if (ug.getUserGroupId() == null) {
                        return new ValidatorResult(false, "groepsnaam reeds in gebruik (1)");
                    }
                    if (ug.getUserGroupId() == ug2.getUserGroupId()) continue;
                    return new ValidatorResult(false, "groepsnaam reeds in gebruik (2)");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ug.setGroupName(n);
            return null;
        });
    }
}

