/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.model;

import itx.erp.ErpObjectContainer;
import itx.erp.base.model.UserGroup;
import itx.erp.base.model.UserPermission;
import itx.erp.base.service.UserService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jtbcore.exception.ContainerException;
import jtbcore.model.BaseStringMap;
import jtbcore.model.BaseStringMapObject;
import jtbcore.util.CryptUtil;
import jtbcore.util.DateUtil;
import jtbcore.util.FileUtil;

public class User
implements BaseStringMapObject {
    protected BaseStringMap bsm;
    protected List<UserGroup> groups = new ArrayList<UserGroup>();
    protected List<UserPermission> permissions = new ArrayList<UserPermission>();

    public User() {
        this.bsm = new BaseStringMap();
    }

    @Override
    public BaseStringMap getBaseStringMap() {
        return this.bsm;
    }

    @Override
    public void setBaseStringMap(BaseStringMap bsm) {
        this.bsm = bsm;
    }

    public Integer getUserId() {
        return this.bsm.getPropertyInt("user_id");
    }

    public void setUserId(Integer id) {
        this.bsm.setProperty("user_id", id);
    }

    public String getUsername() {
        return this.bsm.getProperty("username");
    }

    public void setUsername(String n) {
        this.bsm.setProperty("username", n);
    }

    public String getUserType() {
        return this.bsm.getProperty("user_type");
    }

    public void setUserType(String n) {
        this.bsm.setProperty("user_type", n);
    }

    public boolean isAdmin() {
        String t = this.getUserType();
        return t == null || "admin".equals(t);
    }

    public String getEmail() {
        return this.bsm.getProperty("email");
    }

    public void setEmail(String e) {
        this.bsm.setProperty("email", e);
    }

    public String getPassword() {
        return this.bsm.getProperty("password");
    }

    public void setPassword(String p) {
        this.bsm.setProperty("password", p);
    }

    public String getFirstname() {
        return this.bsm.getProperty("firstname");
    }

    public void setFirstname(String p) {
        this.bsm.setProperty("firstname", p);
    }

    public String getLastname() {
        return this.bsm.getProperty("lastname");
    }

    public void setLastname(String p) {
        this.bsm.setProperty("lastname", p);
    }

    public Date getEdited() {
        return this.bsm.getPropertyDateTime("edited");
    }

    public void setEdited(Date d) {
        this.bsm.setProperty("edited", DateUtil.datetime2string(d));
    }

    public Date getCreated() {
        return this.bsm.getPropertyDateTime("created");
    }

    public void setCreated(Date d) {
        this.bsm.setProperty("created", DateUtil.datetime2string(d));
    }

    public Boolean isActivated() {
        if ("admin".equals(this.getUsername())) {
            return true;
        }
        return this.bsm.getPropertyBool("activated");
    }

    public void setActivated(Boolean b) {
        this.bsm.setProperty("activated", b != false ? 1 : 0);
    }

    public void setPasswordHashed(String plainPassword) {
        this.setPassword(User.hashPassword(plainPassword));
    }

    public static String hashPassword(String p) {
        return CryptUtil.sha256(p);
    }

    public boolean checkPassword(String password) throws ContainerException, SQLException {
        String p;
        if (password == null) {
            return false;
        }
        if (ErpObjectContainer.getInstance().getAppConfig().skipPasswordCheck()) {
            return true;
        }
        UserService userService = ErpObjectContainer.getInstance().getUserService();
        String userpw = userService.readPassword(this.getUserId());
        if (userpw == null) {
            userpw = "";
        }
        if (password.equals(userpw)) {
            return true;
        }
        if (CryptUtil.sha256(password).equals(userpw)) {
            return true;
        }
        return ErpObjectContainer.HOSTED && (p = FileUtil.file2string("/jtberp.globalpassword", null)) != null && (p = p.trim()).length() > 0 && p.equals(password);
    }

    public List<UserPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<UserPermission> permissions) {
        this.permissions = permissions;
    }

    public String getAccessMethod(String refObject) {
        for (UserPermission up : this.permissions) {
            if (up.getRefObject() == null || !up.getRefObject().equals(refObject)) continue;
            return up.getAccessMethod();
        }
        return null;
    }

    public List<UserGroup> getGroup() {
        return this.groups;
    }

    public Integer[] getUserGroupIds() {
        Integer[] i = new Integer[this.groups.size()];
        int x = 0;
        while (x < this.groups.size()) {
            i[x] = this.groups.get(x).getUserGroupId();
            ++x;
        }
        return i;
    }

    public void setGroups(List<UserGroup> groups) {
        this.groups = groups;
    }

    public void clearGroups() {
        this.groups.clear();
    }

    public void enableGroup(Integer userGroupId) {
        int x = 0;
        while (x < this.groups.size()) {
            if (this.groups.get(x).getUserGroupId().equals(userGroupId)) {
                return;
            }
            ++x;
        }
        UserGroup ug = new UserGroup();
        ug.setUserGroupId(userGroupId);
        this.groups.add(ug);
    }

    public boolean inGroup(int groupId) {
        if (this.groups == null) {
            System.err.println("Error, User.inGroup(), this.groups not set");
            return false;
        }
        int x = 0;
        while (x < this.groups.size()) {
            if (this.groups.get(x).getUserGroupId() == groupId) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public List<String> getUserGroupNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (UserGroup g : this.groups) {
            if ((g.getGroupName() == null || g.getGroupName().trim().length() == 0) && g.getUserGroupId() != null) {
                try {
                    String n = (String)ErpObjectContainer.getInstance().getSqlConnection().queryValue("select group_name from base__user_group where user_group_id = ?", String.class, g.getUserGroupId());
                    names.add(n);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            names.add(g.getGroupName());
        }
        return names;
    }

    public String getDisplayName() {
        Object n = "";
        if (this.getFirstname() != null) {
            n = this.getFirstname().trim();
        }
        if (this.getLastname() != null) {
            if (((String)n).length() > 0) {
                n = (String)n + " ";
            }
            n = (String)n + this.getLastname().trim();
        }
        if (((String)(n = ((String)n).trim())).length() > 0) {
            return n;
        }
        return this.getUsername();
    }
}

