/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.TableSelectorResponse;
import itx.erp.base.model.User;
import itx.erp.base.model.UserGroup;
import itx.erp.base.model.UserPermission;
import itx.erp.base.model.validator.UserValidator;
import itx.erp.base.service.GroupService;
import itx.erp.base.service.UserService;
import itx.erp.base.util.LangUtil;
import itx.erp.exception.ObjectNotFoundException;
import itx.erp.helper.ErpConfig;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.InvalidStateException;
import jtbcore.model.BaseStringMap;
import jtbcore.util.NumberUtil;

public class UsersController
extends BaseController {
    protected ErpConfig appConfig;
    protected UserService userService;
    protected GroupService groupService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    @Override
    public void handleRequest(WebRequest req) throws Exception {
        if (!("listUserGroups".equals(req.getParameter("a")) || "listUsers".equals(req.getParameter("a")) || "view".equals(req.getParameter("a")) || this.userService.isAdmin(req.getUserId()))) {
            throw new AuthorizationException("Only admin allowed");
        }
        super.executeAction(req);
    }

    public void indexAction(WebRequest req) throws Exception {
        QueryResult<User> r = this.userService.searchUsers(null);
        req.renderJson(r);
    }

    public void groupsAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        List<UserGroup> groups = this.groupService.readAll();
        req.renderJson(groups);
    }

    public void viewAction(WebRequest req) throws Exception {
        String strUserId = req.getParameter("userId");
        if (strUserId == null) {
            throw new InvalidStateException("userId not set");
        }
        Integer userId = null;
        userId = strUserId.startsWith("user-") ? NumberUtil.tryParseInt(strUserId.substring(5)) : NumberUtil.tryParseInt(strUserId);
        User user = this.userService.readUser(userId);
        if (user == null) {
            throw new ObjectNotFoundException("User not found");
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("success", true);
        response.put("user", user);
        List<UserGroup> groups = this.groupService.readAll();
        response.put("groups", groups);
        req.renderJson(response);
    }

    public void saveAction(WebRequest req) throws Exception {
        Integer userId = req.getParamInt("user_id");
        User u = new User();
        if (userId != null) {
            u = this.userService.readUser(userId);
        }
        UserValidator v = new UserValidator();
        if (u.getUserId() != null && u.getUserId() == 1) {
            u.setActivated(true);
            u.setUserType("admin");
        } else {
            u.setActivated(req.getParamBool("activated"));
            u.setUserType(req.getParameter("userType"));
            u.setUsername(req.getParameterTrim("username"));
        }
        if (req.hasParameter("password") && req.getParameter("password").length() > 0) {
            u.setPasswordHashed(req.getParameter("password"));
        }
        u.setEmail(req.getParameterTrim("email"));
        u.setFirstname(req.getParameterTrim("firstname"));
        u.setLastname(req.getParameterTrim("lastname"));
        u.clearGroups();
        List<String> groupIds = req.getKvl().getArrayList("group_id");
        for (String strgid : groupIds) {
            Integer gid = NumberUtil.tryParseInt(strgid);
            if (gid == null) continue;
            u.enableGroup(gid);
        }
        Map<String, String> params = req.getKvl().getKeyValueMap();
        for (String k : params.keySet()) {
            if (k == null || !k.startsWith("up.")) continue;
            UserPermission up = new UserPermission();
            up.setRefObject(k);
            up.setAccessMethod(params.get(k));
            u.getPermissions().add(up);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (v.validate(u)) {
            this.userService.saveUser(u, req.getUserId());
            result.put("success", true);
            result.put("user", u);
        } else {
            result.put("errors", v.getErrors());
            result.put("error", true);
        }
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws Exception {
        Integer userId = req.getParamInt("userId");
        User u = this.userService.readUser(userId);
        this.userService.deleteUser(u, userId);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void listUserGroupsAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        String sql = "select * from ( \tselect 'user' type, u.user_id id, u.username name, u.email, u.firstname, u.lastname \tfrom base__user u  {{where_user}} \tUNION \tselect 'group' type, ug.user_group_id id, ug.group_name name, '', '', '' \tfrom base__user_group ug  {{where_group}} ) a order by lower(a.name) ";
        ArrayList<CallSite> params = new ArrayList<CallSite>();
        String q = req.getParameter("q");
        if (q != null && q.trim().length() > 0) {
            sql = sql.replace("{{where_user}}", "where u.username like ? ");
            sql = sql.replace("{{where_group}}", "where ug.group_name like ? ");
            params.add((CallSite)((Object)(q + "%")));
            params.add((CallSite)((Object)(q + "%")));
        } else {
            sql = sql.replace("{{where_user}}", "");
            sql = sql.replace("{{where_group}}", "");
        }
        LangUtil lu = LangUtil.getInstance();
        List<BaseStringMap> recs = this.userService.getConnection().queryBsmList(sql, params.toArray());
        ArrayList<Map<String, String>> records = new ArrayList<Map<String, String>>();
        int x = 0;
        while (x < recs.size()) {
            BaseStringMap rec = recs.get(x);
            rec.setProperty("id", rec.getProperty("type") + "-" + rec.getProperty("id"));
            rec.setProperty("defaultText", rec.getProperty("name"));
            rec.setProperty("typeText", lu.t(rec.getProperty("type")));
            records.add(rec.getMap());
            ++x;
        }
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", 0);
        opts.put("pageSize", 5);
        opts.put("q", req.getParameter("q"));
        TableSelectorResponse r = new TableSelectorResponse();
        r.addHeader("typeText", "Type");
        r.addHeader("name", "Naam");
        r.addRecords(records);
        req.renderJson(r);
    }

    public void listUsersAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        String sql = "select 'user' type, u.user_id, u.username, u.email, u.firstname, u.lastname \tfrom base__user u  {{where_user}} order by lower(u.username) ";
        ArrayList<CallSite> params = new ArrayList<CallSite>();
        String q = req.getParameter("q");
        if (q != null && q.trim().length() > 0) {
            sql = sql.replace("{{where_user}}", "where u.username like ? ");
            params.add((CallSite)((Object)(q + "%")));
        } else {
            sql = sql.replace("{{where_user}}", "");
        }
        LangUtil lu = LangUtil.getInstance();
        List<BaseStringMap> recs = this.userService.getConnection().queryBsmList(sql, params.toArray());
        ArrayList<Map<String, String>> records = new ArrayList<Map<String, String>>();
        int x = 0;
        while (x < recs.size()) {
            BaseStringMap rec = recs.get(x);
            rec.setProperty("id", rec.getProperty("type") + "-" + rec.getProperty("user_id"));
            rec.setProperty("defaultText", rec.getProperty("username"));
            rec.setProperty("typeText", lu.t(rec.getProperty("type")));
            records.add(rec.getMap());
            ++x;
        }
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", 0);
        opts.put("pageSize", 5);
        opts.put("q", req.getParameter("q"));
        TableSelectorResponse r = new TableSelectorResponse();
        r.addHeader("typeText", "Type");
        r.addHeader("defaultText", "Naam");
        r.addRecords(records);
        req.renderJson(r);
    }

    public void resetPasswordMailAction(WebRequest req) throws StreamWriteException, DatabindException, IOException {
        Integer userId = req.getParamInt("userId");
        HashMap<String, Object> r = new HashMap<String, Object>();
        try {
            User user = this.userService.readUser(userId);
            this.userService.resetPasswordMail(user, req.getRemoteIp());
            r.put("success", true);
        }
        catch (Exception ex) {
            r.put("success", false);
            r.put("error", true);
            r.put("message", ex.getMessage());
        }
        req.renderJson(r);
    }
}

