/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.User;
import itx.erp.base.model.WebSession;
import itx.erp.base.service.UserService;
import itx.erp.base.service.WebSessionService;
import itx.erp.base.util.LangUtil;
import itx.erp.webmail.model.ResetPassword;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.exception.ContainerException;
import jtbcore.exception.JTBException;
import jtbcore.util.DateUtil;

public class AuthController
extends BaseController {
    protected UserService userService;
    protected WebSessionService webSessionService;

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public WebSessionService getWebSessionService() {
        return this.webSessionService;
    }

    public void setWebSessionService(WebSessionService webSessionService) {
        this.webSessionService = webSessionService;
    }

    @Override
    public void handleRequest(WebRequest req) throws Exception {
        String action = req.getParameter("a");
        if ("auth".equals(action)) {
            this.authAction(req);
            return;
        }
        if ("logoff".equals(action)) {
            this.logoffAction(req);
            return;
        }
        if ("requestPasswordReset".equals(action)) {
            this.requestPasswordResetAction(req);
            return;
        }
        if ("checkSecurityToken".equals(action)) {
            this.checkSecurityTokenAction(req);
            return;
        }
        if ("resetPassword".equals(action)) {
            this.resetPasswordAction(req);
            return;
        }
        if (req.getWebSession() == null) {
            req.getResponse().setStatus(401);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("authenticationError", true);
            result.put("message", "User not authenticated");
            req.renderJson(result);
        }
    }

    public void authAction(WebRequest req) throws SQLException, IOException, ContainerException {
        String username = req.getParameter("username");
        if (username != null) {
            username = username.trim();
        }
        String password = req.getParameter("password");
        HashMap<String, Object> result = new HashMap<String, Object>();
        User user = this.userService.readUser(username);
        if (user != null && user.checkPassword(password)) {
            if (!user.isActivated().booleanValue()) {
                result.put("message", "Deze gebruiker staat op in-actief");
                result.put("success", false);
            } else {
                Boolean b = req.getParamBool("rememberme");
                WebSession ws = this.webSessionService.createSession(user, b != false ? Integer.valueOf(-1) : null);
                req.setCookie("jtbauth", ws.getCookieValue(), DateUtil.unixTimestamp() + ws.getExpiry());
                result.put("success", true);
            }
        } else {
            result.put("message", "Ongeldige gebruikersnaam/wachtwoord");
            result.put("success", false);
        }
        req.renderJson(result);
    }

    public void logoffAction(WebRequest req) throws SQLException, IOException {
        WebSession ws = req.getWebSession();
        if (req.getParamBool("allsessions").booleanValue() && ws.getUserId() != null) {
            this.webSessionService.destroySessionsForUser(ws.getUserId());
        } else {
            this.webSessionService.destroySession(ws);
        }
        req.setWebSession(null);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void requestPasswordResetAction(WebRequest req) throws Exception {
        String usernameEmail = req.getParameter("username_email");
        HashMap<String, Object> r = new HashMap<String, Object>();
        try {
            int c = this.userService.resetPasswordMail(usernameEmail, req.getRemoteIp());
            if (c > 0) {
                r.put("success", true);
            } else {
                r.put("success", false);
                r.put("error", true);
                r.put("message", LangUtil.getInstance().t("Unknown username/emailaddress"));
            }
        }
        catch (Exception ex) {
            r.put("success", false);
            r.put("error", true);
            r.put("message", ex.getMessage());
        }
        req.renderJson(r);
    }

    public void checkSecurityTokenAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        String sec = req.getParameter("sec");
        ResetPassword rp = this.userService.readPasswordResetBySec(sec);
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (rp == null) {
            r.put("success", false);
            r.put("error", true);
            r.put("message", "Invalid security token");
            req.renderJson(r);
            return;
        }
        String err = rp.getTokenError();
        if (err != null) {
            r.put("success", false);
            r.put("error", true);
            r.put("message", err);
            req.renderJson(r);
            return;
        }
        User user = this.userService.readUser(rp.getUserId());
        r.put("success", true);
        r.put("username", user.getUsername());
        r.put("message", "OK");
        req.renderJson(r);
    }

    public void resetPasswordAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        String sec = req.getParameter("sec");
        HashMap<String, Object> r = new HashMap<String, Object>();
        try {
            User user = this.userService.doResetPassword(sec, req.getParameter("password"), req.getRemoteIp());
            WebSession ws = this.webSessionService.createSession(user, -1);
            req.setCookie("jtbauth", ws.getCookieValue(), DateUtil.unixTimestamp() + ws.getExpiry());
            r.put("success", true);
            r.put("message", "OK");
        }
        catch (Exception ex) {
            r.put("success", false);
            r.put("message", ex.getMessage());
            ex.printStackTrace();
        }
        req.renderJson(r);
    }
}

