/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.ErpObjectContainer;
import itx.erp.base.model.User;
import itx.erp.base.service.UserService;
import itx.erp.helper.ErpConfig;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import jtbcore.event.LookupChain;
import jtbcore.event.MessageBus;

public class AppIndexController
extends BaseController {
    protected Configuration cfg = null;
    protected ErpConfig appConfig;
    protected UserService userService;

    public void setAppConfig(ErpConfig e) {
        this.appConfig = e;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    protected void init() throws IOException {
        if (this.cfg == null) {
            this.cfg = new Configuration();
            this.cfg.setDefaultEncoding("UTF-8");
            this.cfg.setTemplateLoader((TemplateLoader)new StringTemplateLoader());
        }
    }

    @Override
    public void handleRequest(WebRequest req) throws Exception {
        User user;
        this.init();
        String strTpl = this.appConfig.getResourceAsString("/itx/erp/resources/static/index.html");
        Template tpl = new Template("mytpl", (Reader)new StringReader(strTpl));
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("contextPath", req.getContextPath());
        vars.put("servicePath", req.getContextPath() + "/service");
        vars.put("desktopMode", this.appConfig.isDesktopMode() ? 1 : 0);
        vars.put("userId", req.getUserId() != null ? req.getUserId() : 0);
        vars.put("strIsAdmin", this.userService.isAdmin(req.getUserId()) ? "true" : "false");
        vars.put("r2bhosted", ErpObjectContainer.HOSTED ? "true" : "false");
        vars.put("embeddedRequest", req.isEmbeddedRequest() ? "true" : "false");
        vars.put("json_username", "\"\"");
        vars.put("username", "");
        vars.put("json_user", "null");
        if (req.getUserId() != null && (user = this.userService.readUser(req.getUserId())) != null) {
            vars.put("username", user.getUsername());
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put("username", user.getUsername());
            r.put("permissions", user.getPermissions());
            r.put("isAdmin", user.isAdmin());
            ObjectMapper om = new ObjectMapper();
            vars.put("json_user", om.writeValueAsString(r));
        }
        ArrayList scripts = new ArrayList();
        MessageBus.getInstance().sendMessage("javascript-index-page", scripts);
        vars.put("scripts", scripts);
        ArrayList cssSheets = new ArrayList();
        MessageBus.getInstance().sendMessage("css-index-page", cssSheets);
        vars.put("cssSheets", cssSheets);
        String companyName = this.appConfig.getSetting("companyName");
        Object titlePrefix = "";
        if (companyName != null && companyName.trim().length() > 0) {
            titlePrefix = companyName + " - ";
        }
        vars.put("titlePrefix", titlePrefix);
        String titleSuffix = "";
        titleSuffix = LookupChain.lookupString("titlebar-title-suffix", companyName);
        vars.put("titleSuffix", titleSuffix != null && titleSuffix.length() > 0 ? " - " + titleSuffix : "");
        String publicAppName = ErpObjectContainer.getInstance().getProperty("publicAppName");
        vars.put("publicAppName", publicAppName);
        String publicVersion = ErpObjectContainer.getInstance().getProperty("publicVersion");
        vars.put("publicVersion", publicVersion);
        StringWriter w = new StringWriter();
        tpl.process(vars, (Writer)w);
        w.close();
        req.getResponse().setContentType("text/html");
        req.getResponse().getOutputStream().write(w.toString().getBytes());
    }
}

