/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.Activity;
import itx.erp.base.service.ActivityService;
import itx.erp.base.service.UserService;
import itx.erp.helper.ErpConfig;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.InvalidStateException;

public class ActivityController
extends BaseController {
    protected ErpConfig appConfig;
    protected ActivityService activityService;
    protected UserService userService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public ActivityService getActivityService() {
        return this.activityService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        if (!this.userService.isAdmin(webRequest.getUserId())) {
            throw new AuthorizationException("Only admin allowed");
        }
        this.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, InvalidStateException {
        Integer start = req.getParamInt("pageNo", 0) * this.appConfig.getLimit();
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", start);
        opts.put("pageSize", this.appConfig.getLimit());
        opts.put("refObject", req.getParameter("refObject"));
        opts.put("refId", req.getParamInt("refId"));
        opts.put("shortDescription", req.getParameter("shortDescription"));
        opts.put("username", req.getParameter("username"));
        QueryResult<Activity> qr = this.activityService.searchActivity(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("acts", qr.getObjects());
        result.put("rowCount", qr.getRowCount());
        result.put("pageSize", qr.getPageSize());
        result.put("start", qr.getStart());
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        Integer activityId = req.getParamInt("activityId");
        Activity act = this.activityService.readActivity(activityId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("activity", act);
        req.renderJson(result);
    }
}

