/*
 * Decompiled with CFR 0.152.
 */
package itx.erp;

import itx.erp.ErpObjectContainer;
import itx.erp.base.model.UserGroup;
import itx.erp.base.util.ActivityLogger;
import itx.erp.customer.model.Customer;
import itx.erp.customer.model.Email;
import itx.erp.customer.service.CustomerService;
import java.util.ArrayList;
import java.util.Map;
import jtbcore.util.ObjectToMapUtil;

public class TestApp {
    public void run() throws Exception {
        ArrayList<UserGroup> ugs = new ArrayList<UserGroup>();
        ugs.add(new UserGroup(2, "test"));
        ugs.add(new UserGroup(1, "test"));
        ErpObjectContainer oc = ErpObjectContainer.getInstance();
        CustomerService cs = oc.getCustomerService();
        Customer c1 = cs.readCustomer(1);
        Customer c2 = cs.readCustomer(1);
        c2.setCustomerName("blabla");
        c2.getEmails().add(new Email("timbo@itxplain.nl", "jojo"));
        c2.getEmails().add(new Email("info@itxplain.nl", null));
        c2.getMymap().put("bla", "hoho");
        ActivityLogger l = new ActivityLogger(c1, c2);
        l.setShortDescription("Customer changed");
        l.addFields("customerType", "customerName", "cocNumber", "vatNumber", "iban", "bic", "note", "emails.emailAddress", "emails.description", "phones.phonenr", "phones.description", "addresses.street", "addresses.streetNo", "addresses.zipcode", "addresses.city", "addresses.country", "addresses.note");
        l.logNew();
        ObjectToMapUtil otm = new ObjectToMapUtil(c2);
        otm.addFields("customerType", "customerName", "cocNumber", "vatNumber", "iban", "bic", "note", "emails.emailAddress", "emails.description", "phones.phonenr", "phones.description", "addresses.street", "addresses.streetNo", "addresses.zipcode", "addresses.city", "addresses.country", "addresses.note");
        otm.addFields("customerName", "emails.emailAddress", "customerType", "emails.description", "mymap.bla");
        Map<String, Object> m = otm.map();
        for (String k : m.keySet()) {
            System.out.println("Test: " + k + "\t" + String.valueOf(m.get(k)));
        }
        System.exit(0);
    }

    public String getTestVal() {
        return "blabla";
    }

    public static void main(String[] args) {
        try {
            TestApp a = new TestApp();
            a.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

