


EzTemplateLoader.addTemplate('h1', `
	<h1>{{text}}</h1>
`);

EzTemplateLoader.addTemplate('text', `
	<span class="text">{{text}}</span>
`);



EzTemplateLoader.addTemplate('ez-text', `
	<div class="input">
		<label>{{label}}</label>
		
		<input type="text" name="{{name}}" [value]="value" placeholder="{{ typeof placeholder != 'undefined' ? placeholder : ''}}" />
		
		<span class="error"></span>
	</div>
`);

EzTemplateLoader.addTemplate('ez-price', `
	<div class="input">
		<label>{{label}}</label>
		
		<input type="text" name="{{name}}" value="{{format_price(value,true)}}" onchange="this.value = format_price(this.value, true);" />
		
		<span class="error"></span>
	</div>
`);

EzTemplateLoader.addTemplate('ez-number', `
	<div class="input input-number">
		<label>{{label}}</label>
		
		<input type="number" name="{{name}}" [value]="value" [min]="min" [max]="max" step]="step" />
		
		<span class="error"></span>
	</div>
`);

EzTemplateLoader.addTemplate('ez-textarea', `
	<div class="input input-textarea">
		<label>{{label}}</label>
		
		<textarea name="{{name}}" [contentHTML]="value"></textara>
		
		<span class="error"></span>
	</div>
`);


EzTemplateLoader.addTemplate('ez-email', `
	<div class="input input-email">
		<label>{{label}}</label>
		
		<input type="email" name="{{name}}" [value]="value" />
		
		<span class="error"></span>
	</div>
`);


EzTemplateLoader.addTemplate('ez-password', `
	<div class="input input-password">
		<label>{{label}}</label>
		
		<input type="password" name="{{name}}" [value]="value" [placeholder]="placeholder" [autocomplete]="autocomplete" />
		
		<span class="error"></span>
	</div>
`);

EzTemplateLoader.addTemplate('ez-checkbox', `
	<div class="input input-checkbox">
		<label for="cb_{{name||slug}}">
			{{label}}
			<span class="mouseover-message"></span>
		</label>
		
		<input type="checkbox" id="cb_{{name||slug}}" name="{{name||slug}}" />
		
		
		<span class="error"></span>
		
		<script>
			let node = document.currentScript.parentNode;
			if (typeof checked != 'undefined' && checked) {
				node.querySelector('input[type=checkbox]').checked=true;
			}
			
			if (typeof infotext != 'undefined' && infotext != '') {
				let i = $('<i class="fa-solid fa-info"></i>');
				let sp = $('<span class="mouseover-message-text"></span>');
				sp.text( infotext );
				
				$(node).find('.mouseover-message').append(i);
				$(node).find('.mouseover-message').append(sp);
			}
			
		</script>
		
		
		<div class="clear"></div>
	</div>
`);

EzTemplateLoader.addTemplate('ez-string', `
	<div class="input input-string">
		<label>{{label}}</label>
		
		<span class="value" [contentHTML]="value"></span>
		<div class="clear"></div>
	</div>
`);


EzTemplateLoader.addTemplate('ez-file', `
	<div class="input">
		<label>{{label}}</label>
		
		<input type="file" name="{{name}}" />
		
		<span class="error"></span>
	</div>
`);


EzTemplateLoader.addTemplate('ez-date', `
	<div class="input">
		<label>{{label}}</label>
		
		<input type="text" class="input-pickadate" name="{{name}}" placeholder="{{typeof placeholder != 'undefined'?placeholder:''}}" />
		
		<span class="error"></span>
		
		<script type="text/javascript">
		if (value) {
			if (typeof value == 'number' || value.match(/^\\d+$/)) {
				let d = new Date(value);
				value = format_date( d, {dmy: true});
			}
			
			if (value.match(/^\\d{4}-\\d{2}-\\d{2}$/)) {
				let v2 = format_date(value, {dmy: true});
				value = v2;
			}
			
			$(document.currentScript.parentNode).find('input.input-pickadate').val( value );
		}
		
		let ezContainer = document.currentScript.parentNode.parentNode;
		let oc = ezContainer.getAttribute('[onchange]');
		if (oc) {
			let func = ezContainer.eztemplate.getVarValue(oc);
			$(ezContainer).find('input.input-pickadate').on('change dp.change', (evt) => {
				if (evt.target.value == value) return;
				
				func(evt);
			});
		}
		</script>
		
	</div>
`);

EzTemplateLoader.addTemplate('ez-datetime', `
	<div class="input">
		<label>{{label}}</label>
		
		<div class="input-actions">
			<input type="text" class="input-pickadatetime" name="{{name}}" placeholder="{{typeof placeholder != 'undefined'?placeholder:''}}" />
			
			<div class="actions">
				<a class="btn-reset"><i class="fa fa-close"></i></a>
			</div>
		</div>
		
		<span class="error"></span>
		
		<script type="text/javascript">
		
		let showZero = typeof showzero != 'undefined' && isTrue(showzero);
		
		if (value) {
			if (typeof value == 'number' || value.match(/^\\d+$/)) {
				let d = new Date(value);
				value = format_datetime_minutes( d, {dmy: true, showZero: showZero});
			}
			
			if (value.match(/^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}$/)) {
				let v2 = format_datetime_minutes(value, { dmy: true, showZero: showZero });
				value = v2;
			}
			
			// set val
			let c = $(document.currentScript.parentNode);
			c.find('input.input-pickadatetime').val( value );
		}
		
		let ezContainer = document.currentScript.parentNode.parentNode;
		let oc = ezContainer.getAttribute('[onchange]');
		if (oc) {
			let func = ezContainer.eztemplate.getVarValue(oc);
			$(ezContainer).find('input.input-pickadatetime').on('change dp.change', (evt) => {
				func(evt);
			});
		}
		
		ezContainer.querySelector('.btn-reset').addEventListener('click', function() {
			this.parentNode.parentNode.querySelector('.input-pickadatetime').value='';
		});
		
		
		</script>
		
	</div>
`);


EzTemplateLoader.addTemplate('ez-datetime-text', `
	<div class="input">
		<label>{{label}}</label>
		
		<span class="datetime-text"></span>
		<script>
			let node = document.currentScript.parentNode;
			
			if (typeof hideempty != 'undefined' && hideempty && (!value || value == '')) {
				$(node).hide();
				return;
			}
			
			$(node).show();
			
			if (!value || value == '')
				value = '-';
			
			if (typeof value == 'number') {
				value = new Date(value);
				value = format_datetime( value, { dmy: true } );
			}
			
			node.querySelector('span.datetime-text').innerHTML = value;
		</script>
		
		<span class="error"></span>
	</div>
`);

EzTemplateLoader.addTemplate('ez-time', `
	<div class="input input-time">
		<label>{{label}}</label>
		
		<input type="time" id="{{name||slug}}" name="{{name||slug}}" value="{{value}}" />
		
		<span class="error"></span>
		
		
		<div class="clear"></div>
	</div>
`);


EzTemplateLoader.addTemplate('ez-radio', `
	<div class="input input-radio">
		<label>{{label}}</label>
		
		<span class="radio-container"></span>
		<div class="clear"></div>
		<script>
			let ezContainer = document.currentScript.parentNode.parentNode;
			let c = $(ezContainer);
			
			let ezTpl = c.get(0).ezTemplate;
			
			let opts = $(ezTpl.templateInnerHTML);
			
			for(let i=0; i < opts.length; i++) {
				let opt = opts.get(i);
				
				if ( opt.nodeName != 'OPTION')
					continue;
				
				let val = opt.value;
				val = ezTpl.expressionStringToValue( val  );
				
				let optText = $(opt).text();
				optText = ezTpl.expressionStringToValue( optText );
				let text = $.trim( optText );
				
				let l = $('<label><input type="radio" /> <span class="radio-label"></span></label>');
				l.find('input').val( val );
				l.find('input').attr( 'name', name );
				l.find('span').text( text );
				
				if (!value && i == 0) {
					l.find('input').prop('checked', true);
				}
				else if (value == val) {
					l.find('input').prop('checked', true);
				}
				
				
				$(ezContainer).find('span.radio-container').append( l );
			}
			
			if ( typeof options == 'string' ) {
				console.log(' options',  options );
				
				let lines = options.split(/\\n/);
				
				for(let i=0; i < lines.length; i++) {
					let line = lines[i].trim();
					if (line.length == 0) continue;
					
					let val;
					let text;
					if (line.indexOf(':') != -1) {
						val = line.substr(0, line.indexOf(':'));
						text = line.substr( val.length + 1 );
					}
					else {
						val = line;
						text = line;
					}
					
					let l = $('<label><input type="radio" /> <span class="radio-label"></span></label>');
					l.find('input').val( val );
					l.find('input').attr( 'name', name );
					l.find('span').text( text );
					
					if (typeof value != 'undefined') {
						if (!value && i == 0) {
							l.find('input').prop('checked', true);
						}
						else if (value && value == val) {
							l.find('input').prop('checked', true);
						}
					}
					
					
					$(ezContainer).find('span.radio-container').append( l );
				}
				
			}

		</script>
		
		<span class="error"></span>
	</div>
`);





EzTemplateLoader.addTemplate('ez-select', `
	<div class="input">
		<label>{{label}}</label>
		
		<select name="{{name}}"></select>
		<script>
			let ezContainer = document.currentScript.parentNode.parentNode;
			let ezTpl = document.currentScript.parentNode.parentNode.ezTemplate;
			
			if (typeof slug != 'undefined') {
				$(ezContainer).addClass('input-'+slug);
			}
			
			let slct = ezContainer.querySelector( 'select' );
			
			// set options
			if ( ezContainer.ezTemplate.templateInnerHTML ) {
				let html = ezTpl.expressionStringToValue( ezContainer.ezTemplate.templateInnerHTML );
				slct.innerHTML = html;
			}
			
			let defaultSelectedValue = null;
			
			// list options
			if (typeof options != 'undefined') {
				for(let i in options) {
					
					let text = options[i].value;
					if ( typeof options[i].description != 'undefined' )
						text = options[i].description;
					if ( typeof options[i].text!= 'undefined' )
						text = options[i].text;
					
					text = ezTpl.expressionStringToValue( text );
					
					let opt = document.createElement('option');
					opt.value     = options[i].value;
					opt.innerHTML = text;
					opt.item      = options[i];
					slct.appendChild( opt );
					
					if (options[i].defaultSelected)
						defaultSelectedValue = options[i].value;
				}
			}

			if (typeof value != 'undefined' && selectOptionExists(slct, value)) {
				slct.value = value;
			}
			else if (defaultSelectedValue !== null) {
				slct.value = defaultSelectedValue;
			}
			

			let oc = ezContainer.getAttribute('[onchange]');
			if (oc) {
				let val = ezContainer.eztemplate.getVarValue(oc)
				
				if (val)
					slct.addEventListener('change', val);
			}


			
		</script>
		
		<span class="error"></span>
	</div>
`);


EzTemplateLoader.addTemplate('ez-table-selector', `
	<div class="input">
		<label>{{label}}</label>
		
		<div class="ez-table-container"></div>
		
		<div class="clear"></div>
		
		<script>
			let ezContainer = document.currentScript.parentNode;
			
			let eztbl = new EzTableSelector( ezContainer.querySelector('.ez-table-container') );
			eztbl.setName( name );
			eztbl.setValueText( value, valuetext );
			eztbl.setUrl( url );
			eztbl.init();
		</script>
	</div>
`);

EzTemplateLoader.addTemplate('ez-pager', `
	<div class="pager">
	</div>
	<script>
		console.log('ez-pager...');
		
		if (typeof response == 'undefined')
			return;
		
		let container = document.currentScript.parentNode;
		
		let w = container.eztemplate.vars['widget'];
		
		
		let pageCount = Math.ceil( response.rowCount / response.pageSize );
		let pageNo = Math.floor( response.start / response.pageSize );
		
		if (pageCount == Infinity || isNaN(pageCount))
			return;
		if (pageNo == Infinity || isNaN(pageNo))
			return;
		
		if (pageNo > 0) {
			let a = $('<a class="pager-link" />');
			a.attr('href', 'javascript:void(0)');
			a.text( '<' );
			a.click(function() {
				w.selectPage( pageNo-1 );
			});
			$(container).find('.pager').append( a );
			$(container).find('.pager').append( ' ' );
		}
		
		if (pageCount > 100) {
			let s = $('<input type="number" name="s" min="1" />');
			s.attr('max', pageCount);
			s.val( pageNo+1 );
			
			s.change(function() {
				let p = parseInt(this.value)-1;
				w.selectPage( p );
			});
			
			$(container).find('.pager').append( s );
		}
		else if (pageCount > 10) {
			let s = $('<select />');
			
			for(let i=0; i < pageCount; i++) {
				let opt = $('<option />');
				opt.val( i );
				opt.text( i+1 );
				
				if (i == pageNo)
					opt.prop('selected', true );
				$(s).append(opt);
			}
			
			s.change(function() {
				w.selectPage( this.value );
			});
			
			$(container).find('.pager').append( s );
		}
		else {
			for(let i=0; i < pageCount; i++) {
				let a = $('<a class="pager-link" />');
				a.attr('href', 'javascript:void(0)');
				if (i == pageNo)
					a.text( '[' + (i+1) + ']' );
				else
					a.text( (i+1) );
				
				a.click(function() {
					w.selectPage( i );
				});
				
				$(container).find('.pager').append( a );
				$(container).find('.pager').append( ' ' );
			}
		}
		
		
		if (pageNo+1 < pageCount) {
			let a = $('<a class="pager-link" />');
			a.attr('href', 'javascript:void(0)');
			a.text( '>' );
			a.click(function() {
				w.selectPage( pageNo+1 );
			});
			$(container).find('.pager').append( a );
		}
		
	</script>
`);



EzTemplateLoader.addTemplate('tinymce-text', `
	<div class="input" [contentHTML]="text">
	</div>
`);


EzTemplateLoader.addTemplate('linechartv1', `
	<div class="input">
		<label></label>
		
		<canvas class="chart-widget"></canvas>
		
		<div class="clear"></div>
		
		<script>
			let ezContainer = document.currentScript.parentNode;
			
			loadDataAdapter( dataAdapterId ).then(async function(e) {
				let json = await e.json();
				let c = ezContainer.querySelector('.chart-widget');
				
				
				renderLinechartv1( c, json, {
					label: label,
					value: value,
					title: title
				});
			});
		</script>
	</div>
`);


EzTemplateLoader.addTemplate('ez-customer', `
    <div class="input customer-name">
            <label>{{ typeof label != 'undefined' ? label : 'Relatie' }}</label>

            <div class="ez-table-container"></div>

            <a href="javascript:void(0);" class="fa fa-plus btn-add" onclick="add_customer_popup(this);"></a>
            
            <a href="javascript:void(0);" class="fa fa-search btn-view" onclick="view_customer_popup(this);"></a>

            
            <div class="clear"></div>

            <script>
                    let ezContainer = document.currentScript.parentNode;

                    let eztbl = new EzTableSelector( ezContainer.querySelector('.ez-table-container') );
                    eztbl.setName( typeof name == 'undefined' ? '' : name );
                    eztbl.setValueText( (typeof value != 'undefined' ? value : ''), (typeof valuetext  != 'undefined' ? valuetext  : ''), {triggerChange: false} );
                    eztbl.setUrl( appUrl('/service/customers.do?a=tableSearch') );
                    eztbl.init();
					
					// id set, but valuetext not? => auto-lookup customer name
					if (typeof value != 'undefined' && value != '') {
						if (typeof valuetext == 'undefined' || valuetext == '') {
							// lookup customer name
							postUrl( '/service/customers.do', {
								a: 'view',
								customerId: value
							}).then(async (r) => {
								let json = await r.json();
								if (json.success) {
									eztbl.setValueText( json.customer.customerId, json.customer.customerName );
								}
							});
						}
					}
					
            </script>
    </div>
`);





EzTemplateLoader.addTemplate('ez-user', `
    <div class="input user-id">
            <label>{{ typeof label != 'undefined' ? label : _('User') }}</label>

            <div class="ez-table-container"></div>

            <div class="clear"></div>

            <script>
                    let ezContainer = document.currentScript.parentNode;

                    let eztbl = new EzTableSelector( ezContainer.querySelector('.ez-table-container') );
                    eztbl.setName( typeof name == 'undefined' ? '' : name );
                    eztbl.setValueText( (typeof value != 'undefined' ? value : ''), (typeof valuetext  != 'undefined' ? valuetext  : ''), {triggerChange: false} );
                    eztbl.setUrl( appUrl('/service/users.do?a=listUsers') );
                    eztbl.init();
					
					// id set, but valuetext not? => auto-lookup customer name
					if (typeof value != 'undefined' && value != '') {
						if (typeof valuetext == 'undefined' || valuetext == '') {
							// lookup customer name
							postUrl( '/service/users.do', {
								a: 'view',
								userId: value
							}).then(async (r) => {
								let json = await r.json();
								if (json.success) {
									eztbl.setValueText( json.user.userId, json.user.username );
								}
							});
						}
					}

            </script>
    </div>
`);



