


export class SlotplanWeekWidget {
	
	

	tpl = `
		<div class="slotplan-config-week" ez-for="weeks" ez-item="week">
		
			<div class="week-no week-{{week.weekno}}" weekno="{{week.weekno}}">
				<input type="checkbox" 
						id="week-no-{{week.weekno}}" 
						class="weeks-planned" 
						[checked]="{{week.active}}" />
				
				<label for="week-no-{{week.weekno}}" class="week-title">Week #{{ week.weekno }}</label>
				
				<ez-select name="week{{week.weekno}}-pricetype" 
							label="Prijstype" 
							[value]="week.slotplanPricetypeId"
							[options]="pricetypes"></ez-select>
			</div>

		</div>
	`;
	
	
	container = null;
	
	slotplan = null;
	
	weeks = {};
	pricetypes = [];
	
	
	constructor( slotplan, pricetypes ) {
		this.slotplan = slotplan;
		this.pricetypes = pricetypes;
	}
	
	getWeeks() {
		for(let i=1; i <= 53; i++) {
			let ptid = $('.slotplan-config-week').find('select[name=week'+i+'-pricetype]').val();
				
			let active = $('.slotplan-config-week').find('input#week-no-'+i).prop('checked') ? 1 : 0;
			
			this.weeks[i].slotplanPricetypeId = ptid;
			this.weeks[i].active = active;
		}
		
		return this.weeks;
	}
	
	init( e ) {
		this.container = e;
		
		// init weeks
		this.weeks = {};
		for(let i=1; i <= 53; i++) {
			this.weeks[i] = {
				weekno: i
			};
		}
		
		// set values
		if ( this.slotplan && this.slotplan.slotitemWeeks ) {
			for(let i in this.slotplan.slotitemWeeks) {
				let sid = this.slotplan.slotitemWeeks[i];
				
				if (sid.weekno >= 1 && sid.weekno <= 7)
					this.weeks[ sid.weekno ] = sid;
			}
		}
	}
	
	
	render() {
		let ht = new EzTemplate( this.container );
		ht.setObject('widget', this);
		ht.setVar('weeks', this.weeks);
		ht.setVar('pricetypes', this.pricetypes);
		ht.loadHtml( this.tpl );
		
		ht.render();
	}
	
	
	
	
}



