



export class SlotplanHourWidget {
	
	tplHour = `
		<div style="width: 640px;" ez-if="editMode">
			<div style="float: right;">
				<button [onclick]="widget.resetHours_Click">Reset</button>
			</div>
		</div>
		<span class="input-hours-in-day" ez-if="editMode">
			Uren in dag
			&nbsp;&nbsp;
			<ez-number name="startHour"
						label=""
						min="0"
						max="23"
						[onchange]="widget.startHour_Change"
						[value]="startHour"></ez-number>
			t/m
			<ez-number name="endHour"
						label=""
						min="0"
						max="23"
						[onchange]="widget.endHour_Change"
						[value]="endHour"></ez-number>
		</span>
		
		<div id="slotselection-status" ez-if="editMode">&nbsp;</div>
		
		<div class="slotplan-slotitem-container {{ editMode ? 'slotitem-editor' : 'slotitem-readonly' }}">
			<div id="slotplan-container">
				<div class="slotplan-hour-container">
					<div class="slotplan-hour-header">
						<div class="hour-entry-header">
							<div class="caption"></div>
							<div class="cell-1 {{css_mo_selected}}">
								Maandag
								<span class="day-date">{{mo_text}}</span>
							</div>
							<div class="cell-2 {{css_tu_selected}}">
								Dinsdag
								<span class="day-date">{{tu_text}}</span>
							</div>
							<div class="cell-3 {{css_we_selected}}">
								Woensdag
								<span class="day-date">{{we_text}}</span>
							</div>
							<div class="cell-4 {{css_th_selected}}">
								Donderdag
								<span class="day-date">{{th_text}}</span>
							</div>
							<div class="cell-5 {{css_fr_selected}}">
								Vrijdag
								<span class="day-date">{{fr_text}}</span>
							</div>
							<div class="cell-6 {{css_sa_selected}}">
								Zaterdag
								<span class="day-date">{{sa_text}}</span>
							</div>
							<div class="cell-7 {{css_su_selected}}">
								Zondag
								<span class="day-date">{{su_text}}</span>
							</div>
						</div>
					</div>
					<div class="slotplan-hour" ez-for="hours" ez-item="h">
						<div class="hour-entry hour-entry-{{h.hour}}" hour="{{h.hour}}">
							<div class="caption">{{ h.hour }}.00</div>
							<div class="hour-cell cell-1" dayno="1"></div>
							<div class="hour-cell cell-2" dayno="2"></div>
							<div class="hour-cell cell-3" dayno="3"></div>
							<div class="hour-cell cell-4" dayno="4"></div>
							<div class="hour-cell cell-5" dayno="5"></div>
							<div class="hour-cell cell-6" dayno="6"></div>
							<div class="hour-cell cell-7" dayno="7"></div>
						</div>
					</div>
				</div>
			</div>
			
			<div id="slotitem-hour-edit-container" class="hidden" ez-if="editMode">
				<h2>Slot bewerken</h2>
				
				<table>
					<tr>
						<th><label for="si-day si-day-1">Ma</label></th>
						<th><label for="si-day si-day-2">Di</label></th>
						<th><label for="si-day si-day-3">Wo</label></th>
						<th><label for="si-day si-day-4">Do</label></th>
						<th><label for="si-day si-day-5">Vr</label></th>
						<th><label for="si-day si-day-6">Za</label></th>
						<th><label for="si-day si-day-7">Zo</label></th>
					</tr>
					<tr>
						<td><input type="checkbox" class="si-day" id="si-day-1" /></td>
						<td><input type="checkbox" class="si-day" id="si-day-2" /></td>
						<td><input type="checkbox" class="si-day" id="si-day-3" /></td>
						<td><input type="checkbox" class="si-day" id="si-day-4" /></td>
						<td><input type="checkbox" class="si-day" id="si-day-5" /></td>
						<td><input type="checkbox" class="si-day" id="si-day-6" /></td>
						<td><input type="checkbox" class="si-day" id="si-day-7" /></td>
					</tr>
				</table>
				
				<ez-time name="startTime" label="Starttijd" value=""></ez-time>
				
				<ez-number name="duration" min="5" name="duration" label="Duur"></ez-number>
				
				<ez-select name="pricetypeId" label="Prijstype" value="" [options]="pricetypes"></ez-select>
				
				
				<div style="margin-top: 20px;">
					<input type="button" class="btn-si-cancel" [onclick]="widget.cancelHourEdit" value="Annuleer" />
					<input type="button" class="btn-si-delete" [onclick]="widget.deleteHourEdit" value="Delete" />
					<input type="button" class="btn-si-save"   [onclick]="widget.saveHourEdit"   value="Opslaan" />
				</div>
			</div>
		</div>
		
		<div id="slotitem-records"></div>
	`;
	

	date = null;
	callbackSlotSelection = null;
	
	container = null;
	
	slotplan = null;
	
	editMode = true;
	
	startHour   = 0;
	endHour     = 23;
	minuteJumps = 15;
	
	pricetypes;
	hourSlots = null;
	
	uniqueIdCounter = 1;
	uniqueId = () => { return this.uniqueIdCounter++; };
	
	article=null;
	
	constructor( slotplan ) {
		this.slotplan = slotplan;
		
		if (slotplan) {
			if (slotplan.startHour)
				this.startHour = slotplan.startHour;
			if (slotplan.endHour)
				this.endHour   = slotplan.endHour;
		}
	}
	
	setEditMode( bln ) { this.editMode = bln; }
	setDate( d ) { this.date = d; }
	setArticle(art) { this.article = art; }
	
	getSelectedSlots() {
		let slots = [];
		
		$('.slotplan-slotitem-container .slotitem-selected').each((index, node) => {
			let slotitem = $(node).data('slotitem');
			
			let slotplanPrice = this.getSlotplanPrice( slotitem.slotplanPricetypeId );
			
			let dayno = $(node).data('dayno');
			let hour = $(node).data('hour');
			let minute  = $(node).data('minute');
			let duration = $(node).data('duration');
			
			let date = start_of_week( this.date );
			if (dayno > 1)
				date = next_day(date, dayno-1);
			
			let start = str2date( date );
			start.setHours( hour );
			start.setMinutes( minute );
			start.setSeconds(  0 );
			
			let end = new Date( start.getTime() );
			end.setMinutes( end.getMinutes() + duration );
			
			slots.push({
				start: start,
				end: end,
				priceExclVat: slotplanPrice && slotplanPrice.priceExclVat ? slotplanPrice.priceExclVat : 0,
				priceInclVat: slotplanPrice && slotplanPrice.priceInclVat ? slotplanPrice.priceInclVat : 0,
			});
		});
		
		return slots;
	}
	
	
	getSlotplanPrice( slotplanPricetypeId ) {
		for(let i in this.article.slotplanPrices) {
			let sp = this.article.slotplanPrices[i];
			
			if (sp.slotplanPricetypeId == slotplanPricetypeId) {
				return sp;
			}
		}
		return null;
	}
	
	
	init( e ) {
		this.container = e;

		// set hourSlots
		this.hourSlots = [];
		for(let i in this.slotplan.slotitemHours) {
			let si = this.slotplan.slotitemHours[i];
			
			si.id = 'si-' + this.uniqueId();
			
			let toks       = si.startTime.split(':');
			si.hour        = parseInt(toks[0]);
			si.minute      = parseInt(toks[1]);
			si.pricetypeId = si.slotplanPricetypeId;
			
			this.hourSlots.push( si );
		}
	}
	
	dayText( date ) {
		let d = str2date( date );
		
		let t = d.getDate();
		t += ' ';
		t += _('monthshort.'+ (d.getMonth()+1));
		
		return t;
	}
	
	
	render() {
		$('.fieldset-slotplanning').show();
		$('.input-hours-in-day').css('display', 'flex');
		
		// build hour list
		let hours = [];
		for(let i=0; i <= 23; i++) {
			hours.push({
				hour: i
			});
		}
		
		
		let ht = new EzTemplate( this.container );
		ht.loadHtml( this.tplHour );
		ht.setObject('widget', this);
		ht.setVar('startHour', this.startHour);
		ht.setVar('endHour', this.endHour);
		ht.setVar('editMode', this.editMode);
		ht.setVar('hours', hours);

		// init vars to empty by default
		ht.setVar('css_mo_selected', '');
		ht.setVar('css_tu_selected', '');
		ht.setVar('css_we_selected', '');
		ht.setVar('css_th_selected', '');
		ht.setVar('css_fr_selected', '');
		ht.setVar('css_sa_selected', '');
		ht.setVar('css_su_selected', '');
		
		ht.setVar('mo_text', '');
		ht.setVar('tu_text', '');
		ht.setVar('we_text', '');
		ht.setVar('th_text', '');
		ht.setVar('fr_text', '');
		ht.setVar('sa_text', '');
		ht.setVar('su_text', '');
		
		if (this.date) {
			let sow = start_of_week( this.date );
			
			let ymd = date2ymd( this.date );
			if ( ymd == date2ymd(sow) )              ht.setVar('css_mo_selected', 'selected');
			if ( ymd == date2ymd(next_day(sow, 1)) ) ht.setVar('css_tu_selected', 'selected');
			if ( ymd == date2ymd(next_day(sow, 2)) ) ht.setVar('css_we_selected', 'selected');
			if ( ymd == date2ymd(next_day(sow, 3)) ) ht.setVar('css_th_selected', 'selected');
			if ( ymd == date2ymd(next_day(sow, 4)) ) ht.setVar('css_fr_selected', 'selected');
			if ( ymd == date2ymd(next_day(sow, 5)) ) ht.setVar('css_sa_selected', 'selected');
			if ( ymd == date2ymd(next_day(sow, 6)) ) ht.setVar('css_su_selected', 'selected');
			
			
			ht.setVar('mo_text', this.dayText( sow ));
			ht.setVar('tu_text', this.dayText( next_day(sow, 1) ));
			ht.setVar('we_text', this.dayText( next_day(sow, 2) ));
			ht.setVar('th_text', this.dayText( next_day(sow, 3) ));
			ht.setVar('fr_text', this.dayText( next_day(sow, 4) ));
			ht.setVar('sa_text', this.dayText( next_day(sow, 5) ));
			ht.setVar('su_text', this.dayText( next_day(sow, 6) ));
		}
		
		
		
//		console.log(this.pricetypes);
		
		ht.setVar('pricetypes', this.pricetypes);
		ht.render();
		

		$( this.container ).find('input[type=checkbox], input[type=number], input[type=text], input[type=time]').on('change dp.change', () => {
			this.slotEditChange();
		});
		
		this.updateHoursHourplan();
	}
	
	
	getHourSlots() { return this.hourSlots; }
	
	
	resetHours_Click() {
		this.cancelHourEdit();
		
		this.hourSlots = [];
		this.renderHourSlots();
	}
	
	startHour_Change() {
		this.startHour = $('input[name=startHour]').val();
		this.updateHoursHourplan();
	}
	endHour_Change() {
		this.endHour = $('input[name=endHour]').val();
		this.updateHoursHourplan();
	}
	
	getStartHour() {
		let minHour = this.startHour;
		minHour = parseInt(minHour);
		if (isNaN(minHour) || minHour < 0 || minHour >= 24) minHour = 0;
		return minHour;
	}
	getEndHour() {
		let maxHour = this.endHour;
		maxHour = parseInt(maxHour);
		if (isNaN(maxHour) || maxHour < 0 || maxHour >= 24) maxHour = 0;
		return maxHour;
	}
	
	updateHoursHourplan() {
		let startHour = this.getStartHour();
		let endHour = this.getEndHour();
		
		for(let i=0; i < 24; i++) {
			if (i < startHour || i > endHour)
				$('.slotplan-hour .hour-entry-'+i).hide();
			else
				$('.slotplan-hour .hour-entry-'+i).show();
		}
		
		this.renderHourSlots();
		
		
		if (this.editMode) {
			$('.slotplan-hour').on('mousemove', ( evt ) => {
				this.renderSampleHour( evt );
			});
			
			$(document).on('mousemove', (evt) => {
				let removeSample = true;
				
				if ( $(evt.target).closest('#slotplan-container').length > 0 )
					removeSample = false;
				if ( $(evt.target).closest('.hour-entry-header').length > 0 )
					removeSample = true;
				
				if (removeSample)
					$('.slotitem-sample').remove();
			});
		}
		
	}
	
	
	editorOpen() {
		if ( $('#slotitem-hour-edit-container').hasClass('hidden') == false ) {
			return true;
		}
		else {
			return false;
		}
	}
	
	
	renderSampleHour(evt) {
		// settings window visible? => dont render sample
		if ( this.editorOpen() )
			return;
		
		let t = $(evt.target);
		
		
		if ( $(t).hasClass('hour-cell') ) {
//			console.log('jow2');
			let dayno = parseInt( $(t).attr('dayno') );
			if (isNaN(dayno)) return;
			
			let hour = parseInt( $(t).closest('.hour-entry').attr('hour') );
			if (isNaN(hour)) return;
			
			
			let hourCell = null;
			if ( $(evt.target).hasClass('hour-cell') ) {
				hourCell = $(evt.target);
			}
			else if ( $(evt.target).closest('.hour-cell') ) {
				hourCell = $(evt.target).closest('.hour-cell');
			}
			if (hourCell == null || hourCell.length == 0)
				return;
			
			
			let top = hourCell.offset().top - window.scrollY;
			let offsetY = (evt.clientY - top);
//			console.log(offsetY);
			
			let minPos = parseInt( 60 / $(evt.target).height() * offsetY );
			minPos -= 3;//(this.minuteJumps/2);
			if (this.minuteJumps)
				minPos = minPos - (minPos%this.minuteJumps);
			if ( minPos >= 60 ) minPos = 45;
			
			this.renderHourSlot({
				id:       'sample',
				days:     [ dayno ],
				hour:     hour,
				minute:   minPos,
				duration: this.minuteJumps
			})
		}
		else {
			this.removeHourSlot( 'sample' );
		}
	}
	
	renderEditHour() {
		let si = this.slotHourEditToObject( this.slotitemHour );
		
		this.slotitemHour = si;
		
		this.renderHourSlot( this.slotitemHour );
	}
	
	renderHourSlots() {
		$('.slotplan-hour-container .slotitem').remove();
		
		for(let i in this.hourSlots) {
			let hs = this.hourSlots[i];
			
			this.renderHourSlot( hs );
		}
		
	}
	
	renderHourSlot( opts ) {
		$('.slotplan-hour-container').find('.slotitem-sample').remove();
		
		// remove old
		let slotitems = $('.slotplan-hour-container').find('.slotitem-'+opts.id);
		slotitems.remove();
		
		for(let i in opts.days) {
			let dayno = opts.days[i];
			
			let slotitem = $('<div class="slotitem" />');
			
			// click handling
			slotitem.click((evt) => {
				this.slotitem_Click( evt, evt.target );
			});
			
			
			slotitem.addClass( 'slotitem-' + opts.id );
			
			if (opts.id == 'sample') {
				slotitem.addClass('slotitem-sample');
			}
			else {
				slotitem.on('mouseover', () => {
					$('.slotitem-sample').remove();
				});
			}
			
			slotitem.data('slotitem', opts);
			
			slotitem.data('id', opts.id);
			slotitem.data('dayno', dayno);
			slotitem.data('hour', opts.hour);
			slotitem.data('minute', opts.minute);
			slotitem.data('duration', opts.duration);
			
			slotitem.css('left', 80 * dayno);
			
			let cellHeight = $('.slotplan-hour-container .hour-entry-'+this.getStartHour()+' .hour-cell').outerHeight()+1;
			
			let top = $('.slotplan-hour-header').outerHeight() + (( opts.hour - this.getStartHour() ) * cellHeight);
			if (opts.minute) {
				top += (cellHeight / 60 * opts.minute);
			}
			
			slotitem.css('top', top);
			
//			if (opts.id == 'sample') {
//				slotitem.css('height', 2);
//			}
//			else {
				let height = opts.duration / 60 * cellHeight;
				slotitem.css('height', height);
//			}
			
			slotitem.on('click', function(evt) {
				this.slotHourClick( evt.target );
			}.bind(this));
			
			
//			console.log('adding slot thing');
			$('.slotplan-hour-container').append( slotitem );
		}
		$('#slotselection-status').text( _('dayno.' + opts.days[0]) + ' ' + format_time(opts.hour, opts.minute) );
	}
	
	removeHourSlot( id ) {
		let slotitems = $('.slotplan-hour-container .slotitem');
		for(let i=0; i < slotitems.length; i++) {
			let si = $( slotitems.get(i) );
			
			if (si.data('id') == id) {
				si.remove();
			}
		}
	}
	
	slotHourClick(slotitem) {
		
		if (this.callbackSlotSelection) {
			this.callbackSlotSelection(slotitem);
		}
		
		
		if (this.editMode == false)
			return;
		
		
		// settings window visible? => dont render sample
		if ( this.editorOpen() )
			return;
		
		slotitem = $(slotitem);
		
		if (slotitem.hasClass('slotitem-sample') == false) {
			$('.slotitem-sample').remove();
		}
		
		this.slotitemHour = slotitem.data('slotitem');
		console.log( this.slotitemHour );
		
		let c = $('#slotitem-hour-edit-container');
		
		let newItem = false;
		if (slotitem.data('id') == 'sample') {
			newItem = true;
			
			this.slotitemHour.id = 'si-' + String(this.uniqueId());
			this.slotitemHour.newItem = true;
		}
		
		// show & set Slot-edit window
		c.removeClass('hidden');
		c.find('.si-day').prop('checked', false);
		if (this.slotitemHour.days) for(let i in this.slotitemHour.days) {
			c.find('#si-day-' + this.slotitemHour.days[i]).prop('checked', true);
		}
		c.find('input[name=startTime]').val( format_time(slotitem.data('hour'), slotitem.data('minute')) );
		c.find('input[name=duration]').val( slotitem.data('duration') );
		
		if (this.slotitemHour.pricetypeId) {
			c.find('select[name=pricetypeId]').val( this.slotitemHour.pricetypeId );
		}
		
		
		
		if (newItem) {
//			this.hourSlots.push( this.slotitemHour );
//			this.renderHourSlot( this.slotitemHour );
		}
		
		this.renderEditHour();
	}
	
	
	slotHourEditToObject( opts ) {
		opts = opts ? opts : {};
		if (!opts.id)
			opts.id = 'si-' + this.uniqueId();
		
		let c = $('#slotitem-hour-edit-container');
		
		let si = {};
		si.id = opts.id;
		si.days = [];
		
		si.startTime = $('input[name=startTime]').val();
		
		let toks = si.startTime.split(':');
		si.hour = parseInt(toks[0]);
		if (isNaN(si.hour) || si.hour < 0 || si.hour > 23)
			si.hour = 8;
		
		si.minute = parseInt(toks[1]);
		if (isNaN(si.minute) || si.minute < 0 || si.minute > 60)
			si.minute = 0;
		
		si.duration = parseInt( $('input[name=duration]').val() );
		if (isNaN(si.duration) || si.duration < 0)
			si.duration = 30;
		
		
		si.pricetypeId = $('select[name=pricetypeId]').val();
		
		// set days
		for(let i=1; i <= 7; i++) {
			if ( c.find('#si-day-'+i).prop('checked') ) {
				si.days.push( i );
			}
		}
		
		return si;
	}
	
	slotEditChange() {
		let si = this.slotHourEditToObject( this.slotitemHour );
		
		console.log('jow', si);
		
		this.renderHourSlot(si);
		this.renderEditHour();
	}
	
	
	slotitem_Click( evt, div ) {
		if (this.editMode == false) {
			$(div).toggleClass('slotitem-selected');
		}
	}
	
	hideHourEdit() {
		$('#slotitem-hour-edit-container').addClass( 'hidden' );
		
		this.renderHourSlots();
	}
	
	cancelHourEdit() {
		if (this.slotitemHour && this.slotitemHour.newItem) {
			this.slotitemHour = null;
		}
		
		this.hideHourEdit();
	}
	
	deleteHourEdit() {
		
		if ( ! this.slotitemHour )
			this.hideHourEdit();
		
		let newList = [];
		
		for(let i in this.hourSlots) {
			if (this.hourSlots[i].id != this.slotitemHour.id)
				newList.push( this.hourSlots[i] );
		}
		
		
		this.hourSlots = newList;
		this.renderHourSlots();
		
		this.hideHourEdit();
	}
	
	updateHourSlotsEntry( slotitem ) {
		let found = false;
		for(let i in this.hourSlots) {
			if (this.hourSlots[i].id == slotitem.id) {
				this.hourSlots[i] = slotitem;
				found = true;
				break;
			}
		}
		
		if ( found == false ) {
			this.hourSlots.push( slotitem );
		}
	}
	
	saveHourEdit() {
		let s = this.slotHourEditToObject( this.slotitemHour );
//		console.log('save', s);
		
		let errors = [];
		if (s.days.length == 0) {
			errors.push('Geen dag gekozen');
		}
		if (s.duration <= 0) {
			errors.push('Ongeldige duur');
		}
		
		if (errors.length) {
			alert('Error: ' + errors.join(','));
			return;
		}
		
		this.updateHourSlotsEntry( s );
		
//		console.log( this.hourSlots );
		
		$('#slotitem-hour-edit-container').addClass('hidden');
		this.renderHourSlots();
	}
		
	
	
}

