

import { SlotplanHourWidget }  from './slotplan/SlotplanHourWidget.js'; 
import { SlotplanDayWidget }   from './slotplan/SlotplanDayWidget.js';
import { SlotplanWeekWidget }  from './slotplan/SlotplanWeekWidget.js';
import { SlotplanMonthWidget } from './slotplan/SlotplanMonthWidget.js';



export class SlotplanConfigWidget {
	
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/sales/slotplan/')}}" class="fa fa-chevron-circle-left"></a>
				<span ez-if="isNew == false">
					<a href="javascript:void(0);" [onclick]="widget.deleteSlotplan" class="fa fa-trash"></a>
				</span>
				<a href="javascript:void(0);" [onclick]="widget.saveSlotplan" class="fa fa-save"></a>
			</div>
			
			<h1>Slot plan aanmaken</h1>
		</div>
		
		<fieldset class="base-settings">
			<legend>Instellingen</legend>
			
			<div style="display: flex;">
				<ez-text name="name" label="Naam" [value]="slotplan.name" ></ez-text>
				
				&nbsp;&nbsp;
				
				<ez-select name="defaultSlotType" label="Slot type" [value]="slotplan.defaultSlotType">
					<option value="hour">Uur</option>
					<option value="day">Dag</option>
					<!--
					<option value="week">Week</option>
					<option value="month">Maand</option>
					-->
				</ez-select>
				
			</div>
		</fieldset>
		
		<hr/>
		
		<fieldset class="fieldset-slotplanning">
			<legend>Slotplanning</legend>
			
			<div id="planning-container"></div>
			
		</fieldset>
	`;
	
	
	tplWeek = `
		<div>
			<ez-select name="pricetypeIdWeek" label="Prijstype" [value]="slotplan.pricetypeIdWeek" [options]="pricetypes"></ez-select>
		</div>
	`;
	
	tplMonth = `
		<div>
			<ez-select name="pricetypeIdMonth" label="Prijstype" [value]="slotplan.pricetypeIdMonth" [options]="pricetypes"></ez-select>
		</div>
	`;
	
	slotIdCounter = 1;
	
	container = null;
	ezTpl = null;
	isNew = true;
	
	pricetypes = null;
	
	
	slotplanId = null;
	slotplan = {
		name: ''
	};
	
	
	hourWidget = null;
	dayWidget = null;
	
	
	init(e) {
		this.container = e;
		
		this.slotplanId = getUrlParam( 'id' );
		
		this.loadBaseData();
	}
	
	loadBaseData() {
		postUrl('/service/sales/slot/config.do', {
			a: 'baseData'
		}).then( async (e) => {
			let json = await e.json();
			
			// set pricetypes
			this.pricetypes = [];
			for(let i in json.pricetypes) {
				let pt = json.pricetypes[i];
				this.pricetypes.push({
					value: pt.slotplanPricetypeId,
					text: pt.name
				});
			}
			
			
			if (this.slotplanId) {
				this.isNew = false;
				this.loadSlotplan( this.slotplanId );
			}
			else {
				this.render();
			}
		});
	}
	
	
	
	loadSlotplan( id ) {
		
		postUrl('/service/sales/slot/config.do', {
			a: 'view',
			slotplanId: id
		}).then( async (e) => {
			let json = await e.json();
			
			this.slotplan = json.slotplan;
			
			this.render();
		});
		
	}
	
	
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('isNew', this.isNew);
		this.ezTpl.setVar('slotplan', this.slotplan);
		this.ezTpl.setObject('widget', this);
		
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		$('ez-select select[name=defaultSlotType]').on('change', () => {
			this.updateSlotplanning();
		});
		
		this.updateSlotplanning();
	}
	
	
	uniqueId = () => {
		return this.slotIdCounter++;
	};
	
	
	updateSlotplanning() {
		let slottype = $('select[name=defaultSlotType] option:selected').get(0).value;
		console.log('slottype', slottype);
		
		$('.input-hours-in-day').hide();
		$('.fieldset-slotplanning').show();
		
		if (slottype == 'hour') {
			this.renderHourPlan();
		}
		else if (slottype == 'day') {
			this.renderDayPlan();
		}
		// week
		else if (slottype == 'week') {
			this.renderWeekPlan();
		}
		// month
		else if (slottype == 'month') {
			this.renderMonthPlan();
		}
		else {
			$('.fieldset-slotplanning').hide();
		}
	}
	
	
	renderHourPlan() {
		if (this.hourWidget == null) {
			this.hourWidget = new SlotplanHourWidget( this.slotplan );
			
			this.hourWidget.uniqueId   = this.uniqueId;		// callback function
			this.hourWidget.pricetypes = this.pricetypes;
			
			this.hourWidget.init( '#planning-container' );
		}
		
		this.hourWidget.render();
	}
	
	
	renderDayPlan() {
		if (this.dayWidget == null) {
			this.dayWidget = new SlotplanDayWidget( this.slotplan, this.pricetypes );
			this.dayWidget.init( '#planning-container' );
		}
		
		this.dayWidget.render();
	}
	
	renderWeekPlan() {
		if (this.weekWidget == null) {
			this.weekWidget = new SlotplanWeekWidget( this.slotplan, this.pricetypes );
			this.weekWidget.init( '#planning-container' );
		}

		this.weekWidget.render();
	}
	
	renderMonthPlan() {
		if (this.monthWidget == null) {
			this.monthWidget = new SlotplanMonthWidget( this.slotplan, this.pricetypes );
			this.monthWidget.init( '#planning-container' );
		}

		this.monthWidget.render();
	}
	
	
	
	
	
	
	saveSlotplan() {
		
		let d = {};
		d.a = 'saveSlotplan';
		
		
		let base = $('.base-settings');
		if (this.slotplan.slotplanId)
			d.slotplanId = this.slotplan.slotplanId;
		d.name            = base.find('input[name=name]').val();
		d.defaultSlotType = base.find('select[name=defaultSlotType]').val();
		
		// Edit hour slot open? => save..
		if ($('select[name=defaultSlotType] option:selected').val() == 'hour' && $('#slotitem-hour-edit-container').hasClass('hidden') == false) {
			this.hourWidget.saveHourEdit();
		}
		
		
		// slotitems hours
		if (this.hourWidget) {
			d.startHour = this.hourWidget.getStartHour();
			d.endHour   = this.hourWidget.getEndHour();
			d.hourSlots = this.hourWidget.getHourSlots();
		}
		
		
		// slotitem days
		if (this.dayWidget) {
			d.days = this.dayWidget.getDays();
		}
		
		if (this.weekWidget) {
			d.weeks = this.weekWidget.getWeeks();
		}
		
		if (this.monthWidget) {
			d.months = this.monthWidget.getMonths();
		}
				
		
//		if ( $('select[name=defaultSlotType]').val() == 'week' ) {
//			d.pricetypeIdWeek = $('select[name=pricetypeIdWeek]').val();
//		}
//		if ( $('select[name=defaultSlotType]').val() == 'month' ) {
//			d.pricetypeIdMonth = $('select[name=pricetypeIdMonth]').val();
//		}
		
		
		showLoadingForm( '.base-settings' );
		
		postJson( '/service/sales/slot/config.do', d)
		.then(async (e) => {
			let json = await e.json();
			
			reportUserMessage( 'Wijzigingen opgeslagen' );
			gotoRoute( '/masterdata/sales/slotplan/config/?id='+json.slotplanId );
		});
		
	}
		
	
	deleteSlotplan() {
		showConfirmation('Verwijderen', 'Weet je zeker dat je deze planning wilt verwijderen?', () => {
			
			postUrl('/service/sales/slot/config.do', {
				a: 'deleteSlotplan',
				slotplanId: this.slotplan.slotplanId
			}).then( (e) => {
				gotoRoute( '/masterdata/sales/slotplan/' );
			});
			
		});
	}
	
	
	
}


