


export class SalesRentalCheckoutPreviewWidget {
	
	
	
	tpl = `
		<div class="checkout-preview-widget">
			
			<div ez-if="articles.length == 0">
				Kies een artikel
			</div>
			
			<div ez-for="bundledArticles" ez-item="ba">
				<div>
					{{ ba.article.shortDescription }}
					
					<div ez-for="ba.prices" ez-item="bap">
						<div class="price-moment">
							<span class="price">{{ bap.price }}</span>
							<span class="moment">{{ bap.moment }}</span>
							<span class="fa fa-remove remove-article" [bap]="bap" [onclick]="widget.removeArticle"></span>
						</div>
						
					</div>
				</div>
			</div>
			
			
			<div class="" ez-if="articles.length > 0">
				<button [onclick]="widget.reset">Reset</button>
				<button [onclick]="widget.checkout">Reserveren</button>
			</div>
		</div>
	`;
	
	
	ezTpl = null;
	
	container = null;
	
	rentalContracts = [];
	
	articles = [];
	
	callback_removeArticle = null;
	
	callback_reset = null;
	callback_checkout = null;
	
	
	init(c) {
		this.container = c;
	}
	
	
	setCallbackRemoveArticle( callback ) { this.callback_removeArticle = callback; }
	
	setCallbackReset( callback ) { this.callback_reset = callback; }
	setCallbackCheckout( callback ) { this.callback_checkout = callback; }
	
	
	lookupPrice( a ) {
		
		if ( typeof a.slotitemHour != 'undefined' ) {
			let spid = a.slotitemHour.slotplanPricetypeId;
			for(let i in a.article.slotplanPrices) {
				if (a.article.slotplanPrices[i].slotplanPricetypeId == spid) {
					let sp = a.article.slotplanPrices[i];
					return sp.displayPrice;// + ' ('+a.slotitemHour.startTime+', '+a.slotitemHour.duration+'min.)';
				}
			}
		}
		else {
			return a.article.displayPrice;
		}
		
		return '-';
	}
	
	setArticles( arts ) {
		this.articles = arts;
	}
	
	loadPrices() {
	}
	
	
	bundledArticles() {
		
		let articles = {};
		
		for(let i in this.articles) {
			let art = this.articles[i];
			
			let aid = art.article.articleId;
			
			let ymd = format_date( new Date(art.day.date) );
			
			if (!articles[aid]) {
				articles[aid] = {};
				
				articles[aid].article = art.article;
				articles[aid].prices = [];
			}
			
			let price;
			
			if (art.slotitemHour) {
				price = {
					moment: format_date(new Date(art.day.date), {dmy:true}) + " - " + art.slotitemHour.startTime + ', ' + art.slotitemHour.duration + ' min.',
					price: this.lookupPrice( art ),
					sort: art.day.date + art.slotitemHour.startTime
				};
			 }
			 else {
				price = {
					moment: format_date(new Date(art.day.date), {dmy:true}),
					price: this.lookupPrice( art ),
					sort: art.day.date
				};
			 }
			 
			 price.article = art;
			 
			 articles[aid].prices.push( price )
		}
		
		for(let i in articles) {
			articles[i].prices = articles[i].prices.sort(function(f1, f2) {
				if ( f1.sort < f2.sort ) {
					return -1;
				}
				else {
					return 1;
				}
			});
		}
		
		
		return articles;
	}
	
	book() {
		alert('joxw');
	}
	
	
	reset() {
		this.callback_reset();
	}
	
	checkout() {
		this.callback_checkout();
	}
	
	
	removeArticle( evt ) {
		let bap = evt.currentTarget.bap;
		
		this.callback_removeArticle( bap.article );
	}
	
	
	render() {
		
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setVar('articles', this.articles);
		this.ezTpl.setVar('bundledArticles', this.bundledArticles());
		this.ezTpl.setObject('widget', this);
		this.ezTpl.render();
		
//		console.log('bundledArticles', this.bundledArticles());
		
	}
}


