

export class SalesPlanWeekWidget {
	
	tpl = `
	
	<div class="spw">
		
		<div class="weekno-list">
			<div class="article-name-placeholder"></div>
			<div class="weekno-list-items" ez-for="weekList" ez-item="w">
				<div class="weekno" [onclick]="widget.weekClick">{{w.weekno}}</div>
			</div>
		</div>
		
		
		<div ez-if="articles.length == 0" class="no-results">
			Geen resultaten gevonden
		</div>
		<div ez-for="articles" ez-item="art">
			<div class="article">
				<div class="article-name">
					{{art.shortDescription}}
				</div>
				<div class="weekno-week-items" ez-for="weekList" ez-item="w">
					<div class="week-item">..</div>
				</div>
			</div>
		</div>

	</div>
	
	
	`;
	
	container = null;
	
	ezTpl = null;
	
	weekList = [];
	articles = [];
	year = null;
	
	
	constructor() {
		
	}
	
	
	init(c) {
		this.container = c;
	}
	
	
	setYear(no) { this.year = parseInt(no); }
	
	setArticles(arts) { this.articles = arts; }
	
	
	buildWeeks() {
		let weeks = weeks_in_year( this.year );
		
		this.weekList = [];
		for( let wno = 1; wno <= weeks; wno++ ) {
			
			this.weekList.push({
				year: this.year,
				weekno: wno
			});
		}
	}
	
	weekClick(evt) {
		console.log(evt);
	}
	
	
	render() {
		this.buildWeeks();
		
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('weekList', this.weekList);
		this.ezTpl.setVar('articles', this.articles);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		
		this.ezTpl.render();
		
	}
	
	
}

