

import { SalesCheckoutArticlesWidget } from './checkout/SalesCheckoutArticlesWidget.js';
import { SalesCheckoutCustomerWidget } from './checkout/SalesCheckoutCustomerWidget.js';
import { SalesCheckoutOverviewWidget } from './checkout/SalesCheckoutOverviewWidget.js';
import { SalesArticle } from '../lib/SalesArticle.js';


/**
 * 
 * SalesCheckoutWidget - controller handling checkout flow
 * 
 */
export class SalesCheckoutWidget {
	
	
	
	tpl = `
	`;
	
	
	container = null;
	
	
	ezTpl = null;
	uid = null;
	session = null;
	
	articlesWidget = null;
	customerWidget = null;
	overviewWidget = null;
	
	constructor() {
				

	}
	
	init(c) {
		this.container = c;
		
		this.uid = getUrlParam('uid');
		this.session = getSession('co_' + this.uid);
		if ( this.session == null ) {
			reportUserMessage( 'Checkout session not found' );
			gotoRoute( '/sales/salesplan/' );
			return;
		}
		
		
		// render widget
		let path = getPathPart(3);
		if (path == null || path == 'articles') {
			this.renderArticles();
		}
		else if (path == 'customer') {
			this.renderCustomer();
		}
		else if (path == 'overview') {
			this.renderOverview();
		}
		
		
	}
	
	
	renderArticles() {
		if (this.articlesWidget == null) {
			this.articlesWidget = new SalesCheckoutArticlesWidget( this );
			this.articlesWidget.init( this.container );
			
			this.articlesWidget.setCallbackSelectCustomer(function() {
				gotoRoute( '/sales/salesplan/checkout/customer/?uid=' + this.uid);
			}.bind(this));
		}
		
		this.articlesWidget.render();
	}
	
	renderCustomer() {
		if (this.customerWidget == null) {
			this.customerWidget = new SalesCheckoutCustomerWidget( this );
			this.customerWidget.init( this.container );
		}
		
		this.customerWidget.render();
	}
	
	renderOverview() {
		if (this.overviewWidget == null) {
			this.overviewWidget = new SalesCheckoutOverviewWidget( this );
			this.overviewWidget.init( this.container );
		}
		
		this.overviewWidget.render();
	}
}



