
import { getSalesSettings, getVats } from './../RentalConstants.js';


export class ContractPriceLineForm {
	
	
	tpl = `
		<div class="contract-article-line-form">
			<ez-text name="lineDescription"
						label="{{_('Description')}}"
						[value]="line.lineDescription"></ez-text>
			
			<ez-number label="{{_('Number')}}"
						name="number"
						step="1"
						min="1"
						[value]="line.number"></ez-number>
			
			<ez-select label="{{_('Vat')}}"
						name="vatId"
						[options]="vats"></ez-select>
			
			<ez-price label="Price {{priceVat}}"
						name="price"
						[value]="price"></ez-price>
			
			
			<div style="margin-top: 25px;">
				<button [onclick]="widget.cancel">{{_('Cancel')}}</button>
				<button [onclick]="widget.save">{{isNew?_('Add'):_('Save')}}</button>
			</div
		</div>

	`;
	
	
	container = null;
	line = null;
	
	vats = null;
	salesSettings = null;

	callbackCancel = null;
	callbackSave = null;
	
	isNew = true;
	
	constructor( container, line ) {
		this.container = container;
		
		this.isNew = line?.isNew ? true : false;
		
		this.line = line;
	}
	
	
	
	init(e) {
		this.container = e;
	}
	
	
	setCancelCallback( callback ) {
		this.callbackCancel = callback;
	}

	setSaveCallback(callback) {
		this.callbackSave = callback;
	}
	
	
	cancel() {
		if (this.callbackCancel) {
			this.callbackCancel();
		}
		
		$(this.container).empty();
	}
		


	save() {
		
		// TODO: validate => only description..?
		
		
		this.line.lineDescription = $(this.container).find('input[name=lineDescription]').val();
		this.line.number          = $(this.container).find('input[name=number]').val();
		this.line.vatId           = $(this.container).find('select[name=vatId]').val();
		
		let p = strtodouble( $(this.container).find('input[name=price]').val() );
		if (this.salesSettings.inputPrice == 'excl_vat') {
			this.line.amountExcl = p;
		}
		if (this.salesSettings.inputPrice == 'incl_vat') {
			this.line.amountIncl = p;
		}
		
		if (this.callbackSave) {
			this.callbackSave( this.line );
		}
		else {
			console.error('RentalContractForm, callbackSave not set');
		}
		
		
		$(this.container).empty();
	}
	
	
	async render() {
		this.salesSettings = await getSalesSettings();
		this.vats = await getVats();
		
		let ezTpl = new EzTemplate( this.container );
		ezTpl.loadHtml( this.tpl );
		
		ezTpl.setObject('widget', this);
		ezTpl.setVar('isNew', this.isNew);
		ezTpl.setVar('line', this.line);
		ezTpl.setVar('vats', this.vats);
		ezTpl.setVar('salesSettings', this.salesSettings);
		
		if (this.salesSettings.inputPrice == 'excl_vat') {
			ezTpl.setVar('price', this.line.amountExcl);
			ezTpl.setVar('priceVat', 'excl.');
		}
		if (this.salesSettings.inputPrice == 'incl_vat') {
			ezTpl.setVar('price', this.line.amountIncl);
			ezTpl.setVar('priceVat', 'incl.');
		}
		
		ezTpl.render();
		
		$('.contract-article-line-form').find('input[name=lineDescription]').focus();
	}
	
	
	
	
}

