
import { getSalesSettings } from './../RentalConstants.js';


export class ContractArticleLineForm {
	
	
	tpl = `
		<div class="contract-article-line-form">
	
			<div class="article-name">{{line.lineDescription}}</div>
			
			<ez-number label="{{_('Number')}}"
						name="number"
						step="1"
						min="1"
						[value]="line.number"></ez-number>
			
			<ez-price label="Price {{priceVat}}"
						name="price"
						[value]="price"></ez-price>
			
			
			<div style="margin-top: 25px;">
				<button [onclick]="widget.cancel">{{_('Cancel')}}</button>
				<button [onclick]="widget.save">{{_('Save')}}</button>
			</div
		</div>

	`;
	
	
	container = null;
	line = null;
	
	salesSettings = null;

	callbackCancel = null;
	callbackSave = null;
	
	
	constructor( container, line ) {
		this.container = container;
		this.line = line;
	}
	
	
	
	init(e) {
		this.container = e;
	}
	
	
	setCancelCallback( callback ) {
		this.callbackCancel = callback;
	}

	setSaveCallback(callback) {
		this.callbackSave = callback;
	}
	
	
	cancel() {
		if (this.callbackCancel) {
			this.callbackCancel();
		}
		
		$(this.container).empty();
	}
		


	save() {
		
		let p = strtodouble( $(this.container).find('input[name=price]').val() );
		
		if (this.salesSettings.inputPrice == 'excl_vat') {
			this.line.amountExcl = p;
		}
		if (this.salesSettings.inputPrice == 'incl_vat') {
			this.line.amountIncl = p;
		}
		
		if (this.callbackSave) {
			this.callbackSave( this.line );
		}
		else {
			console.error('RentalContractForm, callbackSave not set');
		}
		
		
		$(this.container).empty();
	}
	
	
	async render() {
		this.salesSettings = await getSalesSettings();
		
		let ezTpl = new EzTemplate( this.container );
		ezTpl.loadHtml( this.tpl );
		
		ezTpl.setObject('widget', this);
		ezTpl.setVar('line', this.line);
		ezTpl.setVar('salesSettings', this.salesSettings);
		
		if (this.salesSettings.inputPrice == 'excl_vat') {
			ezTpl.setVar('price', this.line.amountExcl);
			ezTpl.setVar('priceVat', 'excl.');
		}
		if (this.salesSettings.inputPrice == 'incl_vat') {
			ezTpl.setVar('price', this.line.amountIncl);
			ezTpl.setVar('priceVat', 'incl.');
		}
		
		
		ezTpl.render();
	}
	
	
	
	
}

