
import { RenewalTypes } from './RentalConstants.js';
import { RentalContractConfigureWidget } from './configure/RentalContractConfigureWidget.js';



export class RentalContractNewWidget {

	tpl = `
		<div class="rental-contract-widget">
		
			<div class="page-header">
				<div class="toolbox">
					<a href="javascript:void(0);" [onclick]="widget.goBack" class="fa fa-chevron-circle-left"></a>
				</div>
				
				<h1>{{ _('Add contract') }}</h1>
			</div>
			
			<div class="action-box" style="margin-bottom: 5px">
				<span><a href="javascript:void(0);" [onclick]="widget.createOffer_Click">{{_('Create offer')}}</a></span>
				
				<span><a href="javascript:void(0);" [onclick]="widget.createContract_Click">{{_('Create contract')}}</a></span>
			</div>
			
			<hr />
			
			<div class="rental-settings">
				<ez-customer name="customerId"
								[onchange]="widget.customerId_Change" 
								customerid="" 
								customername=""></ez-customer>
			</div>
			
			<div class="article-summary">
				<div class="tbl-rental-summary div-table">
					<div class="header">
						<div class="sort"></div>
						<div class="article-name">{{_('Article name')}}</div>
						<div class="article-amount">
							{{_('Amount')}}
						</div>
						<div class="price">
							{{_('Price')}}
							<span class="price-type"></span>
						</div>
						<div class="vat">
							{{_('Vat')}}
						</div>
						<div class="total-price-incl">
							{{_('Total incl.')}}
						</div>
						<div class="actions"></div>
					</div>
					<div id="tbody-articles">
						<div class="no-results-found">
							{{_('No articles selected')}}
						</div>
					</div>
					
					<div class="footer tbl-row" style="background-color: #fff !important; border-top: 1px solid #000; padding-top: 5px; margin-top: 10px;">
						<div class="sort">&nbsp;</div>
						<div class="article-name">&nbsp;</div>
						<div class="article-amount">&nbsp;</div>
						<div class="price">&nbsp;</div>
						<div class="vat">&nbsp;</div>
						<div class="total-price-incl">&nbsp;</div>
						<div class="actions">&nbsp;</div>
					</div>
						
				</div>
			</div>
			
			<div class="action-box">
				<span><a href="javascript:void(0);" [onclick]="widget.addPriceline_Click">{{_('Add price line')}}</a></span>
			</div>
			
			<hr/>
			
			<div class="article-search"></div>
			
		</div>
	`;
	
	tplArticles = `
		<div class="rental-contract-new-search">
			<ez-date id="art_date" label="{{_('Date')}}" value=""></ez-date>
			<input type="text" id="art_q" placeholder="{{_('Search...')}}" />
		</div>
		<table class="table">
			<thead>
				<tr>
					<th style="width: 50px;">{{ _('Rental') }}</th>
					<th>{{ _('Description') }}</th>
				</tr>
			</thead>
			<tbody ez-for="articles" ez-item="art">
				<tr class="clickable" [onclick]="widget.articleRow_Click" [article]="art">
					<td>{{art.rentable ? _('Yes') : _('No')}}</d>
					<td>{{art.shortDescription}}</d>
				</tr>
			</tbody>
		</table>
	`;
	
	
	container = null;
	
	ezTpl = null;

	
	ezTplArticles = null;
	artDate = null;
	artQ = null;
	
	salesSettings = null;
	vats = null;
	stateRestored = false;
	
	
	init( e ) {
		this.container = e;
		
		this.render();
	}
		
	
	restoreState() {
		if (this.stateRestored) return;
		
		this.stateRestored = true;
		
		let uuid = getUrlParam('uuid');
		let session = null;
		
		if (uuid) {
			session = getSession('rental-' + uuid, false);
		}
		
		if (uuid && session) {
			let state = getSession('rental-' + uuid);
			
			let tableSelector = document.querySelector('ez-customer[name=customerId] .ez-table-container').tsw;
			tableSelector.setValueText( state.customerId, state.customerName, {triggerChange: false} );
			
			
			// put back lines
			for(let i=0; i < state.lines.length; i++) {
				let line = state.lines[i];
				
				let tr = this.addArticle( line.article );
				
				// set props
				for(let i in line) {
					let inp = $(tr).find('[name=' + i + ']');
					if (inp.length > 0)
						inp.val( line[i] );
				}
			}
		}
		
		if (uuid && !session) {
			history.replaceState({}, '', appUrl('/sales/rental/new/'));
		}
		
		
		this.calculateTotals();
	}
	
		
	goBack() {
		gotoRoute( '/sales/rental/' );
	}
	
	
	
	customerId_Change() {
		this.saveState();
	}
	
	
	async searchArticles() {
		this.artDate = $('[name=art_date]').val();
		this.artQ = $('[name=art_q]').val();
		
		
		postJson( '/service/sales/rental/articleSearch.do', {
			art_date: this.artDate,
			q: this.artQ
		}).then( async (rec) => {
			let json = await rec.json();
			
			let c = $('.article-search');
			
			this.ezTplArticles = new EzTemplate( c );
			this.ezTplArticles.setObject('widget', this);
			this.ezTplArticles.setVar('articles', json.articles);
			this.ezTplArticles.setVar('salesSettings', json.salesSettings);
			this.ezTplArticles.loadHtml( this.tplArticles );
			
			this.ezTplArticles.render();

			if (this.salesSettings.inputPrice == 'excl_vat') {
				$('.price-type').text('excl.');
			}
			if (this.salesSettings.inputPrice == 'incl_vat') {
				$('.price-type').text('incl.');
			}
			
			$('#tbody-articles').sortable({
				handle: '.sort-handle',
				update: () => {
					this.saveState();
				}
			});
			
			this.restoreState();
		});
		
	}
	
	
	
	articleRow_Click( evt, tr ) {
		let article = tr.article;
		
		if (article.rentable) {
			let c = new RentalContractConfigureWidget( );
			c.init( article.articleId );
			c.setAddContract( (rentalLines) => {
				for(let i in rentalLines) {
					this.addArticle( rentalLines[i] );
				}
				
				this.saveState();
			});
		}
		else {
			this.addArticle( article );
			this.saveState();
		}
	}
	
	
	articleEdit_Click( evt, article ) {
		let r = $(evt.target).closest('div.tbl-row');

		let c = new RentalContractConfigureWidget( );
		c.initArticle( article );
		c.setAddContract( (c) => {
			this.addArticle( c[0], r.get(0) );
			this.saveState();
		});
		
	}
	
	
	addArticle( art, prevRow ) {
		
		let row = null;
		
		if (prevRow) {
			row = prevRow;
			prevRow.innerHTML = '';
		} else {
			row = document.createElement('div');
			row.className = 'tbl-row';
			row.article = art;
		}
		
		if (!prevRow && art.rentable) {
			row.className += ' rentable-line';
			row.addEventListener('click', (evt) => {
				if ( $(evt.target).hasClass('article-name') ) {
					this.articleEdit_Click( evt, art );
				}
			});
		}
		
		
		let tdSort = document.createElement('div');
		tdSort.className = 'sort';
		tdSort.innerHTML = '<span class="fa fa-bars sort-handle"></span>';
		
		let tdArticleName = document.createElement('div');
		tdArticleName.className = 'article-name';
		
		let tdAmount = document.createElement('div');
		tdAmount.className = 'article-amount';
		
		let tdPrice       = document.createElement('div');
		tdPrice.className = 'price';
		
		let tdVat       = document.createElement('div');
		tdVat.className = 'vat';
		tdVat.innerText = ' ';
		
		let tdTotalPriceIncl = document.createElement('div');
		tdTotalPriceIncl.className = 'total-price-incl';
		
		
		let tdActions     = document.createElement('div');
		tdActions.className = 'actions';
		
		
		// article name
		if (art.lineType == 'price') {
			let inpDesc = document.createElement('input');
			inpDesc.name = 'description';
			inpDesc.value = art.shortDescription ?? '';
			tdArticleName.appendChild( inpDesc );
			
			
			let svat = document.createElement('select');
			console.log('thisvats', this.vats);
			svat.name = 'vatId';
			let defaultVat = null;
			for(let i=0; i < this.vats.length; i++) {
				let opt = document.createElement('option');
				opt.value = this.vats[i].vatId;
				opt.innerText = this.vats[i].description;
				svat.appendChild(opt);
				
				if (this.vats[i].defaultSelected)
					defaultVat = this.vats[i];
			}
			tdVat.appendChild( svat );
			if (defaultVat)
				$(svat).val( defaultVat.vatId );
		}
		else {
			tdArticleName.innerText = art.shortDescription;
			
			let vat = this.getVatById( art.vatId );
			if (vat) {
				tdVat.innerText = format_percentage( vat.percentage );
			}
			else {
				tdVat.innerText = '-';
			}
		}
		
		if (art.rentable == false) {
			let inpAmount = document.createElement('input');
			inpAmount.className = 'amount';
			inpAmount.name = 'amount';
			inpAmount.type = 'number';
			inpAmount.min = 0;
			inpAmount.value = 1;
			inpAmount.addEventListener('change', ()=>{ this.saveState() });
			
			if (art.amount)
				inpAmount.value = art.amount;
			
			tdAmount.appendChild( inpAmount );
		}
		else {
			tdAmount.innerText = '1';
		}
		
		// price
		let iPrice = document.createElement('input');
		
		// art.price set by saveState()? => restore
		if (art.price) {
			iPrice.value = art.price;
		}
		else {
			if (this.salesSettings.inputPrice == 'excl_vat') {
				iPrice.value = art.priceExclVat ?? '';
			}
			if (this.salesSettings.inputPrice == 'incl_vat') {
				iPrice.value = art.priceInclVat ?? '';
			}
		}
		iPrice.value = format_price( iPrice.value, true );
		iPrice.addEventListener('change', function() { this.value = format_price(this.value, true); });
		iPrice.addEventListener('change', () => { this.calculateTotals() });
		iPrice.className = 'price';
		iPrice.name = 'price';
		tdPrice.append( iPrice );
		
		tdTotalPriceIncl.innerText = '-';
		
		// actions
		let adel = document.createElement('a');
		adel.href = 'javascript:void(0);';
		adel.className = 'fa fa-remove';
		adel.onclick = (evt) => {
			this.removeRow_Click( evt );
		};
		
		tdActions.className='actions';
		tdActions.append( adel );
		
		
		
		// add columns
		row.appendChild( tdSort );
		row.appendChild( tdArticleName );
		row.appendChild( tdAmount );
		row.appendChild( tdPrice );
		row.appendChild( tdVat );
		row.appendChild( tdTotalPriceIncl );
		row.appendChild( tdActions );
		
		document.getElementById('tbody-articles').appendChild( row );
		
		
		return row;
	}
	
	calculateTotals() {
		
		let tamount = 0;
		let tprice = 0;
		
		let ttotalExcl = 0;
		let ttotal = 0;
		
		// loop through lines
		$('.article-summary #tbody-articles .tbl-row').each((index, node) => {
			// get amount
			let a = 0;
			if ($(node).find('input.amount').length > 0) {
				a = $(node).find('input.amount').val();
			}
			else {
				a = $(node).find('input.amount').text();
			}
			a = strtodouble(a);
			if (isNaN(a)) a = 1;
			tamount += a;
			
			// get input price
			let p = $(node).find('input.price').val();
			p = strtodouble(p);
			if (isNaN(p)) p=0;
			tprice += p;
			
			// input excl?
			if (this.salesSettings.inputPrice == 'excl_vat') {
				
				let vatId = 0;
				if ($(node).find('[name=vatId]').length > 0)
					vatId = $(node).find('[name=vatId]').val();
				else if (node.article)
					vatId = node.article.vatId;
				
				let vatpercentage = 0;
				if ( vatId ) {
					let vat = this.getVatById( vatId );
					vatpercentage = vat.percentage;
				}
				
				let priceVat = roundNumber(p * vatpercentage / 100)
				let totalPriceline = roundNumber( (p + priceVat) * a );
				
				$(node).find('.total-price-incl').text( format_price( totalPriceline, true) );
				
				ttotalExcl += roundNumber( p * a );
				ttotal += totalPriceline;
			}
			
			// input incl?
			if (this.salesSettings.inputPrice == 'incl_vat') {
				let totalPriceline = roundNumber( p * a );
				
				$(node).find('.total-price-incl').text( format_price( totalPriceline, true) );
				
				ttotal += totalPriceline;
			}
			
		});
		
		// show totals
		$('.article-summary .footer .article-amount').text( tamount );
		if (this.salesSettings.inputPrice == 'excl_vat') {
			$('.article-summary .footer .price').text( format_price(ttotalExcl, true) );
		}
		$('.article-summary .footer .total-price-incl').text( format_price(ttotal, true) );
	}
	
	
	addPriceline_Click() {
		let l = {};
		l.lineType = 'price';
		l.rentable = false;
		
		this.addArticle(l);
		
		this.saveState();
	}
	
	
	
	removeRow_Click( evt ) {
		$(evt.target).closest('.tbl-row').remove();
		
		this.saveState();
	}
	
	
	saveState() {
//		throw new Error('blabla'); 
		let uuid = getUrlParam('uuid');
		if (!uuid)
			uuid = crypto.randomUUID();
		
		
		// get session
		let wizard = getSession('rental-' + uuid, {});
		
		// get state
		let state = this.getState();
		
		
		// set lines
		wizard = Object.assign( wizard, state );
		
		// save session
		setSession('rental-' + uuid, wizard);
		
		// update url for back
		if (getUrlParam('uuid') != uuid)
			history.replaceState({}, '', appUrl('/sales/rental/new/?uuid=' + uuid));
		
		this.calculateTotals();
		
		return uuid;
	}
	
	getState() {
		
		let state = {};
		
		state.customerId = $('input[name=customerId]').val();
		state.customerName = $('ez-customer[name=customerId] .widget-default-text').text();
		
		
		state.lines = [];
		
		$('#tbody-articles .tbl-row').each(function(index, node) {
			let line = {};
			line.article = node.article;
			
			$(node).find('input, select').each(function(i2, n2) {
				let name = n2.name;
				if (!name || name == '')
					return;
				
				// TODO: checkbox support?
				
				line[name] = n2.value;
			});
			
			state.lines.push( line );
		});
		
		// put in an object.. maybe other data will be added in the future
		return state;
	}
	
	
	getVatById( vatId ) {
		for(let i in this.vats) {
			if (this.vats[i].vatId == vatId) {
				return this.vats[i];
			}
		}
		return null;
	}
	
	
	async createOffer_Click() {
		let s = this.getState();
		s.a = 'createOffer';
		
		let r = await postJson('/service/sales/rental/rental.do', s);
		
		let json = await r.json();
		
		
		if (json.success) {
			let uuid = getUrlParam('uuid');
			removeSession('rental-'+uuid);
			
			reportUserMessage( _('Offer created') );
			
			gotoRoute( '/sales/offer/edit/?id=' + json.offerId );
		}
		else {
			formShowErrors('.rental-settings', json);
		}
	}
	
	async createContract_Click() {
		let s = this.getState();
		s.a = 'createContract';

		let r = await postJson('/service/sales/rental/rental.do', s);

		let json = await r.json();
		
		if (json.success) {
			let uuid = getUrlParam('uuid');
			removeSession('rental-'+uuid);
	
			reportUserMessage( _('Contract created') );
	
			gotoRoute( '/sales/rental/edit/?id=' + json.rentalContractId );
		}
		else {
			formShowErrors('.rental-settings', json);
		}
	}
	
	async initSettings() {
		// get settings
		let salesSettingsResponse = await postJson('/service/sales/settings.do');
		let settingsJson = await salesSettingsResponse.json();
		this.salesSettings = settingsJson.settings;
		this.vats = settingsJson.vats;
	}
	
	
	async render() {
		await this.initSettings();
		
		// render
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.setVar('salesSettings', this.salesSettings);
		
		this.ezTpl.loadHtml( this.tpl );
		
		this.ezTpl.render();
		
		// initial search
		this.searchArticles();
	}
	
}

